/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_roinameSubpart(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char subpart[256];
  char tname[256];
  int si;

  strcpy(tname, "eka_toka_kolmas_neljas");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  si=0; while(roinameSubpart(tname, " _", si, subpart, 12)) {
    if(verbose>2) printf("  subpart%d := '%s'\n", si+1, subpart);
    si++;
  }
  if(si!=4) return(1);

  strcpy(tname, "_toka__nelja_");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  si=0; while(roinameSubpart(tname, " _", si, subpart, 12)) {
    if(verbose>2) printf("  subpart%d := '%s'\n", si+1, subpart);
    si++;
  }
  if(si!=5) return(2);

  strcpy(tname, "_");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  si=0; while(roinameSubpart(tname, " _", si, subpart, 12)) {
    if(verbose>2) printf("  subpart%d := '%s'\n", si+1, subpart);
    si++;
  }
  if(si!=2) return(3);

  strcpy(tname, "__");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  si=0; while(roinameSubpart(tname, " _", si, subpart, 12)) {
    if(verbose>2) printf("  subpart%d := '%s'\n", si+1, subpart);
    si++;
  }
  if(si!=3) return(4);

  strcpy(tname, " _ ");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  si=0; while(roinameSubpart(tname, " _", si, subpart, 12)) {
    if(verbose>2) printf("  subpart%d := '%s'\n", si+1, subpart);
    si++;
  }
  if(si!=4) return(5);

  strcpy(tname, " _ ");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  si=0; while(roinameSubpart(tname, "_", si, subpart, 12)) {
    if(verbose>2) printf("  subpart%d := '%s'\n", si+1, subpart);
    si++;
  }
  if(si!=2) return(6);

  char tmp[7];
  strcpy(tname, "one_two_andthensomethinglong_four");
  if(verbose>1) printf("\ntacname='%s'\n", tname);
  roinameSubpart(tname, "_", 2, tmp, 7);
  if(verbose>2) printf("  subpart3 := '%s'\n", tmp);
  if(strcmp(tmp, "andthe")!=0) return(11);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_roinameEditByTemplate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char temp[256], oldname[256], newname[256];
  
  strcpy(oldname, "Str sn Pl006");
  strcpy(temp, "@_sin_@");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "Str_sin_Pl006")!=0) return(1);
  
  strcpy(oldname, "Str sn Pl006");
  strcpy(temp, "@_sin");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "Str_sin")!=0) return(2);
  
  strcpy(oldname, "Str sn Pl006");
  strcpy(temp, "@_sin_all");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "Str_sin_all")!=0) return(3);
  
  
  strcpy(oldname, "");
  strcpy(temp, "newname");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "newname")!=0) return(11);
  
  strcpy(oldname, "oldname");
  strcpy(temp, "");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "")!=0) return(12);
  
  
  strcpy(oldname, "str_dx");
  strcpy(temp, "i26_@_@_@");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "i26_dx")!=0) return(21);
  
  strcpy(oldname, "_str_dx");
  strcpy(temp, "i26_@_@_@");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 256);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "i26_str_dx")!=0) return(22);

  if(verbose>1) printf("\n limited size \n");

  strcpy(oldname, "paramedian pontine reticular formation");
  strcpy(temp, "@_@_@_@_@");
  if(verbose>1) printf("\ntemplate='%s'\n", temp);
  roinameEditByTemplate(temp, oldname, newname, 21);
  if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
  if(strcmp(newname, "paramedian_pontine_r")!=0) return(31);
  {
    char newname[21];
    if(verbose>1) printf("\ntemplate='%s'\n", temp);
    roinameEditByTemplate(temp, oldname, newname, 21);
    if(verbose>1) printf("'%s' -> '%s'\n", oldname, newname);
    if(strcmp(newname, "paramedian_pontine_r")!=0) return(32);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_roinameAddField(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char temp[256], oldname[256], newname[256];
  unsigned int i;
  
  strcpy(oldname, "Str Pl006"); strcpy(newname, oldname);
  strcpy(temp, "sin"); i=2;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "Str_sin_Pl006")!=0) return(1);

  strcpy(oldname, "Str Pl006"); strcpy(newname, oldname);
  strcpy(temp, "TPC"); i=1;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "TPC_Str_Pl006")!=0) return(2);

  strcpy(oldname, "Str sin Pl006"); strcpy(newname, oldname);
  strcpy(temp, "TPC"); i=100;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "Str_sin_Pl006_TPC")!=0) return(3);

  strcpy(oldname, "Str sin Pl006"); strcpy(newname, oldname);
  strcpy(temp, "TPC"); i=4;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "Str_sin_Pl006_TPC")!=0) return(4);


  strcpy(oldname, "Str sin Pl006"); strcpy(newname, oldname);
  strcpy(temp, ""); i=1;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "_Str_sin_Pl006")!=0) return(11);

  strcpy(oldname, "Str sin Pl006"); strcpy(newname, oldname);
  strcpy(temp, ""); i=3;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "Str_sin__Pl006")!=0) return(12);

  strcpy(oldname, "Str sin Pl006"); strcpy(newname, oldname);
  strcpy(temp, ""); i=4;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "Str_sin_Pl006_")!=0) return(13);


  strcpy(oldname, ""); strcpy(newname, oldname);
  strcpy(temp, ""); i=1;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "_")!=0) return(21);

  strcpy(oldname, ""); strcpy(newname, oldname);
  strcpy(temp, "_"); i=1;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "_")!=0) return(22);

  strcpy(oldname, ""); strcpy(newname, oldname);
  strcpy(temp, "striatum"); i=1;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  roinameAddField(newname, temp, i-1, 256);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, "striatum")!=0) return(23);


  if(verbose>1) printf("\n limited size \n");
  char *p;

  strcpy(oldname, "paramedian_pontine_formation");
  strcpy(newname, oldname);
  strcpy(temp, "reticular"); i=3;
  if(verbose>1) 
    printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
  p=roinameAddField(newname, temp, i-1, 20);
  if(p!=NULL) return(31);
  if(verbose>1) printf(" -> '%s'\n", newname);
  if(strcmp(newname, oldname)!=0) return(32);
  
  strcpy(oldname, "0123456789");
  {
    char newname[20]; 
    
    strcpy(newname, oldname);
    strcpy(temp, "0123456789"); i=3;
    if(verbose>1) 
      printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
    p=roinameAddField(newname, temp, i-1, 20);
    if(p!=NULL) return(33);
    if(verbose>1) printf(" -> '%s'\n", newname);
    if(strcmp(newname, oldname)!=0) return(34);

    strcpy(newname, oldname);
    strcpy(temp, "012345678"); i=2;
    if(verbose>1) 
      printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
    p=roinameAddField(newname, temp, i-1, 20);
    if(p!=NULL) return(35);
    if(verbose>1) printf(" -> '%s'\n", newname);
    if(strcmp(newname, oldname)!=0) return(36);

    strcpy(newname, oldname);
    strcpy(temp, "01234567"); i=2;
    if(verbose>1) 
      printf("\nAdd '%s' in position %d in '%s' \n", temp, i, oldname);
    p=roinameAddField(newname, temp, i-1, 20);
    if(p==NULL) return(37);
    if(verbose>1) printf(" -> '%s'\n", newname);
    if(strcmp(newname, "0123456789_01234567")!=0) return(38);

  }


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_roinameExists(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char str[256];
  int ret;

  strcpy(str, ""); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(1);

  strcpy(str, "a"); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(!ret) return(2);

  strcpy(str, " "); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(3);

  strcpy(str, "."); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(4);

  strcpy(str, "-"); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(5);

  strcpy(str, "__"); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(6);

  strcpy(str, "._."); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(7);

  strcpy(str, "_._"); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(ret) return(8);

  strcpy(str, "str dx"); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(!ret) return(9);

  strcpy(str, "__Pl09"); ret=roinameExists(str);
  if(verbose>1) printf("'%s' -> %d\n", str, ret);
  if(!ret) return(10);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_roinameMatch(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int n;
  
  /* If both name and test string are empty, we should get a match */
  n=roinameMatch(NULL, NULL, status); if(n!=1) return 1;
  n=roinameMatch("", NULL, status); if(n!=1) return 2;
  n=roinameMatch(NULL, "", status); if(n!=1) return 3;
  n=roinameMatch("", "", status); if(n!=1) return 4;
  
  /* If only either of them is empty, we should get no match */
  n=roinameMatch("meh", NULL, status); if(n) return 5;
  n=roinameMatch("meh", "", status); if(n) return 6;
  n=roinameMatch(NULL, "meh", status); if(n) return 7;
  n=roinameMatch("", "meh", status); if(n) return 8;
  
  char tacname[128], refname[128];

  /* This certainly should not match */
  strcpy(tacname, "region"); strcpy(refname, "tappi");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(n) return 11;
  
  /* Asterisk should match with anything */
  strcpy(tacname, "region"); strcpy(refname, "*");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 21;

  strcpy(tacname, "region"); strcpy(refname, "reg*");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 22;
  
  strcpy(tacname, "region"); strcpy(refname, "reg2*");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(n) return 23;

  strcpy(tacname, "region"); strcpy(refname, "RE*");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 24;
  
  /* Subnames */
  strcpy(tacname, "region_dx"); strcpy(refname, "region");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 31;
  
  strcpy(tacname, "region_dx"); strcpy(refname, "dx");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 32;
  
  strcpy(tacname, "region_dx_Mean"); strcpy(refname, "mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 33;

  strcpy(tacname, "region_sin_Mean"); strcpy(refname, "region_sin_mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 34;

  strcpy(tacname, "region_dx_mean"); strcpy(refname, "region_sin_mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(n) return 35;
  
  /* subnames with wildcards */
  strcpy(tacname, "region_sin_Mean"); strcpy(refname, "region_*_mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 41;
  
  strcpy(tacname, "region_sin_Mean"); strcpy(refname, "region * mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 42;

  strcpy(tacname, "region_sin_Mean"); strcpy(refname, "region_*_*");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 43;
  
  strcpy(tacname, "region_sin_Mean"); strcpy(refname, "*_*_*");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 44;

  strcpy(tacname, "region_sin_Mean"); strcpy(refname, "*_sin_mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 45;

  /* Missing subnames */
  strcpy(tacname, "region__Mean"); strcpy(refname, "region . mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 51;
  
  strcpy(tacname, "region_._Mean"); strcpy(refname, "region . mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(!n) return 52;

  strcpy(tacname, "region___"); strcpy(refname, "region . mean");
  n=roinameMatch(tacname, refname, status);
  if(verbose>1) printf("roinameMatch('%s', '%s') := %d\n", tacname, refname, n);
  if(n) return 53;
  
    
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
