/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_studynrVerify(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;
  char str[32];

  ret=studynrVerify(NULL, 1); if(ret==0) return 1;

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret==0) return 2;

  strcpy(str, "a1"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret!=0) return 3;

  strcpy(str, "A01"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret!=0) return 4;

  strcpy(str, "ABCDE"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret==0) return 5;

  strcpy(str, "abcde12345"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret!=0) return 6;

  strcpy(str, "abcde123456"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret==0) return 7;

  strcpy(str, "abcdef12345"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret==0) return 8;

  strcpy(str, "di/ab12"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret==0) return 9;

  strcpy(str, "abc00012"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 1); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret!=0) return 11;

  strcpy(str, "abc00012"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrVerify(str, 0); if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret==0) return 12;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_studynrStandardize(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;
  char str[32];

  ret=studynrStandardize(NULL); if(ret==0) return 1;

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrStandardize(str); if(verbose>2) printf("  -> '%s'\n", str);
  if(ret==0) return 2;

  strcpy(str, "a00123"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrStandardize(str); if(verbose>2) printf("  -> '%s'\n", str);
  if(ret!=0) return 3;
  if(strcmp(str, "a123")!=0) return 3;

  strcpy(str, "ABC123"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrStandardize(str); if(verbose>2) printf("  -> '%s'\n", str);
  if(ret!=0) return 4;
  if(strcmp(str, "abc123")!=0) return 4;

  strcpy(str, "A00123"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrStandardize(str); if(verbose>2) printf("  -> '%s'\n", str);
  if(ret!=0) return 5;
  if(strcmp(str, "a123")!=0) return 5;

  strcpy(str, "1A"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrStandardize(str); if(verbose>2) printf("  -> '%s'\n", str);
  if(ret==0) return 6;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_studynrFromFilename(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;
  char str[64], studynr[MAX_STUDYNR_LEN+1];

  ret=studynrFromFilename(NULL, NULL, 1); if(ret==0) return 1;

  strcpy(str, ""); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrFromFilename(str, studynr, 1);
  if(verbose>2) printf("  -> '%s'\n", studynr);
  if(ret==0) return 2;

  strcpy(str, "a00123"); if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrFromFilename(str, studynr, 1);
  if(verbose>2) printf("  -> '%s'\n", studynr);
  if(ret!=0) return 3;
  if(strcmp(studynr, "a00123")!=0) return 3;
  ret=studynrFromFilename(str, studynr, 0);
  if(verbose>2) printf("  -> '%s' (ret=%d)\n", studynr, ret);
  if(ret!=0) return 4;
  if(strcmp(studynr, "a123")!=0) return 4;

  strcpy(str, "C:\\temp\\A00123AP.KBQ");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrFromFilename(str, studynr, 1);
  if(verbose>2) printf("  -> '%s'\n", studynr);
  if(ret!=0) return 5;
  if(strcmp(studynr, "A00123")!=0) return 5;
  ret=studynrFromFilename(str, studynr, 0);
  if(verbose>2) printf("  -> '%s'\n", studynr);
  if(ret!=0) return 6;
  if(strcmp(studynr, "a123")!=0) return 6;

  strcpy(str, "C:\\temp\\123_AP.KBQ");
  if(verbose>1) printf("str := '%s'\n", str);
  ret=studynrFromFilename(str, studynr, 1);
  if(verbose>2) printf("  -> '%s'\n", studynr);
  if(ret!=0) return 7;
  if(strcmp(studynr, "123")!=0) return 7;
  ret=studynrFromFilename(str, studynr, 0);
  if(ret==0) return 8;


  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
