#ifndef _TEST_TPCEXTENSIONS_H_
#define _TEST_TPCEXTENSIONS_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <math.h>
/*****************************************************************************/

/*****************************************************************************/
/* stringext */
extern int test_strTokenNr(TPCSTATUS *status);
extern int test_strTokenNCpy(TPCSTATUS *status);
extern int test_strChrCount(TPCSTATUS *status);
extern int test_strReplaceChar(TPCSTATUS *status);
#ifndef HAVE_STRNDUP // Test only if own implementation is used
extern int test_strndup(TPCSTATUS *status);
#endif
extern int test_strstrNoQuotation(TPCSTATUS *status);
extern int test_strncpyCleanSpaces(TPCSTATUS *status);
extern int test_strCleanSpaces(TPCSTATUS *status);
extern int test_strncpyClean(TPCSTATUS *status);
extern int test_strClean(TPCSTATUS *status);
extern int test_strTokenDup(TPCSTATUS *status);
extern int test_strInPars(TPCSTATUS *status);
extern int test_strCleanPars(TPCSTATUS *status);
extern int test_strncatInt(TPCSTATUS *status);
extern int test_strncatDouble(TPCSTATUS *status);
extern int test_strncatIntZ(TPCSTATUS *status);
#ifndef HAVE_STRNLEN // Test only if own implementation is used
extern int test_strnlen(TPCSTATUS *status);
#endif
#ifndef HAVE_STRLCAT // Test only if own implementation is used
extern int test_strlcat(TPCSTATUS *status);
#endif
#ifndef HAVE_STRLCPY // Test only if own implementation is used
extern int test_strlcpy(TPCSTATUS *status);
#endif
extern int test_strIsSpaceOnly(TPCSTATUS *status);
extern int test_strdelstr(TPCSTATUS *status);
extern int test_strTrimLeft(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* decpoint */
extern int test_strIsValidNumber(TPCSTATUS *status);
extern int test_atofVerified(TPCSTATUS *status);
extern int test_atofCheck(TPCSTATUS *status);
extern int test_strHaveDecimalComma(TPCSTATUS *status);
extern int test_strHaveDecimalSeparator(TPCSTATUS *status);
extern int test_atofList(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* filename */
extern int test_filenameRmPath(TPCSTATUS *status);
extern int test_filenameRmFile(TPCSTATUS *status);
extern int test_filenameRmExtension(TPCSTATUS *status);
extern int test_filenameRmExtensions(TPCSTATUS *status);
extern int test_fnmatch(TPCSTATUS *status);
extern int test_fncasematch(TPCSTATUS *status);
extern int test_filenameGetExtension(TPCSTATUS *status);
extern int test_filenameGetExtensions(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* proginfo */
extern int test_tpcProcessStdOptions(TPCSTATUS *status);
extern int test_tpcPrintUsage(TPCSTATUS *status);
extern int test_tpcPrintBuild(TPCSTATUS *status);
extern int test_tpcProgramName(TPCSTATUS *status);
extern int test_tpcYesNo(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* units */
extern int test_unitName(TPCSTATUS *status);
extern int test_unitIdentify(TPCSTATUS *status);
extern int test_unitIdentifyFilename(TPCSTATUS *status);
extern int test_unitIsDistance(TPCSTATUS *status);
extern int test_unitIsTime(TPCSTATUS *status);
extern int test_unitIsVolume(TPCSTATUS *status);
extern int test_unitIsMass(TPCSTATUS *status);
extern int test_unitIsMole(TPCSTATUS *status);
extern int test_unitIsRadioactivity(TPCSTATUS *status);
extern int test_unitIsRAConc(TPCSTATUS *status);
extern int test_unitIsCombinatorial(TPCSTATUS *status);
extern int test_unitConversionFactor(TPCSTATUS *status);
extern int test_unitInverse(TPCSTATUS *status);
extern int test_unitDividerHasVolume(TPCSTATUS *status);
extern int test_unitDividerHasMass(TPCSTATUS *status);
extern int test_unitDividendHasRadioactivity(TPCSTATUS *status);
extern int test_unitCombination(TPCSTATUS *status);
extern int test_unitDividerMassVolumeConversion(TPCSTATUS *status);
extern int test_unitMultiply(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* statusmsg */
extern int test_statusPrint(TPCSTATUS *status);
extern int test_errorMsg(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* readasciifile */
extern int test_asciiFileSize(TPCSTATUS *status);
extern int test_asciiFileRead(TPCSTATUS *status);
extern int test_asciiCommentLine(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* datetime */
extern int test_strDateValid(TPCSTATUS *status);
extern int test_strDateValid2(TPCSTATUS *status);
extern int test_strDateValid3(TPCSTATUS *status);
extern int test_strDateValid4(TPCSTATUS *status);
extern int test_strTimeValid(TPCSTATUS *status);
extern int test_strDateTimeValid(TPCSTATUS *status);
extern int test_strDateTimeRead(TPCSTATUS *status);
extern int test_strDateRead(TPCSTATUS *statuse);
extern int test_time_to_tm(TPCSTATUS *status);
extern int test_tmDifference(TPCSTATUS *status);
extern int test_tmAdd(TPCSTATUS *status);
extern int test_strDateTimeDifference(TPCSTATUS *status);
extern int test_strDateTimeAdd(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* studynr */
extern int test_studynrVerify(TPCSTATUS *status);
extern int test_studynrStandardize(TPCSTATUS *status);
extern int test_studynrFromFilename(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* doubleutil */
extern int test_doubleMatch(TPCSTATUS *status);
extern int test_doubleArrayMatch(TPCSTATUS *status);
extern int test_doubleMatchRel(TPCSTATUS *status);
extern int test_doubleMachEps(TPCSTATUS *status);
extern int test_doubleCopy(TPCSTATUS *status);
extern int test_doubleCopyFinite(TPCSTATUS *status);
extern int test_doubleNaNs(TPCSTATUS *status);
extern int test_doubleRange(TPCSTATUS *status);
extern int test_doubleSum(TPCSTATUS *status);
extern int test_doubleMean(TPCSTATUS *status);
extern int test_doubleWMean(TPCSTATUS *status);
extern int test_doubleGetWithUnit(TPCSTATUS *status);
extern int test_doubleSpanPositives(TPCSTATUS *status);
extern int test_doubleCSpanPositives(TPCSTATUS *status);
extern int test_doubleNonzeroes(TPCSTATUS *status);
extern int test_doubleMaxIndex(TPCSTATUS *status);
extern int test_doubleAbsMaxIndex(TPCSTATUS *status);
extern int test_doubleMinIndex(TPCSTATUS *status);
extern int test_doubleAbsMinIndex(TPCSTATUS *status);
extern int test_doubleGEIndex(TPCSTATUS *status);
extern int test_doubleGTIndex(TPCSTATUS *status);
extern int test_inverfc(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* floatutil */
extern int test_floatMatch(TPCSTATUS *status);
extern int test_floatMatchRel(TPCSTATUS *status);
extern int test_floatMachEps(TPCSTATUS *status);
extern int test_floatCopy(TPCSTATUS *status);
extern int test_floatMaxIndex(TPCSTATUS *status);
extern int test_floatSum(TPCSTATUS *status);
extern int test_floatMean(TPCSTATUS *status);
extern int test_floatGetWithUnit(TPCSTATUS *status);
extern int test_floatSpanPositives(TPCSTATUS *status);
extern int test_floatCSpanPositives(TPCSTATUS *status);
extern int test_floatNonzeroes(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* intutil */
extern int test_atoiCheck(TPCSTATUS *status);
extern int test_factorial(TPCSTATUS *status);
extern int test_lfactorial(TPCSTATUS *status);
extern int test_intlistInit(TPCSTATUS *status);
extern int test_intlistFree(TPCSTATUS *status);
extern int test_intlistAdd(TPCSTATUS *status);
extern int test_intlistSort(TPCSTATUS *status);
extern int test_intlistAddFromString(TPCSTATUS *status);
extern int test_intlistExpandFromString(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* roiname */
extern int test_roinameSubpart(TPCSTATUS *status);
extern int test_roinameEditByTemplate(TPCSTATUS *status);
extern int test_roinameAddField(TPCSTATUS *status);
extern int test_roinameExists(TPCSTATUS *status);
extern int test_roinameMatch(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* endian */
extern int test_endianness(TPCSTATUS *status);
extern int test_endianLittle(TPCSTATUS *status);
extern int test_swap(TPCSTATUS *status);
extern int test_swabip(TPCSTATUS *status);
extern int test_swawbip(TPCSTATUS *status);
extern int test_swawip(TPCSTATUS *status);
extern int test_swap64ip(TPCSTATUS *status);
extern int test_swap32ip(TPCSTATUS *status);
extern int test_swap16ip(TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TEST_TPCEXTENSIONS */
