/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpccsv.h"
#include "test_tpcfcmc.h"
/*****************************************************************************/

/*****************************************************************************/
int test_fcmcInit(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  FCMC fcmc;
  fcmcInit(&fcmc);
  fcmcInit((FCMC*)NULL);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fcmcFree(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  FCMC fcmc;
  fcmcInit(&fcmc);
  fcmcFree(&fcmc);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fcmcAllocate(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  FCMC fcmc;
  fcmcInit(&fcmc);

  if(verbose>0) printf("\n Calling function with empty data \n");
  ret=fcmcAllocate(NULL, 0, 0, 0);
  if(ret==0) {fcmcFree(&fcmc); return(1);}

  if(verbose>0) printf("\n Calling function with zeroes \n");
  ret=fcmcAllocate(&fcmc, 0, 10, 3);
  if(ret==0) {fcmcFree(&fcmc); return(2);}
  ret=fcmcAllocate(&fcmc, 10, 0, 3);
  if(ret==0) {fcmcFree(&fcmc); return(3);}
  ret=fcmcAllocate(&fcmc, 10, 4, 0);
  if(ret==0) {fcmcFree(&fcmc); return(4);}

  if(verbose>0) printf("\n Calling function with valid values \n");
  ret=fcmcAllocate(&fcmc, 20, 4, 3);
  if(ret!=0) {fcmcFree(&fcmc); return(11);}
  if(fcmc.sampleNr!=20) {fcmcFree(&fcmc); return(12);}
  if(fcmc.dimNr!=4) {fcmcFree(&fcmc); return(13);}
  if(fcmc.clusterNr!=3) {fcmcFree(&fcmc); return(14);}
  fcmcFree(&fcmc);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_fcmclustering(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  FCMC fcmc;
  fcmcInit(&fcmc);

  if(verbose>0) printf("\n Calling function with empty data \n");
  ret=fcmclustering(&fcmc, 1, 0);
  if(ret==0) {fcmcFree(&fcmc); return(1);}

  if(verbose>0) printf("\n Reading test data \n");
  FILE *fp;
  fp=fopen("iris.tsv", "r");
  if(fp==NULL) {
    fprintf(stderr, "Error: cannot open file 'iris.tsv'\n");
    return(10);
  }
  CSV csv; csvInit(&csv);
  ret=csvRead(&csv, fp, NULL);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error: cannot read file 'iris.tsv'\n");
    csvFree(&csv); fcmcFree(&fcmc);
    return(11);
  }
  if(verbose>10) {
    printf("CSV.row_nr := %d\n", csv.row_nr);
    printf("CSV.col_nr := %d\n", csv.col_nr);
  }

  if(verbose>0) printf("\n Copying test data into FCMC struct\n");
  ret=fcmcAllocate(&fcmc, csv.row_nr, csv.col_nr-1, 3);
  if(ret!=0) {
    fprintf(stderr, "Error: cannot allocate memory for FCMC.\n");
    csvFree(&csv); fcmcFree(&fcmc);
    return(12);
  }
  for(unsigned int row=0; row<fcmc.sampleNr; row++) {
    for(unsigned int col=0; col<fcmc.dimNr; col++) {
      fcmc.d[row][col]=atof(csvCell(&csv, row, col));
    }
  }
  if(verbose>1000) fcmcPrint(&fcmc, stdout);

  if(verbose>0) printf("\n Copying correct types from the last column\n");
  unsigned int corrtyp[fcmc.sampleNr];
  for(unsigned int row=0; row<fcmc.sampleNr; row++) {
    corrtyp[row]=atoi(csvCell(&csv, row, csv.col_nr-1));
  }
  csvFree(&csv);

  if(verbose>0) printf("\n Clustering... \n");
  ret=fcmclustering(&fcmc, 2, verbose-10);
  if(ret!=0) {
    fprintf(stderr, "Error: clustering not successful.\n");
    fcmcFree(&fcmc);
    return(13);
  }
  if(verbose>10) {
    printf("\nSample\tCluster\tCorrect\n");
    for(unsigned int si=0; si<fcmc.sampleNr; si++)
      printf("%u\t%u\t%u\n", si+1, fcmc.sc[si], corrtyp[si]);
    printf("\n"); fflush(stdout);
  }

  if(verbose>0) printf("\n Checking success rate\n");
  // with this data the success rate should NOT BE perfect, but over 90% 
  unsigned int okNr=0;
  for(unsigned int si=0; si<fcmc.sampleNr; si++)
    if(fcmc.sc[si]==corrtyp[si]) okNr++;
  double succrate=(double)okNr/(double)fcmc.sampleNr;
  if(verbose>1) printf("success_rate := %.2f%%\n", 100.*succrate);
  if(succrate<0.92) {
    fprintf(stderr, "Error: too low success rate.\n");
    fcmcFree(&fcmc);
    return(15);
  }


  fcmcFree(&fcmc);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
