/** @file tpcfcmc.h
 *  @brief Header file for library libtpcfcmc.
 *  @details Fuzzy C means Clustering algorithm.
 *  @author Vesa Oikonen
 */
#ifndef _TPCFCMC_H_
#define _TPCFCMC_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
/** Data struct for Fuzzy C means clustering algorithm. */
typedef struct FCMC {
  /** Max number of iterations. */
  unsigned int maxIter;
  /** Accetance limit for max u difference. */
  double limitMaxUDiff;
  /** Fuzzyness coefficient. */
  unsigned int fc;

  /** Number of data samples. */
  unsigned int sampleNr;
  /** Dimensionality of data. */
  unsigned int dimNr;
  /** Number of clusters. */
  unsigned int clusterNr;

  /** Data, d[0..sampleNr-1][0..dimNr-1]. */
  double **d;
  /** Centre of each cluster, cc[0..clusterNr-1][0..dimNr-1]. */
  double **cc;
  /** The member cluster for each sample, sc[0..sampleNr-1]. */
  unsigned int *sc;
} FCMC;
/*****************************************************************************/

/*****************************************************************************/
/* fcmc */
extern void fcmcInit(FCMC *fcmc);
extern void fcmcFree(FCMC *fcmc);
extern int fcmcAllocate(FCMC *fcmc, unsigned int sampleNr, unsigned int dimNr, unsigned int clusterNr);
extern void fcmcPrint(FCMC *fcmc, FILE *fp);
extern int fcmcClusterInitialize(FCMC *fcmc, const int cinit, int verbose);
extern int fcmclustering(FCMC *fcmc, const int cinit, int verbose);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCFCMC */
