/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcift.h"
/*****************************************************************************/

/*****************************************************************************/
int test_iftInit(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  iftInit(&ift);
  iftInit((IFT*)NULL);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftFree(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  iftInit(&ift);
  iftFree(&ift);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftPut(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  iftInit(&ift);
  ret=iftPut(&ift, "testkey", "testvalue", 0, NULL);
  iftFree(&ift); if(ret!=0) return 1;
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftPutDouble(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  iftInit(&ift);
  ret=iftPutDouble(&ift, "testkey", 3.14, 0, NULL);
  iftFree(&ift); if(ret!=0) return 1;
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftPutInt(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret, v;
  iftInit(&ift);
  ret=iftPutInt(&ift, "testkey", 3, 0, NULL);
  if(ret!=0) {iftFree(&ift); return(11);}
  ret=iftGetInt(&ift, 0, &v);
  iftFree(&ift); if(ret!=0 || v!=3) return(12);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftPutUInt(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  unsigned int v;
  iftInit(&ift);
  ret=iftPutUInt(&ift, "testkey", 87654321, 0, NULL);
  if(ret!=0) {iftFree(&ift); return(11);}
  ret=iftGetUInt(&ift, 0, &v);
  iftFree(&ift); if(ret!=0 || v!=87654321) return(12);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftDelete(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  iftInit(&ift);
  
  ret=iftDelete(&ift, 1); if(ret==TPCERROR_OK) {iftFree(&ift); return 2;}
  
  ret=iftPut(&ift, "testkey", "testvalue", 0, NULL);
  if(ift.keyNr!=1) return 11;
  ret=iftDelete(&ift, 0); if(ret!=TPCERROR_OK) {iftFree(&ift); return 12;}
  if(ift.keyNr!=0) return 13;
  iftFree(&ift);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftDuplicate(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift1, ift2;
  int ret;
  iftInit(&ift1); iftInit(&ift2);
  
  /* Duplicate empty struct */
  ret=iftDuplicate(&ift1, &ift2);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 2;}
  
  /* Make test content */
  ret=iftPut(&ift1, "key1", "value1", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift1, "key2", "value2", 1, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 11;}
  
  /* Duplicate test content and check the duplicate */
  ret=iftDuplicate(&ift1, &ift2);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 12;}
  if(ift2.keyNr!=2) {iftFree(&ift1); iftFree(&ift2); return 13;}
  ret=0;
  for(int i=0; i<2; i++) {
    if(strcmp(ift1.item[i].key, ift2.item[i].key)!=0) ret++;
    if(strcmp(ift1.item[i].value, ift2.item[i].value)!=0) ret++;
    if(ift1.item[i].comment!=ift2.item[i].comment) ret++;
  }
  if(ret>0) {iftFree(&ift1); iftFree(&ift2); return 14;}

  iftFree(&ift1); iftFree(&ift2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftReplaceValue(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift1, ift2;
  int ret;
  iftInit(&ift1); iftInit(&ift2);
  
  /* Try to replace value in empty struct */
  ret=iftReplaceValue(&ift1, 0, "huu", NULL);
  if(ret==TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 2;}
  
  /* Make test content */
  ret=iftPut(&ift1, "key1", "value1", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift1, "key2", "value2", 1, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift1, "key3", "value3", 1, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 11;}

  /* Duplicate test content for testing */
  ret=iftDuplicate(&ift1, &ift2);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 12;}

  /* Replace value for one item */
  ret=iftReplaceValue(&ift1, 1, "newvalue", NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 13;}
  /* and check the result */
  if(ift1.keyNr!=ift2.keyNr) {iftFree(&ift1); iftFree(&ift2); return 14;}
  ret=0;
  for(int i=0; i<ift1.keyNr; i++) {
    if(strcmp(ift1.item[i].key, ift2.item[i].key)!=0) ret++;
    if(i!=1 && strcmp(ift1.item[i].value, ift2.item[i].value)!=0) ret++;
    if(ift1.item[i].comment!=ift2.item[i].comment) ret++;
  }
  if(ret>0) {iftFree(&ift1); iftFree(&ift2); return 15;}
  if(strcmp(ift1.item[1].value, "newvalue")!=0) {
    iftFree(&ift1); iftFree(&ift2); return 16;
  }

  iftFree(&ift1); iftFree(&ift2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftReplaceKey(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift1, ift2;
  int ret;
  iftInit(&ift1); iftInit(&ift2);
  
  /* Try to replace key in empty struct */
  ret=iftReplaceKey(&ift1, 0, "huu", NULL);
  if(ret==TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 2;}
  
  /* Make test content */
  ret=iftPut(&ift1, "key1", "value1", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift1, "key2", "value2", 1, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift1, "key3", "value3", 1, NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 11;}

  /* Duplicate test content for testing */
  ret=iftDuplicate(&ift1, &ift2);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 12;}

  /* Replace key for one item */
  ret=iftReplaceKey(&ift1, 1, "newkey", NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 13;}
  /* and check the result */
  if(ift1.keyNr!=ift2.keyNr) {iftFree(&ift1); iftFree(&ift2); return 14;}
  ret=0;
  for(int i=0; i<ift1.keyNr; i++) {
    if(strcmp(ift1.item[i].value, ift2.item[i].value)!=0) ret++;
    if(i!=1 && strcmp(ift1.item[i].key, ift2.item[i].key)!=0) ret++;
    if(ift1.item[i].comment!=ift2.item[i].comment) ret++;
  }
  if(ret>0) {iftFree(&ift1); iftFree(&ift2); return 15;}
  if(strcmp(ift1.item[1].key, "newkey")!=0) {
    iftFree(&ift1); iftFree(&ift2); return 16;
  }

  /* Delete key name */
  ret=iftReplaceKey(&ift1, 1, "", NULL);
  if(ret!=TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return 21;}
  /* and check the result */
  if(strcmp(ift1.item[1].key, "")!=0) {
    iftFree(&ift1); iftFree(&ift2); return 22;
  }


  iftFree(&ift1); iftFree(&ift2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftDeleteDuplicateKeys(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift;
  int ret;
  iftInit(&ift);
  
  ret=iftDeleteDuplicateKeys(&ift, NULL); if(ret!=TPCERROR_OK) {iftFree(&ift); return 2;}
  
  ret=iftPut(&ift, "testkey", "testvalue", 0, NULL);
  ret=iftDeleteDuplicateKeys(&ift, NULL); if(ret!=TPCERROR_OK) {iftFree(&ift); return 3;}
  ret=iftPut(&ift, "testkey2", "testvalue2", 0, NULL);
  ret=iftDeleteDuplicateKeys(&ift, NULL); 
  if(ret!=TPCERROR_OK || ift.keyNr!=2) {iftFree(&ift); return 4;}

  ret=iftPut(&ift, "testkey", "testvalue3", 0, NULL);
  ret=iftDeleteDuplicateKeys(&ift, NULL); 
  if(ret!=TPCERROR_OK || ift.keyNr!=2) {iftFree(&ift); return 11;}
  if(strcmp(ift.item[0].key, "testkey")) {iftFree(&ift); return 12;}
  if(strcmp(ift.item[1].key, "testkey2")) {iftFree(&ift); return 13;}
  if(strcmp(ift.item[0].value, "testvalue")) {iftFree(&ift); return 14;}
  if(strcmp(ift.item[1].value, "testvalue2")) {iftFree(&ift); return 15;}

  iftFree(&ift);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftCopyItems(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift1, ift2;
  iftInit(&ift1); iftInit(&ift2);

  int ret;

  // Target NULL -> error
  ret=iftCopyItems(NULL, &ift2, 0, 0, 0, NULL);
  if(ret==TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(1);}
  
  // Both IFT empty -> ok, but nothing added
  ret=iftCopyItems(&ift1, &ift2, 0, 0, 0, NULL);
  if(ret!=TPCERROR_OK || ift1.keyNr!=0) {iftFree(&ift1); iftFree(&ift2); return(11);}

  // Target IFT empty -> copied
  if(iftPut(&ift2, "skey1", "svalue1", 0, NULL)) {iftFree(&ift1); iftFree(&ift2); return(20);}
  if(iftCopyItems(&ift1, &ift2, 0, 0, 0, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(21);}
  if(ift1.keyNr!=1) {iftFree(&ift1); iftFree(&ift2); return(22);}
  if(iftFindPair(&ift1, ift2.item[0].key, ift2.item[0].value, 0) != 0) {iftFree(&ift1); iftFree(&ift2); return(23);}

  // Require comment to copy
  if(iftCopyItems(&ift1, &ift2, 0, 0, 2, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(31);}
  if(ift1.keyNr!=1) {iftFree(&ift1); iftFree(&ift2); return(32);}
  // Set comment
  ift2.item[0].comment=1;
  if(iftCopyItems(&ift1, &ift2, 0, 0, 2, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(33);}
  if(ift1.keyNr!=2) {iftFree(&ift1); iftFree(&ift2); return(34);}
  // Copy only if not comment
  if(iftCopyItems(&ift1, &ift2, 0, 0, 0, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(35);}
  if(ift1.keyNr!=2) {iftFree(&ift1); iftFree(&ift2); return(36);}
  if(verbose>2) iftWrite(&ift1, stdout, NULL);

  // Copy comment or no comment
  iftFree(&ift2);
  if(iftCopyItems(&ift2, &ift1, 0, 0, 1, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(41);}
  if(ift2.keyNr!=2) {iftFree(&ift1); iftFree(&ift2); return(42);}

  iftFree(&ift1); iftFree(&ift2);

  // Missing key or value
  if(iftPut(&ift2, "skey1", "svalue1", 0, NULL)) {iftFree(&ift1); iftFree(&ift2); return(100);}
  if(iftPut(&ift2, "skey2", "", 0, NULL)) {iftFree(&ift1); iftFree(&ift2); return(101);}
  if(iftPut(&ift2, "", "svalue3", 0, NULL)) {iftFree(&ift1); iftFree(&ift2); return(102);}
  // Require both key and value
  if(iftCopyItems(&ift1, &ift2, 1, 1, 1, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(111);}
  if(ift1.keyNr!=1 || strcmp(ift1.item[0].key, "skey1")) {iftFree(&ift1); iftFree(&ift2); return(112);}
  // Ignore missing key or value
  if(iftCopyItems(&ift1, &ift2, 0, 0, 1, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(113);}
  if(ift1.keyNr!=4 || strcmp(ift1.item[3].value, "svalue3")) {iftFree(&ift1); iftFree(&ift2); return(114);}
  if(verbose>2) {printf("---\n"); iftWrite(&ift1, stdout, NULL);}
  // Require key
  if(iftCopyItems(&ift1, &ift2, 1, 0, 1, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(115);}
  if(verbose>2) {printf("---\n"); iftWrite(&ift1, stdout, NULL);}
  if(ift1.keyNr!=6 || strcmp(ift1.item[5].key, "skey2")) {iftFree(&ift1); iftFree(&ift2); return(116);}
  // Require value
  if(iftCopyItems(&ift1, &ift2, 0, 1, 1, NULL) != TPCERROR_OK) {iftFree(&ift1); iftFree(&ift2); return(117);}
  if(verbose>2) {printf("---\n"); iftWrite(&ift1, stdout, NULL);}
  if(ift1.keyNr!=8 || strcmp(ift1.item[7].value, "svalue3")) {iftFree(&ift1); iftFree(&ift2); return(118);}

  iftFree(&ift1); iftFree(&ift2);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
