/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcift.h"
/*****************************************************************************/

/*****************************************************************************/
int test_iftWriteItem(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  IFT ift;
  
  iftInit(&ift);
  ret=iftPut(&ift, "testkey", "testvalue", 0, NULL);
  ret=iftPut(&ift, "testkey2", "testvalue2", 0, NULL);
  ret=iftWriteItem(&ift, 1, stdout, NULL);
  iftFree(&ift); if(ret!=TPCERROR_OK) return 1;
    
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftWrite(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  IFT ift;
  
  iftInit(&ift);
  ret=iftPut(&ift, "testkey", "testvalue", 0, NULL);
  ret=iftPut(&ift, "testkey2", "testvalue2", 0, NULL);
  ret=iftWrite(&ift, stdout, NULL);
  iftFree(&ift); if(ret!=TPCERROR_OK) return 1;

  FILE *fp;
  char fname[]="test.ift";
  iftInit(&ift);
  ret=iftPut(&ift, "testkey", "testvalue", 0, NULL);
  ret=iftPut(&ift, "testkey2", "testvalue2", 0, NULL);
  fp=fopen(fname, "w"); if(fp==NULL) {iftFree(&ift); return 2;}
  ret=iftWrite(&ift, fp, NULL); fclose(fp);
  iftFree(&ift); if(ret!=TPCERROR_OK) return 2;


  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_iftRead(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  IFT ift; iftInit(&ift);
  TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  char fname[]="test2.ift";
  int ret;

  if(verbose>1) printf("trying to read from NULL pointer\n");
  ret=iftRead(&ift, NULL, 0, 1, &status);
  if(ret==TPCERROR_OK) return 1;

  if(verbose>1) {
    printf("\n===================================\n");
    printf("  creating ift file and reading it\n");
    printf("===================================\n");
  }
  FILE *fp;
  ret=iftPut(&ift, "testkey1", "testvalue1", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift, "testkey2", "testvalue2", 1, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift, "testkey3", "testvalue3", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift, NULL, "E:\\work\\asap\\", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, "times", "01:23:02 03:44:56 23:00:00", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "11:23:02 13:44:56 12:00:00", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "1:23:02 13:44:56 12:00:00", 1, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "23:02 13:44:56 12:00:00", 1, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, "time(13:44:56) 12:00:00", "yes", 1, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "2013-11-04 06:59:57 : No", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "Error in reading 'nonexisting.dat': cannot open file",
               0, NULL);
  if(ret!=TPCERROR_OK) {
    if(verbose>0) printf("error in setting IFT contents\n"); 
    return 1;
  }
  if(verbose>5) ret=iftWrite(&ift, stdout, NULL);

  if(verbose>2) printf("\nopen file for writing\n");
  fp=fopen(fname, "w"); if(fp==NULL) {iftFree(&ift); return 2;}
  if(verbose>2) printf("write file\n");
  ret=iftWrite(&ift, fp, NULL); fflush(fp); fclose(fp);
  iftFree(&ift); if(ret!=TPCERROR_OK) return 2;

  if(verbose>2) printf("\nreading file\n");
  fp=fopen(fname, "r"); if(fp==NULL) return 2;
  ret=iftRead(&ift, fp, 0, 1, &status); fclose(fp); fflush(stderr);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return 2;}

  if(verbose>2) printf("\nchecking contents\n");

  int i=0, n=0;
  while((i=iftSearchKey(&ift, "testkey", i))>=0) {
    if(verbose>1) iftWriteItem(&ift, i, stdout, NULL);
    i++; n++;
  }
  if(n!=3) {iftFree(&ift); return 11;}

  i=iftFindKey(&ift, "times", 0);
  if(i<0 || strcmp(ift.item[i].value, "01:23:02 03:44:56 23:00:00")!=0)
    {iftFree(&ift); return 12;}

  i=iftFindKey(&ift, "2013-11-04 06:59:57", 0);
  if(i<0 || strcmp(ift.item[i].value, "No")!=0)
    {iftFree(&ift); return 13;}

  i=iftFindKey(&ift, "Error in reading 'nonexisting.dat'", 0);
  if(i<0 || strcmp(ift.item[i].value, "cannot open file")!=0)
    {iftFree(&ift); return 21;}

  i=iftSearchValue(&ift, "E:\\work\\asap\\", 0);
  if(i<0) {iftFree(&ift); return 31;}

  iftFree(&ift);


#if(0) // this functionality is not present currently
  if(verbose>1) {
    printf("\n============================================================\n");
    printf("  creating ift file with space separators and reading it\n");
    printf("============================================================\n");
  }
  char fname2[]="test2b.ift";

  ift.type=4; // space
  ift.space_before_eq=ift.space_after_eq=0;

  ret=iftPut(&ift, "testkey1", "testvalue1", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift, "testkey2", "testvalue2", 1, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift, "testkey3", "testvalue3", 0, NULL);
  if(ret==TPCERROR_OK) ret=iftPut(&ift, "file1", "E:\\work\\asap.txt", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, "times", "01:23:02 03:44:56 23:00:00", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "11:23:02 13:44:56 12:00:00", 0, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, "time(13:44:56) 12:00:00", "yes", 1, NULL);
  if(ret==TPCERROR_OK)
    ret=iftPut(&ift, NULL, "2013-11-04 06:59:57", 0, NULL);
  if(ret!=TPCERROR_OK) {
    if(verbose>0) printf("error in setting IFT contents\n"); 
    return 101;
  }
  if(verbose>5) ret=iftWrite(&ift, stdout, NULL);

  if(verbose>2) printf("\nopen file for writing\n");
  fp=fopen(fname2, "w"); if(fp==NULL) {iftFree(&ift); return 102;}
  if(verbose>2) printf("write file\n");
  ret=iftWrite(&ift, fp, NULL); fflush(fp); fclose(fp);
  iftFree(&ift); if(ret!=TPCERROR_OK) return 102;

  if(verbose>2) printf("\nreading file\n");
  fp=fopen(fname2, "r"); if(fp==NULL) return 102;
  ret=iftRead(&ift, fp, 1, 1, &status); fclose(fp); fflush(stderr);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return 102;}
  ift.type=1;
  if(verbose>4) ret=iftWrite(&ift, stdout, NULL);

  if(verbose>2) printf("\nchecking contents\n");

  i=0; n=0;
  while((i=iftSearchKey(&ift, "testkey", i))>=0) {
    if(verbose>1) iftWriteItem(&ift, i, stdout, NULL);
    i++; n++;
  }
  if(n!=3) {iftFree(&ift); return 111;}

  i=iftFindKey(&ift, "times", 0);
  if(i<0 || strcmp(ift.item[i].value, "01:23:02 03:44:56 23:00:00")!=0)
    {iftFree(&ift); return 112;}

  i=iftSearchValue(&ift, "06:59:57", 0);
  if(i<0) {iftFree(&ift); return 113;}

  i=iftFindKey(&ift, "file1", 0);
  if(i<0 || strcmp(ift.item[i].value, "E:\\work\\asap.txt")!=0)
    {iftFree(&ift); return 114;}

  iftFree(&ift);
#endif

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
