/******************************************************************************
 * This file is not compiled into the library, but it contains main()
 * which is compiled to an executable, used to test the library functions. 
 *****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <unistd.h>
/*****************************************************************************/
#include "tpcimage.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Usage: @P [options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " -t, --test",
  "     Run all tests for library functions.",
  0};
/*****************************************************************************/

/*****************************************************************************/
/** Run unit tests to the library functions
    @author Vesa Oikonen
    @return 0 if all tests pass, otherwise >0.
  */
int main(
  /** Nr of arguments. */
  int argc,
  /** Pointer to arrays of argument string. */
  char *argv[ ]
) {
  int i, help=0, version=0, verbose=1, error=0, test=0;
  int ret;
  char *cptr;

  if(argc==1) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  for(i=1; i<argc; i++) {
    if(tpcProcessStdOptions(argv[i], &help, &version, &verbose)==0) continue;
    cptr=argv[i]; if(*cptr=='-') cptr++; if(*cptr=='-') cptr++;
    if(strncasecmp(cptr, "TEST", 1)==0) {
      test=1; continue;
    } else {
      error++; break;
    }
  }
  if(error>0) {
    fprintf(stderr, "Error: specify --help for usage.\n");
    return(1);
  }
  /* Print help or version? */
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  if(test==0) return(0);

  if(verbose>0) printf("running tests for library functions...\n");
  TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  statusSet(&status, __func__, __FILE__, __LINE__, 0);
  i=10;

  /* image */
  i++; if((ret=test_imgInit(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgFree(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgAllocate(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgHasData(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgHasTimes(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgHasCounts(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgHasWeights(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgMinMax(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }

  /* imageheader */
  i++; if((ret=test_imgFillOHeader(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }

  /* imageio */
  i++; if((ret=test_imgFormatDescr(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgDefaultExtension(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgRead(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgWrite(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgFormatFromFName(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgFormatIdentify(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* imagedcm */
  i++; if((ret=test_imgReadDICOM(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* imagenii */
  i++; if((ret=test_niftiCreateFNames(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgWriteNifti(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgReadNifti(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgSetNiftiHeader(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgGetNiftiHeader(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* imagesif */
  i++; if((ret=test_imgToSIF(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_imgFromSIF(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }



  if(verbose>0) printf("\nAll tests passed.\n\n");
  statusFree(&status);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
