/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
int test_niftiCreateFNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr=NULL;
  niftiCreateFNames(cptr, NULL, NULL, NULL, 0);
  if(verbose>1) printf("did not segfault, that is good.\n");

  char fname[FILENAME_MAX];
  char hdrname[FILENAME_MAX], imgname[FILENAME_MAX], sifname[FILENAME_MAX];
  int ret;

  fname[0]='\0'; hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_INVALID_FILENAME) return(10);

  strcpy(fname, "a"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_OK) return(11);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.nii") || strcmp(imgname, "a.nii") || strcmp(sifname, "a.sif"))
    return(11);
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_1S);
  if(ret!=TPCERROR_OK) return(12);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.nii") || strcmp(imgname, "a.nii") || strcmp(sifname, "a.sif"))
    return(12);
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2D);
  if(ret!=TPCERROR_OK) return(13);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.hdr") || strcmp(imgname, "a.img") || strcmp(sifname, "a.sif"))
    return(13);
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_1D);
  if(ret!=TPCERROR_OK) return(14);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.hdr") || strcmp(imgname, "a.img") || strcmp(sifname, "a.sif"))
    return(14);
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_DICOM);
  if(ret!=TPCERROR_INVALID_FORMAT) return(15);
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_UNKNOWN);
  if(ret!=TPCERROR_INVALID_FORMAT) return(16);

  strcpy(fname, "./a"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_OK) return(21);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "./a.nii") || strcmp(imgname, "./a.nii") || strcmp(sifname, "./a.sif"))
    return(21);
  strcpy(fname, "../b/a"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_OK) return(22);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "../b/a.nii") || strcmp(imgname, "../b/a.nii") || strcmp(sifname, "../b/a.sif"))
    return(22);

  strcpy(fname, "./"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_INVALID_FILENAME) return(23);
  strcpy(fname, "../"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_INVALID_FILENAME) return(24);
  strcpy(fname, "../a/"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_INVALID_FILENAME) return(25);

  strcpy(fname, "a.nii"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2S);
  if(ret!=TPCERROR_OK) return(31);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.nii") || strcmp(imgname, "a.nii") || strcmp(sifname, "a.sif"))
    return(31);
  strcpy(fname, "a.img"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_2D);
  if(ret!=TPCERROR_OK) return(32);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.hdr") || strcmp(imgname, "a.img") || strcmp(sifname, "a.sif"))
    return(32);
  strcpy(fname, "a.hdr"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_1D);
  if(ret!=TPCERROR_OK) return(33);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.hdr") || strcmp(imgname, "a.img") || strcmp(sifname, "a.sif"))
    return(33);
  strcpy(fname, "a.img.hdr"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_1D);
  if(ret!=TPCERROR_OK) return(34);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.hdr") || strcmp(imgname, "a.img") || strcmp(sifname, "a.sif"))
    return(34);
  strcpy(fname, "a.img.sif"); hdrname[0]='\0'; imgname[0]='\0'; sifname[0]='\0';
  ret=niftiCreateFNames(fname, hdrname, imgname, sifname, IMG_FORMAT_NIFTI_1D);
  if(ret!=TPCERROR_OK) return(35);
  if(verbose>1) printf("'%s' -> '%s' '%s' '%s'\n", fname, hdrname, imgname, sifname);
  if(strcmp(hdrname, "a.hdr") || strcmp(imgname, "a.img") || strcmp(sifname, "a.sif"))
    return(35);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgReadNifti(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgWriteNifti(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  /* Does not crash with NULL input */
  ret=imgWriteNifti(NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return 1;

  IMG img; imgInit(&img);

  if(verbose>1) {printf("empty IMG\n"); fflush(stdout);}
  ret=imgWriteNifti(&img, "nii/imgwritenifti1a", status);
  if(ret==TPCERROR_OK) {return(2);}

  if(verbose>1) {printf("creating test data\n"); fflush(stdout);}
  ret=create_img(&img, 4, 8, 8, 2);
  if(ret!=TPCERROR_OK) return(10);

  if(verbose>1) {printf("writing test image\n"); fflush(stdout);}
  ret=imgWriteNifti(&img, "nii/imgwritenifti1a", status);
  if(ret!=TPCERROR_OK) {imgFree(&img); return(21);}



  imgFree(&img);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgSetNiftiHeader(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgGetNiftiHeader(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
