/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcisotope.h"
/*****************************************************************************/

/*****************************************************************************/
int test_isotopeHalflife(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n;
  double hl;

  n=0; if(verbose>1) printf("n := %d\n", n);
  hl=isotopeHalflife(n); if(verbose>2) printf("  -> halflife := %g\n", hl);
  if(!isnan(hl)) return(1);

  n=99999; if(verbose>1) printf("n := %d\n", n);
  hl=isotopeHalflife(n); if(verbose>2) printf("  -> halflife := %g\n", hl);
  if(!isnan(hl)) return(2);

  n=ISOTOPE_C_11; if(verbose>1) printf("n := %d\n", n);
  hl=isotopeHalflife(n); if(verbose>2) printf("  -> halflife := %g\n", hl);
  if(fabs(hl-20.4)>0.1) return(3);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_isotopeBranching(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n;
  double br;

  n=0; if(verbose>1) printf("n := %d\n", n);
  br=isotopeBranching(n); if(verbose>2) printf("  -> branching ratio := %g\n", br);
  if(!isnan(br)) return(1);

  n=99999; if(verbose>1) printf("n := %d\n", n);
  br=isotopeBranching(n); if(verbose>2) printf("  -> branching ratio := %g\n", br);
  if(!isnan(br)) return(2);

  n=ISOTOPE_CU_64; if(verbose>1) printf("n := %d\n", n);
  br=isotopeBranching(n); if(verbose>2) printf("  -> branching ratio := %g\n", br);
  if(fabs(br-0.174)>0.005) return(3);

#if(0) // currently none
  /* try also one isotope with missing braching ratio */
  n=ISOTOPE_CU_64; if(verbose>1) printf("n := %d\n", n);
  br=isotopeBranching(n); if(verbose>2) printf("  -> branching ratio := %g\n", br);
  if(!isnan(br)) return(4);
#endif  

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_isotopeName(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n;
  char isotope[MAX_ISOTOPE_LEN];

  n=0; if(verbose>1) printf("n := %d\n", n);
  strcpy(isotope, isotopeName(n));
  if(verbose>2) printf("  -> isotope := %s\n", isotope);
  if(strcmp(isotope, "unknown")!=0) return(1);

  n=99999; if(verbose>1) printf("n := %d\n", n);
  strcpy(isotope, isotopeName(n));
  if(verbose>2) printf("  -> isotope := %s\n", isotope);
  if(strcmp(isotope, "unknown")!=0) return(2);

  n=ISOTOPE_C_11; if(verbose>1) printf("n := %d\n", n);
  strcpy(isotope, isotopeName(n));
  if(verbose>2) printf("  -> isotope := %s\n", isotope);
  if(strcmp(isotope, "C-11")!=0) return(3);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_isotopeIdentifyHalflife(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n;
  double halflife;

  halflife=0.0; if(verbose>1) printf("halflife := %g min\n", halflife);
  n=isotopeIdentifyHalflife(halflife);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_UNKNOWN) return(1);

  halflife=110.0; if(verbose>1) printf("halflife := %g min\n", halflife);
  n=isotopeIdentifyHalflife(halflife);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_F_18) return(2);

  halflife=2.0E+022; if(verbose>1) printf("halflife := %g min\n", halflife);
  n=isotopeIdentifyHalflife(halflife);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_UNKNOWN) return(3);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_isotopeIdentify(
  int verbose
) {
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n;
  char str[128];

  if(verbose>1) printf("isotope_string := NULL\n");
  n=isotopeIdentify(NULL);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_UNKNOWN) return(1);

  strcpy(str, "");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_UNKNOWN) return(2);

  strcpy(str, "Ge-68");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_GE_68) return(3);

  strcpy(str, "68Ge");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_GE_68) return(4);

  strcpy(str, "C11");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_C_11) return(5);

  strcpy(str, "Cu64");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_CU_64) return(6);

  strcpy(str, "C");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_C_11) return(7);

  strcpy(str, "52Fe");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_FE_52) return(8);

  strcpy(str, "F");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_F_18) return(9);

  strcpy(str, "O");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_O_15) return(10);

  strcpy(str, "O14");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_O_14) return(11);

  strcpy(str, "^52^Fe");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_FE_52) return(12);

  strcpy(str, "^18^Fluorine");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_F_18) return(13);

  strcpy(str, "^18^F");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_F_18) return(14);

  strcpy(str, "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ");
  if(verbose>1) printf("isotope_string := '%s'\n", str);
  n=isotopeIdentify(str);
  if(verbose>2) printf("  -> isotope := %s\n", isotopeName(n));
  if(n!=ISOTOPE_UNKNOWN) return(20);
  
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
