/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcisotope.h"
/*****************************************************************************/

/*****************************************************************************/
int test_noiseSD4Frame(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double y, t1, dt, a, sd;
  int isot;

  if(verbose>1) printf("\n try with zero input...\n");

  y=0.0; t1=0.0; dt=0.0; a=0.0; isot=ISOTOPE_UNKNOWN;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(!isnan(sd)) return(1);
  dt=1.0;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(isnan(sd) || fabs(sd)>1.0E-30) return(2);

  if(verbose>1) printf("\n try with stupid input...\n");

  y=nan(""); t1=0.0; dt=1.0; a=0.0; isot=ISOTOPE_UNKNOWN;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(!isnan(sd)) return(11);

  y=0.0; t1=-1.0; dt=1.0; a=0.0; isot=ISOTOPE_UNKNOWN;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(!isnan(sd)) return(12);

  y=0.0; t1=0.0; dt=1.0; a=-0.001; isot=ISOTOPE_UNKNOWN;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(!isnan(sd)) return(13);

  if(verbose>1) printf("\n try with negative concentration...\n");

  y=-10.0; t1=0.0; dt=1.0; a=5.0; isot=ISOTOPE_UNKNOWN;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(isnan(sd) || fabs(sd)>1.0E-30) return(21);

  y=-10.0; t1=0.0; dt=1.0; a=5.0; isot=ISOTOPE_C_11;
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  if(isnan(sd) || fabs(sd)>1.0E-30) return(22);

  if(verbose>1) printf("\n try with reasonable input...\n");

  isot=ISOTOPE_C_11; y=100.0; t1=0.0; dt=isotopeHalflife(isot); a=1.0; 
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  {
    double dc=1.0/decayCorrectionFactorFromIsotope(isot, t1, dt);
    double osd=sqrt(a*y/(dt*dc)); if(verbose>2) printf("osd=%g\n", osd);
    if(isnan(sd) || fabs(osd-sd)>1.0E-10) return(101);
  }

  isot=ISOTOPE_C_11; y=100.0; t1=isotopeHalflife(isot); dt=isotopeHalflife(isot); a=2.0; 
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  {
    double dc=1.0/decayCorrectionFactorFromIsotope(isot, t1, dt);
    double osd=sqrt(a*y/(dt*dc)); if(verbose>2) printf("osd=%g\n", osd);
    if(isnan(sd) || fabs(osd-sd)>1.0E-10) return(102);
  }

  isot=ISOTOPE_UNKNOWN; y=100.0; t1=10.0; dt=20.0; a=5.0; 
  sd=noiseSD4Frame(y, t1, dt, isot, a);
  if(verbose>1) printf("noiseSD4Frame(%g, %g, %g, %s, %g)=%g\n", y, t1, dt, isotopeName(isot), a, sd);
  {
    double dc=1.0;
    double osd=sqrt(a*y/(dt*dc)); if(verbose>2) printf("osd=%g\n", osd);
    if(isnan(sd) || fabs(osd-sd)>1.0E-10) return(103);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
