/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpclinopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_bvls(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }


  {
  if(verbose>1) printf("\n === TEST01 ===\n\n");

  int ret, i, n, m;
  m=2; n=2;
  double *buf=NULL, **A=NULL, B[m], X[n], C[n], BL[n], BU[n], W[n], ACT[m*(m+2)], ZZ[m];
  int istate[n+1];

  buf=(double*)calloc(n*m, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(101);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  A[0][0]=0.829509;  A[1][0]=0.415307;
  A[0][1]=0.561695;  A[1][1]=0.0661187;
  B[0]=0.218418;
  B[1]=0.956318;
  BL[0]=1.0;  BL[1]=3.0; // Lower limits
  BU[0]=2.0;  BU[1]=4.0; // Upper limits
  if(verbose>2) {
    printf("\tMatrix A and vector B:\n");
    for(int mi=0; mi<m; mi++) {
      for(int ni=0; ni<n; ni++) printf("\t%g", A[ni][mi]);
      printf("\t%g\n", B[mi]);
    }
    printf("\n");
  }
  C[0]=1.0; // Correct result
  C[1]=3.0; // Correct result
  double correct_rnorm=1.8674;
  int iterNr=100;
  ret=bvls(0, m, n, buf, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-3);
  if(verbose>1) printf(" ret := %d\n", ret);
  if(ret>0) {free(buf); free(A); return(102);}
  if(verbose>2) {
    printf("  Number of parameters at constraints := %d\n", istate[n]);
    printf("  X := %g", X[0]); for(int i=1; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("  W := %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-06)) {free(buf); free(A); return(103);} 
  }
  if(istate[n]!=2) {free(buf); free(A); return(104);} 
  if(!doubleMatch(correct_rnorm, W[0], 0.0001)) {free(buf); free(A); return(105);} 

  free(buf); free(A);
  }



  {
  if(verbose>1) printf("\n === TEST02 ===\n\n");

  int ret, i, n, m;
  m=2; n=4;
  double *buf=NULL, **A=NULL, B[m], X[n], C[n], BL[n], BU[n], W[n], ACT[m*(m+2)], ZZ[m];
  int istate[n+1];

  buf=(double*)calloc(n*m, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(111);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  A[0][0]=0.829509;  A[1][0]=0.415307;  A[2][0]=0.257578;  A[3][0]=0.0438290;
  A[0][1]=0.561695;  A[1][1]=0.0661187; A[2][1]=0.109957;  A[3][1]=0.633966;
  B[0]=0.218418;
  B[1]=0.956318;
  BL[0]=BL[1]=BL[2]=BL[3]=0.0;  // Lower limits
  BU[0]=BU[1]=BU[2]=BU[3]=10.0; // Upper limits
  if(verbose>2) {
    printf("\tMatrix A and vector B:\n");
    for(int mi=0; mi<m; mi++) {
      for(int ni=0; ni<n; ni++) printf("\t%g", A[ni][mi]);
      printf("\t%g\n", B[mi]);
    }
    printf("\n");
  }
  C[0]=0.192624; // Correct results
  C[1]=0.0;
  C[2]=0.0;
  C[3]=1.33780;
  double correct_rnorm=0.0000;
  int iterNr=100;
  ret=bvls(0, m, n, buf, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-3);
  if(verbose>1) printf(" ret := %d\n", ret);
  if(ret>0) {free(buf); free(A); return(112);}
  if(verbose>2) {
    printf("  Number of parameters at constraints := %d\n", istate[n]);
    printf("  X := %g", X[0]); for(int i=1; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("  W := %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(113);} 
  }
  if(istate[n]!=2) {free(buf); free(A); return(114);} 
  if(!doubleMatch(correct_rnorm, W[0], 0.0001)) {free(buf); free(A); return(115);} 

  free(buf); free(A);
  }


  {
  if(verbose>1) printf("\n === TEST03 ===\n\n");

  int ret, i, n=2, m=4;
  double *buf=NULL, **A=NULL, B[m], X[n], C[n], BL[n], BU[n], W[n], ACT[m*(m+2)], ZZ[m];
  int istate[n+1];

  buf=(double*)calloc(n*m, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(121);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  A[0][0]=0.415307;  A[1][0]=0.0438290;
  A[0][1]=0.0661187; A[1][1]=0.633966;
  A[0][2]=0.257578;  A[1][2]=0.0617272;
  A[0][3]=0.109957;  A[1][3]=0.449539;
  B[0]=0.218418;
  B[1]=0.956318;
  B[2]=0.829509;
  B[3]=0.561695;
  BL[0]=0.0;    BU[0]=100.0;
  BL[1]=-100.0; BU[1]=100.0;
  if(verbose>2) {
    printf("\tMatrix A and vector B:\n");
    for(int mi=0; mi<m; mi++) {
      for(int ni=0; ni<n; ni++) printf("\t%g", A[ni][mi]);
      printf("\t%g\n", B[mi]);
    }
    printf("\n");
  }
  C[0]=1.04661;
  C[1]=1.29280;
  double correct_rnorm=0.57242;
  int iterNr=100;
  ret=bvls(0, m, n, buf, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-3);
  if(verbose>1) printf(" ret := %d\n", ret);
  if(ret>0) {free(buf); free(A); return(122);}
  if(verbose>2) {
    printf("  Number of parameters at constraints := %d\n", istate[n]);
    printf("  X := %g", X[0]); for(int i=1; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("  W := %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(123);} 
  }
  if(istate[n]!=0) {free(buf); free(A); return(124);} 
  if(!doubleMatch(correct_rnorm, W[0], 0.00001)) {free(buf); free(A); return(125);} 

  free(buf); free(A);
  }


  {
  if(verbose>1) printf("\n === TEST04 ===\n\n");

  int ret, i, n=10, m=5;
  double *buf=NULL, **A=NULL, B[m], X[n], C[n], BL[n], BU[n], W[n], ACT[m*(m+2)], ZZ[m];
  int istate[n+1];

  buf=(double*)calloc(n*m, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(131);
  for(i=0; i<n; i++) A[i]=buf+(i*m);

  A[0][0]=0.0661187; A[1][0]=0.0617272; A[2][0]=0.00183837; A[3][0]=0.859097;   A[4][0]=0.912484;
  A[0][1]=0.257578;  A[1][1]=0.449539;  A[2][1]=0.897504;   A[3][1]=0.840847;   A[4][1]=0.113664;
  A[0][2]=0.109957;  A[1][2]=0.401306;  A[2][2]=0.350752;   A[3][2]=0.123104;   A[4][2]=0.351629;
  A[0][3]=0.0438290; A[1][3]=0.754673;  A[2][3]=0.0945448;  A[3][3]=0.00751236; A[4][3]=0.822887;
  A[0][4]=0.633966;  A[1][4]=0.797287;  A[2][4]=0.0136169;  A[3][4]=0.260303;   A[4][4]=0.267132;
 
  A[5][0]=0.692066;  A[6][0]=0.597917;  A[7][0]=0.574366;   A[8][0]=0.714471;   A[9][0]=0.0618618;
  A[5][1]=0.561662;  A[6][1]=0.188955;  A[7][1]=0.367027;   A[8][1]=0.117707;   A[9][1]=0.710781;
  A[5][2]=0.861216;  A[6][2]=0.761492;  A[7][2]=0.617205;   A[8][2]=0.299329;   A[9][2]=0.0882833;
  A[5][3]=0.453794;  A[6][3]=0.396988;  A[7][3]=0.361529;   A[8][3]=0.825003;   A[9][3]=0.777994;
  A[5][4]=0.911977;  A[6][4]=0.185314;  A[7][4]=0.212930;   A[8][4]=0.824660;   A[9][4]=0.745303;

  B[0]=0.218418;
  B[1]=0.956318;
  B[2]=0.829509;
  B[3]=0.561695;
  B[4]=0.415307;

  BL[0]=0.0;       BU[0]=0.0;
  BL[1]=-0.3994;   BU[1]=-0.3994;
  BL[2]=-1.0;      BU[2]=+1.0;
  BL[3]=-0.3;      BU[3]=-0.2;
  BL[4]=21.0;      BU[4]=22.0;
  BL[5]=-4.0;      BU[5]=-3.0;
  BL[6]=45.0;      BU[6]=46.0;
  BL[7]=100.0;     BU[7]=101.0;
  BL[8]=-1.0E+10;  BU[8]=+1.0E+10;
  BL[9]=-1.0;      BU[9]=+1.0;
  if(verbose>2) {
    printf("\tMatrix A and vector B:\n");
    for(int mi=0; mi<m; mi++) {
      for(int ni=0; ni<n; ni++) printf("\t%g", A[ni][mi]);
      printf("\t%g\n", B[mi]);
    }
    printf("\n");
  }
  C[0]=0.0; C[1]=-0.3994; C[2]=-1.0; C[3]=-0.3; C[4]=21.0;
  C[5]=-4.0; C[6]=45.0; C[7]=100.0; C[8]=-95.9668; C[9]=1.0;
  double correct_rnorm=96.514;

  istate[n]=9; 
  istate[0]=-1; istate[1]=-2; istate[2]=-3; istate[3]=-4; istate[4]=-5;
  istate[5]=-6; istate[6]=-7; istate[7]=-8; istate[8]=10; istate[9]=9;
  int iterNr=100;
  ret=bvls(1, m, n, buf, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-3);
  if(verbose>1) printf(" ret := %d\n", ret);
  if(ret>0) {free(buf); free(A); return(132);}
  if(verbose>2) {
    printf("  Number of parameters at constraints := %d\n", istate[n]);
    printf("  X := %g", X[0]); for(int i=1; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("  W := %g\n", W[0]);
    printf("  iterNr := %d\n", iterNr);
  }
  for(i=0; i<n; i++) {
    if(i!=8 && !doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(133);} 
    if(i==8 && !doubleMatch(X[i], C[i], 1.0)) {free(buf); free(A); return(133);} 
  }
  if(istate[n]!=9) {free(buf); free(A); return(134);} 
  if(!doubleMatch(correct_rnorm, W[0], 0.1)) {free(buf); free(A); return(135);} 

  free(buf); free(A);
  }


  {
  if(verbose>1) printf("\n === TEST05 ===\n\n");

  int ret, i, n=5, m=10;
  double *buf=NULL, **A=NULL, B[m], X[n], C[n], BL[n], BU[n], W[n], ACT[m*(m+2)], ZZ[m];
  int istate[n+1];

  buf=(double*)calloc(n*m, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(141);
  for(i=0; i<n; i++) A[i]=buf+(i*m);

  A[0][0]=0.0617272;  A[1][0]=0.859097;   A[2][0]=0.692066; A[3][0]=0.574366; A[4][0]=0.0618618;
  A[0][1]=0.449539;   A[1][1]=0.840847;   A[2][1]=0.561662; A[3][1]=0.367027; A[4][1]=0.710781;
  A[0][2]=0.401306;   A[1][2]=0.123104;   A[2][2]=0.861216; A[3][2]=0.617205; A[4][2]=0.0882833;
  A[0][3]=0.754673;   A[1][3]=0.00751236; A[2][3]=0.453794; A[3][3]=0.361529; A[4][3]=0.777994;
  A[0][4]=0.797287;   A[1][4]=0.260303;   A[2][4]=0.911977; A[3][4]=0.212930; A[4][4]=0.745303;
  A[0][5]=0.00183837; A[1][5]=0.912484;   A[2][5]=0.597917; A[3][5]=0.714471; A[4][5]=0.308675;
  A[0][6]=0.897504;   A[1][6]=0.113664;   A[2][6]=0.188955; A[3][6]=0.117707; A[4][6]=0.899373;
  A[0][7]=0.350752;   A[1][7]=0.351629;   A[2][7]=0.761492; A[3][7]=0.299329; A[4][7]=0.763537;
  A[0][8]=0.0945448;  A[1][8]=0.822887;   A[2][8]=0.396988; A[3][8]=0.825003; A[4][8]=0.761731;
  A[0][9]=0.0136169;  A[1][9]=0.267132;   A[2][9]=0.185314; A[3][9]=0.824660; A[4][9]=0.406970;

  B[0]=0.218418;
  B[1]=0.956318;
  B[2]=0.829509;
  B[3]=0.561695;
  B[4]=0.415307;
  B[5]=0.0661187;
  B[6]=0.257578;
  B[7]=0.109957;
  B[8]=0.0438290;
  B[9]=0.633966;

  BL[0]=0.0;    BU[0]=1.0;
  BL[1]=-1.0;   BU[1]=0.0;
  BL[2]=0.0;    BU[2]=1.0;
  BL[3]=0.3;    BU[3]=0.4;
  BL[4]=0.048;  BU[4]=0.049;
  if(verbose>2) {
    printf("\tMatrix A and vector B:\n");
    for(int mi=0; mi<m; mi++) {
      for(int ni=0; ni<n; ni++) printf("\t%g", A[ni][mi]);
      printf("\t%g\n", B[mi]);
    }
    printf("\n");
  }
  C[0]=0.370364;
  C[1]=-0.154345;
  C[2]=0.197883;
  C[3]=0.400000;
  C[4]=0.0480000;
  double correct_rnorm=0.90733;

  int iterNr=100;
  ret=bvls(0, m, n, buf, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-3);
  if(verbose>1) printf(" ret := %d\n", ret);
  if(ret>0) {free(buf); free(A); return(142);}
  if(verbose>2) {
    printf("  Number of parameters at constraints := %d\n", istate[n]);
    printf("  X := %g", X[0]); for(int i=1; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("  W := %g\n", W[0]);
    printf("  iterNr := %d\n", iterNr);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(143);} 
  }
  if(istate[n]!=2) {free(buf); free(A); return(144);} 
  if(!doubleMatch(correct_rnorm, W[0], 0.0001)) {free(buf); free(A); return(145);} 

  free(buf); free(A);
  }


  {
  if(verbose>1) printf("\n === TEST06 ===\n\n");

  int ret, i, n=4, m=6;
  double *buf=NULL, **A=NULL, B[m], X[n], C[n], BL[n], BU[n], W[n], ACT[m*(m+2)], ZZ[m];
  int istate[n+1];

  buf=(double*)calloc(n*m, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(151);
  for(i=0; i<n; i++) A[i]=buf+(i*m);

  A[0][0]=0.257578;  A[1][0]=0.401306;   A[2][0]=0.0945448;  A[3][0]=0.260303;
  A[0][1]=0.109957;  A[1][1]=0.754673;   A[2][1]=0.0136169;  A[3][1]=0.912484;
  A[0][2]=0.0438290; A[1][2]=0.797287;   A[2][2]=0.859097;   A[3][2]=0.113664;
  A[0][3]=0.633966;  A[1][3]=0.00183837; A[2][3]=0.840847;   A[3][3]=0.351629;
  A[0][4]=0.0617272; A[1][4]=0.897504;   A[2][4]=0.123104;   A[3][4]=0.822887;
  A[0][5]=0.449539;  A[1][5]=0.350752;   A[2][5]=0.00751236; A[3][5]=0.267132;

  B[0]=0.218418;
  B[1]=0.956318;
  B[2]=0.829509;
  B[3]=0.561695;
  B[4]=0.415307;
  B[5]=0.0661187;

  BL[0]=-100.0;    BU[0]=+100.0;
  BL[1]=-1.0E+12;  BU[1]=+1.0E+12;
  BL[2]=-1.0E+12;  BU[2]=+1.0E+12;
  BL[3]=-1.0E+12;  BU[3]=+1.0E+12;
  if(verbose>2) {
    printf("\tMatrix A and vector B:\n");
    for(int mi=0; mi<m; mi++) {
      for(int ni=0; ni<n; ni++) printf("\t%g", A[ni][mi]);
      printf("\t%g\n", B[mi]);
    }
    printf("\n");
  }

  C[0]=-0.371430;
  C[1]=0.111047;
  C[2]=0.704941;
  C[3]=0.685629;
  double correct_rnorm=0.42705;

  int iterNr=100;
  ret=bvls(0, m, n, buf, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-3);
  if(verbose>1) printf(" ret := %d\n", ret);
  if(ret>0) {free(buf); free(A); return(152);}
  if(verbose>2) {
    printf("  Number of parameters at constraints := %d\n", istate[n]);
    printf("  X := %g", X[0]); for(int i=1; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("  W := %g\n", W[0]);
    printf("  iterNr := %d\n", iterNr);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(153);} 
  }
  if(istate[n]!=0) {free(buf); free(A); return(154);} 
  if(!doubleMatch(correct_rnorm, W[0], 0.0001)) {free(buf); free(A); return(155);} 

  free(buf); free(A);
  }




  {
  if(verbose>1) printf("\n === TEST07 ===\n\n");

  const int MAX_M=6, MAX_N=4;
  int ret, i, n, m;
  double B[MAX_M], X[MAX_N], BL[MAX_N], BU[MAX_N], W[MAX_N];
  double ACT[MAX_M*(MAX_M+2)], ZZ[MAX_M], C[MAX_N];
  int istate[MAX_N+1], iterNr;
  double mat[MAX_N*MAX_M], *A[MAX_N];


  if(verbose>1) printf("\n 2-parameter estimation \n");
  m=4; n=2; for(int ni=0; ni<n; ni++) A[ni]=mat+ni*m;
  A[0][0]=1.0;  A[1][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;
  A[0][2]=3.0;  A[1][2]=9.0;
  A[0][3]=4.0;  A[1][3]=16.0;
  B[0]=0.6;
  B[1]=2.2;
  B[2]=4.8;
  B[3]=8.4;
  C[0]=0.1; BL[0]=0.0; BU[0]=1.0;
  C[1]=0.5; BL[1]=0.0; BU[1]=1.0;
  iterNr=0;
  ret=bvls(0, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(701);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(702);
  }
  if(verbose>1) printf("\n Again with warm start \n");
  A[0][0]=1.0;  A[1][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;
  A[0][2]=3.0;  A[1][2]=9.0;
  A[0][3]=4.0;  A[1][3]=16.0;
  B[0]=0.6;
  B[1]=2.2;
  B[2]=4.8;
  B[3]=8.4;
  C[0]=0.1; BL[0]=0.0; BU[0]=1.0;
  C[1]=0.5; BL[1]=0.0; BU[1]=1.0;
  iterNr=0;
  istate[n]=0; for(int ni=0; ni<n; ni++) istate[ni]=1+ni;
  ret=bvls(1, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(703);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(704);
  }

  if(verbose>1) printf("\n 3-parameter estimation \n");
  m=4; n=3; for(int ni=0; ni<n; ni++) A[ni]=mat+ni*m;
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0;
  B[0]=0.73;
  B[1]=3.24;
  B[2]=8.31;
  B[3]=16.72;
  C[0]=0.1;  BL[0]=0.0;  BU[0]=0.5;
  C[1]=0.5;  BL[1]=0.1;  BU[1]=1.0;
  C[2]=0.13; BL[2]=0.0;  BU[2]=1.0;
  iterNr=0;
  istate[n]=0; for(int ni=0; ni<n; ni++) istate[ni]=1+ni;
  ret=bvls(1, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(711);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(712);
  }

  if(verbose>1) printf("\n 3-parameter estimation with negative parameter\n");
  m=4; n=3; for(int ni=0; ni<n; ni++) A[ni]=mat+ni*m;
  A[0][0]=1.0;  A[1][0]=-1.0;  A[2][0]=1.0;
  A[0][1]=2.0;  A[1][1]=-4.0;  A[2][1]=8.0;
  A[0][2]=3.0;  A[1][2]=-9.0;  A[2][2]=27.0;
  A[0][3]=4.0;  A[1][3]=-16.0; A[2][3]=64.0;
  B[0]=0.73;
  B[1]=3.24;
  B[2]=8.31;
  B[3]=16.72;
  C[0]=0.1;  BL[0]=0.0;  BU[0]=0.5;
  C[1]=-0.5; BL[1]=-1.0; BU[1]=0.0;
  C[2]=0.13; BL[2]=0.0;  BU[2]=1.0;
  iterNr=0;
  istate[n]=0; for(int ni=0; ni<n; ni++) istate[ni]=1+ni;
  ret=bvls(1, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(721);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(722);
  }

  if(verbose>1) printf("\n 4-parameter estimation, where 4th parameter is zero \n");
  m=4; n=4; for(int ni=0; ni<n; ni++) A[ni]=mat+ni*m;
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;  A[3][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;  A[3][1]=16.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0; A[3][2]=81.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0; A[3][3]=256.0;
  B[0]=0.73;
  B[1]=3.24;
  B[2]=8.31;
  B[3]=16.72;
  C[0]=0.1;  BL[0]=0.0;  BU[0]=1.0;
  C[1]=0.5;  BL[1]=0.0;  BU[1]=2.0;
  C[2]=0.13; BL[2]=0.0;  BU[2]=0.5;
  C[3]=0.0;  BL[3]=-1.0; BU[3]=+0.5;
  iterNr=0;
  istate[n]=0; for(int ni=0; ni<n; ni++) istate[ni]=1+ni;
  ret=bvls(1, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(731);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(732);
  }

  
  if(verbose>1) printf("\n 3-parameter estimation, where 2nd parameter is zero \n");
  m=4; n=3; for(int ni=0; ni<n; ni++) A[ni]=mat+ni*m;
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0;
  B[0]=0.23;
  B[1]=1.24;
  B[2]=3.81;
  B[3]=8.72;
  C[0]=0.1;  BL[0]=-1.0;  BU[0]=10.0;
  C[1]=0.0;  BL[1]=-1.0;  BU[1]=10.0;
  C[2]=0.13; BL[2]=-1.0;  BU[2]=10.0;
  iterNr=0;
  istate[n]=0; for(int ni=0; ni<n; ni++) istate[ni]=1+ni;
  ret=bvls(1, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(741);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(742);
  }


  if(verbose>1) printf("\n 4-parameter estimation, where all but 1st parameter are zeroes \n");
  m=5; n=4; for(int ni=0; ni<n; ni++) A[ni]=mat+ni*m;
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;   A[3][0]=2.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;   A[3][1]=16.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0;  A[3][2]=54.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0;  A[3][3]=128.0;
  A[0][4]=5.0;  A[1][4]=25.0; A[2][4]=125.0;   A[3][4]=250.0;
  B[0]=3.0;
  B[1]=6.0;
  B[2]=9.0;
  B[3]=12.0;
  B[4]=15.0;
  C[0]=3.0;  BL[0]=0.0;  BU[0]=10.0;
  C[1]=0.0;  BL[1]=0.0;  BU[1]=22.0;
  C[2]=0.0;  BL[2]=0.0;  BU[2]=0.5;
  C[3]=0.0;  BL[3]=0.0;  BU[3]=0.5;
  iterNr=3;
  istate[n]=0; for(int ni=0; ni<n; ni++) istate[ni]=1+ni;
  ret=bvls(1, m, n, mat, B, BL, BU, X, W, ACT, ZZ, istate, &iterNr, verbose-10);
  if(ret!=0) return(751);
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g\n", W[0]);
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) return(752);
  }

  }

  if(verbose>1) printf("\nOK\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
