/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpclinopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_nnls(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret, i, n, m;
  double *buf=NULL, **A=NULL, *B=NULL, *X=NULL, *C=NULL, R;

  ret=nnls(NULL, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);

  
  if(verbose>1) printf("\n 2-parameter estimation \n");
  m=4; n=2;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(11);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;
  A[0][2]=3.0;  A[1][2]=9.0;
  A[0][3]=4.0;  A[1][3]=16.0;
  B[0]=0.6;
  B[1]=2.2;
  B[2]=4.8;
  B[3]=8.4;
  C[0]=0.1;
  C[1]=0.5;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(12);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(13);} 
  }
  free(buf); free(A);

  if(verbose>1) printf("\n 3-parameter estimation \n");
  m=4; n=3;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(21);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0;
  B[0]=0.73;
  B[1]=3.24;
  B[2]=8.31;
  B[3]=16.72;
  C[0]=0.1;
  C[1]=0.5;
  C[2]=0.13;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(22);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(23);} 
  }
  free(buf); free(A);

  
  if(verbose>1) printf("\n 4-parameter estimation, where 4th parameter is zero \n");
  m=4; n=4;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(31);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;  A[3][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;  A[3][1]=16.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0; A[3][2]=81.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0; A[3][3]=256.0;
  B[0]=0.73;
  B[1]=3.24;
  B[2]=8.31;
  B[3]=16.72;
  C[0]=0.1;
  C[1]=0.5;
  C[2]=0.13;
  C[3]=0.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(32);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(33);} 
  }
  free(buf); free(A);

  
  if(verbose>1) printf("\n 3-parameter estimation, where 2nd parameter is zero \n");
  m=4; n=3;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(41);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0;
  B[0]=0.23;
  B[1]=1.24;
  B[2]=3.81;
  B[3]=8.72;
  C[0]=0.1;
  C[1]=0.0;
  C[2]=0.13;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(42);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(43);} 
  }
  free(buf); free(A);

  
  if(verbose>1) {
    printf("\n 2-parameter estimation, with negative parameter \n");
    printf(" - should result to zero instead of the negative parameter \n");
  }
  m=4; n=2;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(51);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=1.0;
  A[0][1]=2.0;  A[1][1]=4.0;
  A[0][2]=3.0;  A[1][2]=9.0;
  A[0][3]=4.0;  A[1][3]=16.0;
  B[0]=1.0;
  B[1]=6.0;
  B[2]=15.0;
  B[3]=28.0;
  C[0]=-1.0;
  C[1]=2.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(52);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); 
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  if(!doubleMatch(X[0], 0.0, 1.0E-12)) {free(buf); free(A); return(53);} 
  if(doubleMatch(X[1], 0.0, 1.0E-06)) {free(buf); free(A); return(54);} 
  free(buf); free(A);

  
  if(verbose>1) printf("\n 2-parameter estimation with errors \n");
  m=6; n=2;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(61);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=7.0;  A[1][0]=0.0;
  A[0][1]=3.0;  A[1][1]=1.0;
  A[0][2]=2.0;  A[1][2]=4.0;
  A[0][3]=1.0;  A[1][3]=6.0;
  A[0][4]=2.0;  A[1][4]=3.0;
  A[0][5]=6.0;  A[1][5]=2.0;
  B[0]=8.0;
  B[1]=3.0;
  B[2]=7.0;
  B[3]=6.0;
  B[4]=6.0;
  B[5]=7.0;
  C[0]=1.0;
  C[1]=1.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(62);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatchRel(X[i], C[i], 0.1)) {free(buf); free(A); return(63);} 
  }
  free(buf); free(A);

  
  if(verbose>1) printf("\n 2-parameter estimation with smaller errors \n");
  m=6; n=2;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(71);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=7.0;  A[1][0]=0.0;
  A[0][1]=3.0;  A[1][1]=1.0;
  A[0][2]=2.0;  A[1][2]=4.0;
  A[0][3]=1.0;  A[1][3]=6.0;
  A[0][4]=2.0;  A[1][4]=3.0;
  A[0][5]=6.0;  A[1][5]=2.0;
  B[0]=3.51;
  B[1]=2.69;
  B[2]=5.81;
  B[3]=7.69;
  B[4]=4.61;
  B[5]=5.39;
  C[0]=0.5;
  C[1]=1.2;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(72);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatchRel(X[i], C[i], 0.002)) {free(buf); free(A); return(73);} 
  }
  free(buf); free(A);

#if(0)
  if(verbose>1) printf("\n 3-parameter estimation, 6 samples \n");
  m=6; n=3;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(81);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=2.0;  A[2][0]=3.0;    B[0]=3.0; 
  A[0][1]=4.0;  A[1][1]=5.0;  A[2][1]=6.0;    B[1]=9.0; 
  A[0][2]=7.0;  A[1][2]=8.0;  A[2][2]=9.0;    B[2]=15.0; 
  A[0][3]=10.0; A[1][3]=11.0; A[2][3]=12.0;   B[3]=22.0; 
  A[0][4]=13.0; A[1][4]=14.0; A[2][4]=15.0;   B[4]=27.0; 
  A[0][5]=16.0; A[1][5]=17.0; A[2][5]=-5.0;   B[5]=33.0;
  C[0]=1.08841;
  C[1]=0.923188;
  C[2]=0.0217391;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(82);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(83);} 
  }
  free(buf); free(A);
#else
  if(verbose>1) printf("\n 3-parameter estimation, 6 samples \n");
  // Allocating extra memory to detect buffer overflow
  m=6; n=3;
  buf=(double*)calloc(n*m+m+n+n+5, sizeof(double));
  buf[0]=buf[n*m+1]=buf[n*m+m+2]=buf[n*m+m+n+3]=buf[n*m+m+n+n+4]=nan("");
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(81);
  for(i=0; i<n; i++) A[i]=1+buf+(i*m);
  B=2+buf+(m*n); X=3+buf+(m*n+m); C=4+buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=2.0;  A[2][0]=3.0;    B[0]=3.0; 
  A[0][1]=4.0;  A[1][1]=5.0;  A[2][1]=6.0;    B[1]=9.0; 
  A[0][2]=7.0;  A[1][2]=8.0;  A[2][2]=9.0;    B[2]=15.0; 
  A[0][3]=10.0; A[1][3]=11.0; A[2][3]=12.0;   B[3]=22.0; 
  A[0][4]=13.0; A[1][4]=14.0; A[2][4]=15.0;   B[4]=27.0; 
  A[0][5]=16.0; A[1][5]=17.0; A[2][5]=-5.0;   B[5]=33.0;
  C[0]=1.08841;
  C[1]=0.923188;
  C[2]=0.0217391;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(82);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-05)) {free(buf); free(A); return(83);} 
  }
  if(!isnan(buf[0]) || !isnan(buf[n*m+1]) || !isnan(buf[n*m+m+2])) {free(buf); free(A); return(84);}
  if(!isnan(buf[n*m+m+n+3])) {free(buf); free(A); return(85);}
  if(!isnan(buf[n*m+m+n+n+4]))  {free(buf); free(A); return(86);}
  free(buf); free(A);
#endif

  if(verbose>1) printf("\n 3x3 matrix \n");
  // See http://www.excel-easy.com/examples/system-of-linear-equations.html
  m=3; n=3;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(91);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=5.0;  A[1][0]=1.0;  A[2][0]=8.0;    B[0]=46.0; 
  A[0][1]=4.0;  A[1][1]=-2.0; A[2][1]=0.0;    B[1]=12.0; 
  A[0][2]=6.0;  A[1][2]=7.0;  A[2][2]=4.0;    B[2]=50.0; 
  C[0]=4.0;
  C[1]=2.0;
  C[2]=3.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(92);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-08)) {free(buf); free(A); return(93);} 
  }
  free(buf); free(A);

  
  if(verbose>1) printf("\n 3-parameter estimation, data all zeroes \n");
  m=6; n=3;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(101);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=0.0;  A[1][0]=0.0;  A[2][0]=0.0;   B[0]=0.0; 
  A[0][1]=0.0;  A[1][1]=0.0;  A[2][1]=0.0;   B[1]=0.0; 
  A[0][2]=0.0;  A[1][2]=0.0;  A[2][2]=0.0;   B[2]=0.0; 
  A[0][3]=0.0;  A[1][3]=0.0;  A[2][3]=0.0;   B[3]=0.0; 
  A[0][4]=0.0;  A[1][4]=0.0;  A[2][4]=0.0;   B[4]=0.0; 
  A[0][5]=0.0;  A[1][5]=0.0;  A[2][5]=0.0;   B[5]=0.0;
  C[0]=0.0;
  C[1]=0.0;
  C[2]=0.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(102);}
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(103);} 
  }
  free(buf); free(A);

  
  if(verbose>1) printf("\n 3-parameter estimation, B[] all zeroes \n");
  m=6; n=3;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(111);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=6.0;  A[2][0]=3.0;   B[0]=0.0; 
  A[0][1]=2.0;  A[1][1]=5.0;  A[2][1]=3.0;   B[1]=0.0; 
  A[0][2]=3.0;  A[1][2]=4.0;  A[2][2]=3.0;   B[2]=0.0; 
  A[0][3]=4.0;  A[1][3]=3.0;  A[2][3]=3.0;   B[3]=0.0; 
  A[0][4]=5.0;  A[1][4]=2.0;  A[2][4]=3.0;   B[4]=0.0; 
  A[0][5]=6.0;  A[1][5]=1.0;  A[2][5]=3.0;   B[5]=0.0;
  C[0]=0.0;
  C[1]=0.0;
  C[2]=0.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(112);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(113);} 
  }
  free(buf); free(A);


  if(verbose>1) printf("\n 4-parameter estimation, where all but 1st parameter are zeroes \n");
  m=5; n=4;
  buf=(double*)calloc(n*m+m+n+n, sizeof(double));
  A=(double**)calloc(n, sizeof(double*));
  if(buf==NULL || A==NULL) return(121);
  for(i=0; i<n; i++) A[i]=buf+(i*m);
  B=buf+(m*n); X=buf+(m*n+m); C=buf+(m*n+m+n);
  A[0][0]=1.0;  A[1][0]=1.0;  A[2][0]=1.0;   A[3][0]=2.0;   B[0]=3.0;
  A[0][1]=2.0;  A[1][1]=4.0;  A[2][1]=8.0;   A[3][1]=16.0;  B[1]=6.0;
  A[0][2]=3.0;  A[1][2]=9.0;  A[2][2]=27.0;  A[3][2]=54.0;  B[2]=9.0;
  A[0][3]=4.0;  A[1][3]=16.0; A[2][3]=64.0;  A[3][3]=128.0; B[3]=12.0;
  A[0][4]=5.0;  A[1][4]=25.0; A[2][4]=125.0; A[3][4]=250.0; B[4]=15.0;
  C[0]=3.0;
  C[1]=0.0;
  C[2]=0.0;
  C[3]=0.0;
  ret=nnls(A, m, n, B, X, &R, NULL, NULL, NULL);
  if(ret!=0) {free(buf); free(A); return(122);}
  if(verbose>2) {
    printf("solution:"); for(i=0; i<n; i++) printf(" %g", X[i]); printf("\n");
    printf("\nR^2= %g  R=%g\n", R, sqrt(R));
  }
  for(i=0; i<n; i++) {
    if(!doubleMatch(X[i], C[i], 1.0E-12)) {free(buf); free(A); return(123);} 
  }
  free(buf); free(A);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
