/** @file tpclinopt.h
 *  @brief Header file for libtpclinopt.
 *  @details Header file for template library libtpclinopt.
 *  @author Vesa Oikonen
 */
#ifndef _TPCLINOPT_H_
#define _TPCLINOPT_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
/* regression */
extern int fitLine(
  double *x, double *y, const int n, double *m, double *c
);
extern int fitLinePearson(
  double *x, double *y, const int n,
  double *m, double *msd, double *c, double *csd, double *d, double *dsd, 
  double *r, double *ysd
);
extern int highestSlope(
  double *x, double *y, const int n, const int slope_n, double x_start,
  double *m, double *yi, double *xi, double *xh
);
/*****************************************************************************/

/*****************************************************************************/
/* roots */
extern int rootsCubic(
  const double a, const double b, const double c, double *x1, double *x2, double *x3
);
extern int rootsQuadratic(
  const double a, const double b, const double c, double *x1, double *x2
);
/*****************************************************************************/

/*****************************************************************************/
/* qrlsq */
extern int qrLSQ(
  double **mat, double *rhs, double *sol, 
  const unsigned int rows, const unsigned int cols, double *r2
);
extern int qr(
  double **A, int m, int n, double *B, double *X, double *rnorm,
  double *tau, double *res, double **wws, double *ws
);
extern int qr_decomp(
  double **a, int M, int N, double *tau, double **cchain, double *chain
);
extern int qr_solve(
  double **QR, int M, int N, double *tau, double *b, double *x,
  double *residual, double *resNorm, double **cchain, double *chain
);
extern int qrWeight(
  int N, int M, double **A, double *b, double *weight, double *ws
);
extern int qrWeightRm(
  int N, int M, double **A, double *b, double *weight, double *ws
);
extern int qrSimpleLSQ(double **A, double *B, int M, int N, double *X, double *r2);
extern int qrLH(
  const unsigned int m, const unsigned int n,
  double *a, double *b, double *x, double *r2
);
/*****************************************************************************/

/*****************************************************************************/
/* hholder */
extern double householder_transform(
  double *vector, int size
);
extern int householder_hm(
  double tau, double *vector, double **matrix, int rowNr, int columnNr
);
extern int householder_hv(
  double tau, int size, double *v, double *w
);
extern double householder_norm(
  double *v, int size
);
/*****************************************************************************/

/*****************************************************************************/
/* nnls */
extern int nnls(
  double **a, int m, int n, double *b, double *x,
  double *rnorm, double *w, double *zz, int *index
);
extern int nnlsWght(
  int N, int M, double **A, double *b, double *weight
);
extern int nnlsWghtSquared(
  int N, int M, double **A, double *b, double *sweight
);
/*****************************************************************************/

/*****************************************************************************/
/* bvls */
extern int bvls(
  int key, const /*unsigned*/ int m, const /*unsigned*/ int n,
  double *a, double *b, double *bl, double *bu, double *x,
  double *w, double *act, double *zz, int *istate, int *iter,
  int verbose
);
extern int llsqWght(int N, int M, double **A, double *a, double *b, double *weight);
extern int llsqWghtSquared(int N, int M, double **A, double *a, double *b, double *weight);
/*****************************************************************************/

/*****************************************************************************/
#endif /* _TPCLINOPT_H_ */
