/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcmodels.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tpc_model(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  // testing that programmer did not mess up with TPC_MODEL
  // ... it has happened

  unsigned int n=modelNr();
  if(verbose>2) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  /* check that there are no exactly same model codes */
  unsigned int i, j;
  for(i=0; i<n-1; i++) for(j=i+1; j<n; j++)
    if(strcasecmp(modelCode(i), modelCode(j))==0) {
      if(verbose>1) 
        printf("%u='%s' vs %u='%s'\n", i, modelCode(i), j, modelCode(j));
      return(2);
    }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>1) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelCode(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>3) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(strcasecmp(modelCode(0), "unknown")!=0) return(2);
  if(modelCode(n)!=NULL) return(3);
  if(strcasecmp(modelCode(1), "level")!=0) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelOldId(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>3) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(modelOldId(0)!=0) return(2);
  if(modelOldId(n)!=0) return(3);
  if(modelOldId(modelCodeIndex("fengm2"))!=1313) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelOld2New(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>3) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(modelOld2New(0)!=0) return(2);
  if(modelOld2New(n)!=0) return(3);
  if(modelOld2New(1313)!=modelCodeIndex("fengm2")) {
    if(verbose>1) {
      printf("modelOld2New(1313) := %u\n", modelOld2New(1313));
      printf("modelCodeIndex(\"fengm2\") := %u\n", modelCodeIndex("fengm2"));
    }
    return(4);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelDesc(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>3) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(strcasecmp(modelDesc(0), "unknown")!=0) return(2);
  if(modelCode(n)!=NULL) return(3);
  if(modelCode(2)==NULL) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelCodeIndex(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>3) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(modelCodeIndex((char*)NULL)!=0) return(2);
  if(modelCodeIndex("")!=0) return(3);
  if(modelCodeIndex(modelCode(4))!=4) return(4);
  if(modelCodeIndex(modelCode(n-1))!=n-1) return(5);
  if(modelCodeIndex("Level")!=1) return(6);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_modelParNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  unsigned int n;
  
  n=modelNr();
  if(verbose>3) printf("modelNr() := %u\n", n);
  if(n<=0) {return(1);}

  if(modelParNr(0)!=0) return(2);
  if(modelParNr(n)!=0) return(3);
  if(modelParNr(modelCodeIndex("pol9"))!=10) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
