/** @file tpcmodels.h
 *  @brief Header file for libtpcmodels.
 *  @details Header file for model description library.
 *  @author Vesa Oikonen
 *  @copyright (c) Turku PET Centre
 */
#ifndef _TPCMODELS_H_
#define _TPCMODELS_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
/** @brief Deprecated identification codes of mathematical functions fitted to PET data.
    @note Do not change the existing id codes, because these are used in some data files to 
     specify the applied function. 
*/
typedef enum /*mathfuncs*/ {
  MF_UNKNOWN=0,
  MF_LEVEL=100,
  MF_LINE=101, 
  MF_POL2, MF_POL3, MF_POL4, MF_POL5, MF_POL6, MF_POL7, MF_POL8, MF_POL9,
  MF_RATF11=211, MF_RATF21=221, MF_RATF22=222, MF_RATF32=232, MF_RATF33=233,
  MF_EXP1=301, MF_EXP2=302, MF_EXP3, MF_EXP4, MF_EXP5,
  MF_LUNDQVIST=321, MF_LUNDQVIST2, MF_LUNDQVIST3,
  MF_EXPBOLUSINF=331,
  MF_EXPBOLUSINF_RW=332,
  MF_EXPBOLUSINF_AZ=334,
  MF_PK11195=351,
  MF_HILL=841, MF_1MHILL=842, MF_1MHILL_ADE=843,
  MF_HILL_B=844, MF_AMHILL=845,
  MF_EHILL_PAR=846, MF_EHILL_MET=847,
  MF_MAMEDE=851, MF_1MMAMEDE,
  MF_MAYER_PAR=861, MF_MAYER_MET, MF_EMAYER_PAR, MF_EMAYER_MET,
  MF_HILL3M_PAR=871, MF_HILL3M_M1, MF_HILL3M_M2, MF_HILL3M_M3,
  MF_PF3M_PAR=881, MF_PF3M_M1, MF_PF3M_M2, MF_PF3M_M3,
  MF_RATF33D=1232,
  MF_FENGM2S=1312, MF_FENGM2=1313, MF_FENGM2E=1314,
  MF_GAMMAV=1401, MF_GAMMAVB=1402,
  MF_WEIBULLCDF_D=1421, MF_WEIBULLCDF_DD=1423,
  MF_SURGE=1431, MF_SURGE_TRAD=1432, MF_SURGE_RECIRC=1433, MF_P2B_SRC=1434, MF_SURGE_FDG=1435,
  MF_HILL_D=1801, MF_HILL_DD=1811, MF_HILL_SDD=1821,
  MF_IMGPROFILE=2111,
  MF_GRAHAM_INP=9501, MF_GRAHAM_EINP, MF_GRAHAM_INPM,
  MF_HUANG_MET=9601,
  MF_CARSON_EMET,
  MF_NEW_MET,
  MF_MLMCM=9701,
  MF_LAST
} mf;
/*****************************************************************************/

/*****************************************************************************/
/** @brief Optimality Criterion for statistical optimizations. */
typedef enum {
  OPTCRIT_UNKNOWN, ///< Unknown optimality criterion.
  OPTCRIT_OLS, ///< Ordinary Least Squares (sum-of-squares, SS).
  OPTCRIT_LMS, ///< Least Median of Squares.
  OPTCRIT_LAD, ///< Least Absolute Deviations (sum of absolute deviations, LAE, LAV, LAR).
  OPTCRIT_MAD, ///< Median Absolute Deviation.
  OPTCRIT_ODR, ///< Orthogonal Distance Regression (sum of perpendicular distances).
  OPTCRIT_LAST ///< List end.
} optimality_criterion;
/*****************************************************************************/

/*****************************************************************************/
/* aic */
extern double aicSS(double ss, const unsigned int n, const unsigned int k);
extern unsigned int parFreeNr(const unsigned int n, double *pLower, double *pUpper);
/*****************************************************************************/
/* modell */
extern unsigned int modelNr();
extern char *modelCode(const unsigned int i);
extern unsigned int modelOldId(const unsigned int i);
extern unsigned int modelOld2New(const unsigned int i);
extern char *modelDesc(const unsigned int i);
extern unsigned int modelCodeIndex(const char *s);
extern unsigned int modelParNr(const unsigned int code);
/*****************************************************************************/

/*****************************************************************************/
/* optcrit */
extern unsigned int optcritNr();
extern char *optcritCode(optimality_criterion id);
extern char *optcritDesc(optimality_criterion id);
extern optimality_criterion optcritId(const char *s);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCMODELS */
