/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcnifti.h"
/*****************************************************************************/

/*****************************************************************************/
int test_niftiBasename(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr=NULL;
  niftiBasename(cptr);
  if(verbose>1) printf("did not segfault, that is good.\n");

  char fname[FILENAME_MAX], bname[FILENAME_MAX];

  fname[0]=bname[0]='\0';
  niftiBasename(bname);
  if(verbose>1) printf("did not segfault, that is good.\n");

  strcpy(fname, "a"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(10);

  strcpy(fname, "./a"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("./a", bname)!=0) return(11);

  strcpy(fname, "./a/"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("./a/", bname)!=0) return(12);

  strcpy(fname, " ./a/b "); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("./a/b", bname)!=0) return(12);

  strcpy(fname, "a.nii"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(20);

  strcpy(fname, "a.img"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(21);

  strcpy(fname, "a.hdr"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(22);

  strcpy(fname, "a.sif"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(23);

  strcpy(fname, "a.img.sif"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(24);

  strcpy(fname, "a.img.hdr"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp("a", bname)!=0) return(25);

  strcpy(fname, "."); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp(".", bname)!=0) return(30);

  strcpy(fname, ".nii"); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp(".nii", bname)!=0) return(31);

  strcpy(fname, ".img."); strcpy(bname, fname);
  niftiBasename(bname); if(verbose>1) printf("'%s' -> '%s'\n", fname, bname);
  if(strcmp(".img", bname)!=0) return(32);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
