/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcnlopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_nlopt1D(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret, parNr;
  NLOPT nlo; nloptInit(&nlo);
  double e;

  if(verbose>1) printf("\ncalling function with empty input\n");
  ret=nlopt1D(&nlo, 0, status);
  if(ret==TPCERROR_OK) return(1);
  if(verbose>2) printf("  -> error returned, which is good\n");


  if(verbose>1) printf("\n Simple f(x)=x^2, with N=1 \n");
  parNr=1;
  ret=nloptAllocate(&nlo, parNr);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(11);}
  /* set parameter limits and initial values */
  nlo.totalNr=1;
  nlo.xfull[0]=2.0;  nlo.xlower[0]=0.0;  nlo.xupper[0]=255.0;
  nlo.xtol[0]=1.E-04; nlo.xdelta[0]=1.0;
  /* set object function */
  nlo._fun=nloptX2;
  /* Optimize */
  nlo.maxFunCalls=500;
  ret=nlopt1D(&nlo, 0, status);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(verbose>3) printf("  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(12);}
  if(verbose>2) for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-50.5);
    if(e>1.0E-04) {
      ret++; if(verbose>2) printf("  |x[%d]-true|=%g\n", i, e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(13);}

  if(verbose>1) printf("\n Same function but optimum at the lower limit \n");
  nlo.funCalls=0;
  nlo.xfull[0]=200.0;  nlo.xlower[0]=52.0;  nlo.xupper[0]=300.0;
  nlo.xtol[0]=1.E-03; nlo.xdelta[0]=1.0;
  nlo.maxFunCalls=500;
  ret=nlopt1D(&nlo, 0, status);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(verbose>3) printf("  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(21);}
  if(verbose>2) for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-52.0);
    if(e>1.0E-03) {
      ret++; if(verbose>2) printf("  |x[%d]-true|=%g\n", i, e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(22);}


  if(verbose>1) printf("\n Same function but optimum at the upper limit \n");
  nlo.funCalls=0;
  nlo.xfull[0]=25.1;  nlo.xlower[0]=0.0;  nlo.xupper[0]=50.2;
  nlo.xtol[0]=1.E-03; nlo.xdelta[0]=1.0;
  nlo.maxFunCalls=500;
  ret=nlopt1D(&nlo, 0, status);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(verbose>3) printf("  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(31);}
  if(verbose>2) for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-50.2);
    if(e>1.0E-03) {
      ret++; if(verbose>2) printf("  |x[%d]-true|=%g\n", i, e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(32);}


  if(verbose>1) printf("\n Same function but initial guess at the lower limit \n");
  nlo.funCalls=0;
  nlo.xfull[0]=0.0;  nlo.xlower[0]=0.0;  nlo.xupper[0]=500.0;
  nlo.xtol[0]=1.E-04; nlo.xdelta[0]=1.0;
  nlo.maxFunCalls=500;
  ret=nlopt1D(&nlo, 0, status);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(verbose>3) printf("  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(41);}
  if(verbose>2) for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-50.5);
    if(e>1.0E-04) {
      ret++; if(verbose>2) printf("  |x[%d]-true|=%g\n", i, e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(42);}


  if(verbose>1) printf("\n Same function but initial guess at the upper limit \n");
  nlo.funCalls=0;
  nlo.xfull[0]=500.0;  nlo.xlower[0]=0.0;  nlo.xupper[0]=500.0;
  nlo.xtol[0]=1.E-04; nlo.xdelta[0]=1.0;
  nlo.maxFunCalls=500;
  ret=nlopt1D(&nlo, 0, status);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(verbose>3) printf("  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(51);}
  if(verbose>2) for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-50.5);
    if(e>1.0E-04) {
      ret++; if(verbose>2) printf("  |x[%d]-true|=%g\n", i, e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(52);}

  nloptFree(&nlo);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
