/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcnlopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_nloptPowellBrent(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret, parNr;
  NLOPT nlo; nloptInit(&nlo);
  double e;

  /* Seed for random number generator */
  drandSeed(1);

  if(verbose>1) printf("\ncalling function with empty input\n");
  ret=nloptPowellBrent(&nlo, 1, status);
  if(ret==TPCERROR_OK) return(1);
  if(verbose>2) printf("  -> error returned, which is good\n");


  if(verbose>1) printf("\n Rosenbrock's valley with N=2 \n");
  parNr=2;
  ret=nloptAllocate(&nlo, parNr);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(11);}
  /* set parameter initial values etc */
  nlo.xfull[0]=2.0;  nlo.xdelta[0]=0.2;  nlo.xtol[0]=0.0001;
  nlo.xfull[1]=0.5;  nlo.xdelta[1]=0.1;  nlo.xtol[1]=0.0001;
  /* set object function */
  nlo._fun=nloptDejong2;
  /* Optimize */
  ret=nloptPowellBrent(&nlo, 2, NULL /*status*/);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(12);}
  if(verbose>2)
    for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-1.0);
    if(e>5.0E-03) {
      ret++; if(verbose>2) printf("  |x-true|=%g\n", e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(13);}
  nloptFree(&nlo);



  if(verbose>1) printf("\n Rosenbrock's valley with N=5 \n");
  parNr=5;
  ret=nloptAllocate(&nlo, parNr);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(21);}
  /* set parameter initial values etc */
  nlo.xfull[0]=2.0;  nlo.xdelta[0]=0.2;  nlo.xtol[0]=0.0001;
  nlo.xfull[1]=0.5;  nlo.xdelta[1]=0.1;  nlo.xtol[1]=0.0001;
  nlo.xfull[2]=1.5;  nlo.xdelta[2]=0.1;  nlo.xtol[2]=0.0001;
  nlo.xfull[3]=0.3;  nlo.xdelta[3]=0.2;  nlo.xtol[3]=0.0001;
  nlo.xfull[4]=2.5;  nlo.xdelta[4]=0.4;  nlo.xtol[4]=0.0001;
  /* set object function */
  nlo._fun=nloptDejong2;
  /* Optimize */
  ret=nloptPowellBrent(&nlo, 3, NULL /*status*/);
  if(verbose>2) printf("  -> ret := %d\n", ret);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(22);}
  if(verbose>2)
    for(int i=0; i<parNr; i++) printf("  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-1.0);
    if(e>5.0E-03) {
      ret++; if(verbose>2) printf("  |x-true|=%g\n", e);
    }
  }
  if(ret>0) {nloptFree(&nlo); return(23);}
  nloptFree(&nlo);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
