/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parSelectByAnother(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("\n should not crash with NULL input\n");
  if(parSelectByAnother(NULL, NULL, NULL, NULL, NULL)==TPCERROR_OK) return(1);
  
  PAR par; parInit(&par);
  int n1=9, n2=9;

  if(verbose>1) printf("\n should not crash with empty PAR struct\n");
  if(parSelectByAnother(NULL, &par, &n1, &n2, NULL)==TPCERROR_OK) return(2);
  if(n1!=0 || n2!=0) return(3);
  n1=n2=8;
  if(parSelectByAnother(&par, NULL, &n1, &n2, NULL)==TPCERROR_OK) return(4);
  if(n1!=0 || n2!=0) return(5);

  int ret;
  
  if(verbose>1) printf("\n create test data\n");
  ret=create_par(&par); if(ret!=0) {parFree(&par); return(10);}
  if(verbose>1) parWrite(&par, stdout, PAR_FORMAT_CSV_UK, 0, NULL);

  if(verbose>1) printf("\n test against NULL\n");
  ret=parSelectByAnother(&par, NULL, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); return(101);}
  if(n1!=0 || n2!=0) {parFree(&par); return(102);}

  if(verbose>1) printf("\n test against itself\n");
  ret=parSelectByAnother(&par, &par, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); return(111);}
  if(n1!=par.parNr || n2!=par.tacNr) {parFree(&par); return(112);}

  if(verbose>1) printf("\n create test data\n");
  PAR par2; parInit(&par2);
  ret=create_par(&par2); if(ret!=0) {parFree(&par); return(20);}

  if(verbose>1) printf("\n one parameter less\n");
  par2.parNr--;
  if(verbose>1) parWrite(&par2, stdout, PAR_FORMAT_CSV_UK, 0, NULL);
  ret=parSelectByAnother(&par, &par2, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(201);}
  if(verbose>2) printf("parNr=%d n1=%d\n", par.parNr, n1);
  if(n1!=par.parNr-1 || n2!=par.tacNr) {parFree(&par); parFree(&par2); return(202);}
  ret=parSelectByAnother(&par2, &par, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(211);}
  if(verbose>2) printf("parNr=%d n1=%d\n", par2.parNr, n1);
  if(n1!=par2.parNr || n2!=par2.tacNr) {parFree(&par); parFree(&par2); return(212);}
  par2.parNr++;

  if(verbose>1) printf("\n one region less\n");
  par2.tacNr--;
  if(verbose>1) parWrite(&par2, stdout, PAR_FORMAT_CSV_UK, 0, NULL);
  ret=parSelectByAnother(&par, &par2, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(221);}
  if(verbose>2) printf("tacNr=%d n2=%d\n", par.tacNr, n2);
  if(n1!=par.parNr || n2!=par.tacNr-1) {parFree(&par); parFree(&par2); return(222);}
  ret=parSelectByAnother(&par2, &par, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(231);}
  if(verbose>2) printf("tacNr=%d n1=%d\n", par2.tacNr, n2);
  if(n1!=par2.parNr || n2!=par2.tacNr) {parFree(&par); parFree(&par2); return(232);}
  par2.tacNr++;

  if(verbose>1) printf("\n different region and parameter name\n");
  strcpy(par2.n[1].name, "p");
  strcpy(par2.r[0].name, "tac1");
  if(verbose>1) parWrite(&par2, stdout, PAR_FORMAT_CSV_UK, 0, NULL);
  ret=parSelectByAnother(&par, &par2, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(301);}
  if(verbose>2) printf("n1=%d n2=%d\n", n1, n2);
  if(n1!=par.parNr-1 || n2!=par.tacNr-1) {parFree(&par); parFree(&par2); return(302);}

  if(verbose>1) printf("\n no matching region and parameter names\n");
  for(int i=0; i<par2.parNr; i++) sprintf(par2.n[i].name, "p%d", 1+i);
  for(int i=0; i<par2.tacNr; i++) sprintf(par2.r[i].name, "tac%d", 1+i);
  if(verbose>1) parWrite(&par2, stdout, PAR_FORMAT_CSV_UK, 0, NULL);
  ret=parSelectByAnother(&par, &par2, &n1, &n2, NULL);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(311);}
  if(verbose>2) printf("n1=%d n2=%d\n", n1, n2);
  if(n1!=0 || n2!=0) {parFree(&par); parFree(&par2); return(312);}
  
  parFree(&par); parFree(&par2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parCombineTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("\n should not crash with NULL input\n");
  if(parCombineTACs(NULL, NULL, NULL)==TPCERROR_OK) return(1);
  
  PAR par; parInit(&par);

  if(verbose>1) printf("\n should not crash with empty PAR struct\n");
  if(parCombineTACs(NULL, &par, NULL)==TPCERROR_OK) return(2);
  if(parCombineTACs(&par, NULL, NULL)==TPCERROR_OK) return(3);

  int ret;
  
  if(verbose>1) printf("\n create test data\n");
  ret=create_par(&par); if(ret!=0) {parFree(&par); return(10);}
  if(verbose>1) parWrite(&par, stdout, PAR_FORMAT_CSV_UK, 0, NULL);

  if(verbose>1) printf("\n test against NULL\n");
  if(parCombineTACs(&par, NULL, NULL)==TPCERROR_OK) {parFree(&par); return(101);}
  if(parCombineTACs(NULL, &par, NULL)==TPCERROR_OK) {parFree(&par); return(102);}

  if(verbose>1) printf("\n create test data\n");
  PAR par2; parInit(&par2);
  ret=create_par(&par2); if(ret!=0) {parFree(&par); parFree(&par2); return(20);}
  if(verbose>1) printf("\n one region less\n");
  par2.tacNr--;
  for(int i=0; i<par2.parNr; i++) sprintf(par2.n[i].name, "p%d", 1+i);
  if(verbose>1) parWrite(&par2, stdout, PAR_FORMAT_CSV_UK, 0, NULL);
  if(parCombineTACs(&par, &par2, NULL)!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(201);}
  if(verbose>1) parWrite(&par, stdout, PAR_FORMAT_CSV_UK, 0, NULL);
  parDeletePar(&par, 0);
  parDeletePar(&par, 0);
  parDeletePar(&par, 0);
  parDeletePar(&par, 0);
  parDeletePar(&par, 0);
  if(parCompareParameterUnits(&par, &par2, -1, NULL)) {parFree(&par); parFree(&par2); return(202);}
  if(parCompareTacNames(&par, &par2, 0, 1, NULL)) {parFree(&par); parFree(&par2); return(203);}
  for(int i=0; i<par2.tacNr; i++)
    if(parCompareParameters(&par, &par2, -1, i, 1, 1, 1, 1.0E-06, 1.0E-07, NULL))
      {parFree(&par); parFree(&par2); return(i+211);}

  parFree(&par); parFree(&par2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
