/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parWriteIFT(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret, pi;
  PAR par; parInit(&par);
  IFT ift; iftInit(&ift);


  if(verbose>1) printf("create parameter data for testing\n");
  ret=create_par_ift(&par); 
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 1;}
  /* set different fit time to second tac, so that it will not be saved
     in main header, but separately for each tac */
  par.r[1].start=10.0;

  FILE *fp;
  char fname[128];
  strcpy(fname, "test1.ift");
  if(verbose>1) printf("Open %s for writing\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par); iftFree(&ift); return 2;}
  if(verbose>1) printf("write test PAR to IFT\n");
  ret=parWriteIFT(&par, fp, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 3;}
  if(verbose>1) printf("read IFT\n");
  fp=fopen(fname, "r");
  if(fp==NULL) {parFree(&par); iftFree(&ift); return 4;}
  ret=iftRead(&ift, fp, 1, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 5;}
  if(verbose>10) iftWrite(&ift, stdout, NULL);

  if(verbose>2) printf("verifying IFT\n");
  ret=pi=0;
  if(strcmp(ift.item[pi].key, "content")!=0) ret++;
  if(strcmp(ift.item[pi].value, "parameters")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "par_nr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "2")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "studynr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "test0002")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "data_nr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "23")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_nr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "4")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "parameter-set")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "tac_name")!=0) ret++;
  if(strcmp(ift.item[pi].value, "roi1")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_start")!=0) ret++;
  if(strcmp(ift.item[pi].value, "30 min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_end")!=0) ret++;
  if(strcmp(ift.item[pi].value, "60 min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "wss")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1000")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par1")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1 1/min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par2")!=0) ret++;
  if(strcmp(ift.item[pi].value, "2 unitless")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "parameter-set")!=0) ret++;
  if(strcmp(ift.item[pi].value, "2")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "tac_name")!=0) ret++;
  if(strcmp(ift.item[pi].value, "roi2")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_start")!=0) ret++;
  if(strcmp(ift.item[pi].value, "10 min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_end")!=0) ret++;
  if(strcmp(ift.item[pi].value, "60 min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "wss")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1000")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par1")!=0) ret++;
  if(strcmp(ift.item[pi].value, "3 1/min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par2")!=0) ret++;
  if(strcmp(ift.item[pi].value, "4 unitless")!=0) ret++;

  if(ret>0) {parFree(&par); iftFree(&ift); return 12;}

  parFree(&par); iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parToIFT(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret, pi;

  if(verbose>1) printf("testing programmer's stupidity\n");
  ret=parToIFT(NULL, NULL, status);
  if(ret==TPCERROR_OK) return 1;

  PAR par; parInit(&par);
  IFT ift; iftInit(&ift);

  if(verbose>1) printf("testing with empty data\n");
  ret=parToIFT(&par, &ift, status);
  if(ret==TPCERROR_OK) return 2;

  if(verbose>1) printf("create parameter data for testing\n");
  ret=create_par_ift(&par); 
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 3;}

  if(verbose>1) printf("copy test PAR to IFT\n");
  ret=parToIFT(&par, &ift, status);
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 11;}
  if(verbose>10) iftWrite(&ift, stdout, NULL);
  if(verbose>2) printf("verifying IFT\n");
  ret=pi=0;
  if(strcmp(ift.item[pi].key, "content")!=0) ret++;
  if(strcmp(ift.item[pi].value, "parameters")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "par_nr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "2")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "studynr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "test0002")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "data_nr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "23")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_nr")!=0) ret++;
  if(strcmp(ift.item[pi].value, "4")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_start")!=0) ret++;
  if(strcmp(ift.item[pi].value, "30 min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "fit_end")!=0) ret++;
  if(strcmp(ift.item[pi].value, "60 min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "parameter-set")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "tac_name")!=0) ret++;
  if(strcmp(ift.item[pi].value, "roi1")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "wss")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1000")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par1")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1 1/min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par2")!=0) ret++;
  if(strcmp(ift.item[pi].value, "2 unitless")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "parameter-set")!=0) ret++;
  if(strcmp(ift.item[pi].value, "2")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "tac_name")!=0) ret++;
  if(strcmp(ift.item[pi].value, "roi2")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "wss")!=0) ret++;
  if(strcmp(ift.item[pi].value, "1000")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par1")!=0) ret++;
  if(strcmp(ift.item[pi].value, "3 1/min")!=0) ret++;
  pi++;
  if(strcmp(ift.item[pi].key, "Par2")!=0) ret++;
  if(strcmp(ift.item[pi].value, "4 unitless")!=0) ret++;

  if(ret>0) {parFree(&par); iftFree(&ift); return 12;}

  parFree(&par); iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parFromIFT(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret, pi, ri;

  if(verbose>1) printf("testing programmer's stupidity\n");
  ret=parFromIFT(NULL, NULL, status);
  if(ret==TPCERROR_OK) return 1;

  PAR par; parInit(&par);
  PAR par2; parInit(&par2);
  IFT ift; iftInit(&ift);

  if(verbose>1) printf("testing with empty data\n");
  ret=parFromIFT(&par, &ift, status);
  if(ret==TPCERROR_OK) return 2;

  if(verbose>1) printf("create parameter data for testing\n");
  ret=create_par_ift(&par); 
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 3;}
  if(verbose>1) printf("copy test PAR to IFT\n");
  ret=parToIFT(&par, &ift, status);
  if(ret!=TPCERROR_OK) {parFree(&par); iftFree(&ift); return 4;}

  if(verbose>1) printf("copy IFT to PAR\n");
  ret=parFromIFT(&par2, &ift, status);
  if(ret!=TPCERROR_OK) {parFree(&par);parFree(&par2); iftFree(&ift); return 11;}
  if(verbose>10) parWrite(&par2, stdout, PAR_FORMAT_TSV_UK, 1, NULL);

  if(verbose>1) printf("verify PAR contents\n");
  if(par2.parNr!=par.parNr || par2.tacNr!=par.tacNr) {
    parFree(&par); parFree(&par2); iftFree(&ift); return 12;}
  for(ri=0; ri<par.tacNr; ri++) for(pi=0; pi<par.parNr; pi++)
    if(!doubleMatch(par2.r[ri].p[pi], par.r[ri].p[pi], 0.001)) {
      parFree(&par); parFree(&par2); iftFree(&ift); return 13;}
  for(ri=0; ri<par.tacNr; ri++) {
    if(strcasecmp(par2.r[ri].name, par.r[ri].name)) {
      parFree(&par); parFree(&par2); iftFree(&ift); return 14;}
  }
  for(pi=0; pi<par.parNr; pi++) {
    if(strcasecmp(par2.n[pi].name, par.n[pi].name)) {
      parFree(&par); parFree(&par2); iftFree(&ift); return 15;}
    if(par2.n[pi].unit!=par.n[pi].unit) {
      parFree(&par); parFree(&par2); iftFree(&ift); return 16;}
  }

  parFree(&par); parFree(&par2); iftFree(&ift);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
