/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parFormattxt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;
  cptr=parFormattxt(-1); if(cptr!=NULL) return 1;
  cptr=parFormattxt(PAR_FORMAT_UNKNOWN); if(strcmp(cptr, "Unknown")) return 2;
  cptr=parFormattxt(9999); if(cptr!=NULL) return 3;

  cptr=parFormattxt(PAR_FORMAT_FIT); if(strcmp(cptr, "FIT")) return(11);
  cptr=parFormattxt(PAR_FORMAT_RES); if(strcmp(cptr, "RES")) return(12);
  cptr=parFormattxt(PAR_FORMAT_XML); if(strcmp(cptr, "XML")) return(13);
  cptr=parFormattxt(PAR_FORMAT_CSV_UK); if(strcmp(cptr, "CSV-UK")) return(14);

  if(verbose>1) {
    int i=0; printf("PAR file formats:\n");
    while((cptr=parFormattxt(i))!=NULL) {printf("  %s\n", cptr); i++;}
  }

  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parFormatIdentify(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(parFormatIdentify(NULL)!=PAR_FORMAT_UNKNOWN) return(1);
  if(parFormatIdentify("")!=PAR_FORMAT_UNKNOWN) return(2);
  if(parFormatIdentify("\n")!=PAR_FORMAT_UNKNOWN) return(3);

  if(parFormatIdentify("par")!=PAR_FORMAT_CSV_UK) return(11);
  if(parFormatIdentify("res")!=PAR_FORMAT_RES) return(12);
  if(parFormatIdentify("fit")!=PAR_FORMAT_FIT) return(13);
  if(parFormatIdentify("ift")!=PAR_FORMAT_IFT) return(14);
  if(parFormatIdentify("html")!=PAR_FORMAT_HTML) return(15);
  if(parFormatIdentify("xml")!=PAR_FORMAT_XML) return(16);

  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parFormatFromExtension(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(parFormatFromExtension(NULL)!=PAR_FORMAT_UNKNOWN) return(1);
  if(parFormatFromExtension("")!=PAR_FORMAT_UNKNOWN) return(2);
  if(parFormatFromExtension("\n")!=PAR_FORMAT_UNKNOWN) return(3);

  if(parFormatFromExtension("1.par")!=PAR_FORMAT_TSV_UK) return(11);
  if(parFormatFromExtension("/home/user/data.res")!=PAR_FORMAT_RES) return(12);
  if(parFormatFromExtension("C:\\My Data\\t12345ab.fit")!=PAR_FORMAT_FIT) return(13);
  if(parFormatFromExtension("results.ift")!=PAR_FORMAT_IFT) return(14);
  if(parFormatFromExtension("/home/.hidden/results.html")!=PAR_FORMAT_HTML) return(15);
  if(parFormatFromExtension("../../params.xml")!=PAR_FORMAT_XML) return(16);

  if(parFormatFromExtension("1.par.bak")!=PAR_FORMAT_TSV_UK) return(21);
  if(parFormatFromExtension("/home/user/data.res%")!=PAR_FORMAT_RES) return(22);
  if(parFormatFromExtension("C:\\My Data\\t12345ab.fit.old")!=PAR_FORMAT_FIT) return(23);
  if(parFormatFromExtension("results.ift.bak")!=PAR_FORMAT_IFT) return(24);
  if(parFormatFromExtension("/home/.hidden/results.html%")!=PAR_FORMAT_HTML) return(25);
  if(parFormatFromExtension("../../params.xml.bak")!=PAR_FORMAT_XML) return(26);

  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parDefaultExtension(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(parDefaultExtension(-1)!=NULL) return(1);
  if(parDefaultExtension(100)!=NULL) return(2);

  char tmp[32];

  strcpy(tmp, parDefaultExtension(PAR_FORMAT_UNKNOWN));
  if(strcmp(tmp, ".txt")) return(11);
  strcpy(tmp, parDefaultExtension(PAR_FORMAT_RES));
  if(strcmp(tmp, ".res")) return(12);
  strcpy(tmp, parDefaultExtension(PAR_FORMAT_FIT));
  if(strcmp(tmp, ".fit")) return(13);
  strcpy(tmp, parDefaultExtension(PAR_FORMAT_IFT));
  if(strcmp(tmp, ".ift")) return(14);
  strcpy(tmp, parDefaultExtension(PAR_FORMAT_CSV_UK));
  if(strcmp(tmp, ".csv")) return(15);
  strcpy(tmp, parDefaultExtension(PAR_FORMAT_TSV_INT));
  if(strcmp(tmp, ".tsv")) return(16);
  strcpy(tmp, parDefaultExtension(PAR_FORMAT_HTML));
  if(strcmp(tmp, ".html")) return(16);

  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parWrite(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  FILE *fp;
  char fname[128];
  int ret;
  PAR par1, par2;
  parInit(&par1); parInit(&par2);

  if(verbose>1) printf("trying to write empty data.\n");
  ret=parWrite(&par1, stdout, 0, 0, NULL);
  if(ret==TPCERROR_OK) {parFree(&par1); parFree(&par2); return 1;}

  if(verbose>1) printf("fill with test data.\n");
  ret=create_par(&par1);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 2;}

  par1.format=PAR_FORMAT_CSV_UK;
  strcpy(fname, "test1.csv");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 11;}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par1.format));
  ret=parWrite(&par1, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 12;}


  parFree(&par1); parFree(&par2);
  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  FILE *fp;
  char fname[128];
  int ret;
  PAR par1, par2;
  parInit(&par1); parInit(&par2);

  if(verbose>1) printf("trying to write empty data.\n");
  ret=parWrite(&par1, stdout, 0, 0, NULL);
  if(ret==TPCERROR_OK) {parFree(&par1); parFree(&par2); return 1;}

  if(verbose>1) printf("fill with test data.\n");
  ret=create_par(&par1);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 2;}

  if(verbose>1) printf("\ntesting CSV format\n\n");
  par1.format=PAR_FORMAT_CSV_UK;
  strcpy(fname, "test1.csv");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 11;}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par1.format));
  ret=parWrite(&par1, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 12;}

  if(verbose>1) printf("trying to read file %s\n", fname);
  ret=parRead(&par2, fname, status);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 13;}
  if(verbose>10)
    parWrite(&par2, stdout, PAR_FORMAT_TSV_UK, 1, status);
  if(verbose>1) printf("verify PAR contents\n");
  ret=0;
  if(parCompareParameterNames(&par1, &par2, -1, 1, status)) ret+=1;
  if(parCompareParameterUnits(&par1, &par2, -1, status)) ret+=2;
  if(parCompareTacNames(&par1, &par2, -1, 1, status)) ret+=4;
  if(parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-08, 1.0E-06, status))
    ret+=8;
  if(parCompareWSS(&par1, &par2, -1, 0.6, 1.0E-03, status)) ret+=16;
  if(ret!=0) {parFree(&par1); parFree(&par2); return(20+ret);}
  statusSet(status, __func__, __FILE__, __LINE__, 0);



  if(verbose>1) printf("\ntesting IFT format\n\n");
  parFree(&par2);
  par1.format=PAR_FORMAT_IFT;
  strcpy(fname, "test2.ift");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 101;}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par1.format));
  ret=parWrite(&par1, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 102;}

  if(verbose>1) printf("trying to read file %s\n", fname);
  ret=parRead(&par2, fname, status);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 103;}
  if(verbose>10) parWrite(&par2, stdout, PAR_FORMAT_TSV_UK, 1, status);
  if(verbose>1) printf("verify PAR contents\n");
  ret=0;
  if(parCompareParameterNames(&par1, &par2, -1, 1, status)) ret+=1;
  if(parCompareParameterUnits(&par1, &par2, -1, status)) ret+=2;
  if(parCompareTacNames(&par1, &par2, -1, 1, status)) ret+=4;
  if(parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-08, 1.0E-06, status))
    ret+=8;
  if(parCompareWSS(&par1, &par2, -1, 0.6, 1.0E-03, status)) ret+=16;
  if(ret!=0) {parFree(&par1); parFree(&par2); return(110+ret);}
  statusSet(status, __func__, __FILE__, __LINE__, 0);



  if(verbose>1) printf("\ntesting RES format\n\n");
  parFree(&par2);
  par1.format=PAR_FORMAT_RES;
  strcpy(fname, "pario1.res");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 201;}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par1.format));
  ret=parWrite(&par1, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 202;}

  if(verbose>1) printf("trying to read file %s\n", fname);
  ret=parRead(&par2, fname, status);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 203;}
  if(verbose>10) parWrite(&par2, stdout, PAR_FORMAT_TSV_UK, 1, status);
  if(verbose>1) printf("verify PAR contents\n");
  ret=0;
  if(parCompareParameterNames(&par1, &par2, -1, 1, status)) ret+=1;
  if(parCompareParameterUnits(&par1, &par2, -1, status)) ret+=2;
  if(parCompareTacNames(&par1, &par2, -1, 1, status)) ret+=4;
  if(parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-08, 1.0E-06, status))
    ret+=8;
  if(parCompareWSS(&par1, &par2, -1, 0.6, 1.0E-03, status)) ret+=16;
  if(ret!=0) {parFree(&par1); parFree(&par2); return(210+ret);}
  statusSet(status, __func__, __FILE__, __LINE__, 0);



  if(verbose>1) printf("\ntesting RES format with spaces as separator\n\n");
  parFree(&par2);
  par1.format=PAR_FORMAT_RES;
  strcpy(fname, "pario2.res");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 301;}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par1.format));
  fprintf(fp, "libtpcpar (c) 2014\n\n");
  fprintf(fp, "Date:   2013-11-28 20:49:12\n");
  fprintf(fp, "Data file:      C:\\My Documents\\PETData\\imaginary.dat\n");
  fprintf(fp, "Data range:     0 - 45 min\n");
  fprintf(fp, "Data nr:        23\n");
  fprintf(fp, "Weighting:      no\n\n");
  fprintf(fp, "Region          K1      K1/k2   k3      k4      Vb      WSS\n");
  fprintf(fp, "# Units:        mL/(mL*min)     unitless        1/min   1/min   %%       .\n");
  fprintf(fp, "roi1 . .        0.3000  0.5000  0.1000  5.0000e-003     5.0000e+000     876.54\n");
  fprintf(fp, "SD . .  .       0.1000  0.0200  1.0000e-003     .       .\n");
  fprintf(fp, "CL 95%% Lower    0.2700  .       0.0800  4.0000e-003     .       .\n");
  fprintf(fp, "CL 95%% Upper    0.3900  .       0.1200  6.0000e-003     .       .\n");
  fprintf(fp, "roi2 . .        0.3300  0.5500  0.1100  5.5000e-003     5.5000e+000     964.194\n");
  fprintf(fp, "SD . .  .       0.1100  0.0220  1.1000e-003     .       .\n");
  fprintf(fp, "CL 95%% Lower    0.2970  .       0.0880  4.4000e-003     .       .\n");
  fprintf(fp, "CL 95%% Upper    0.4290  .       0.1320  6.6000e-003     .       .\n");
  fprintf(fp, "roi3 . .        0.3630  0.6050  0.1210  6.0500e-003     6.0500e+000     1060.61\n");
  fprintf(fp, "SD . .  .       0.1210  0.0242  1.2100e-003     .       .\n");
  fprintf(fp, "CL 95%% Lower    0.3267  .       0.0968  4.8400e-003     .       .\n");
  fprintf(fp, "CL 95%% Upper    0.4719  .       0.1452  7.2600e-003     .       .\n");
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 302;}

  if(verbose>1) printf("trying to read file %s\n", fname);
  ret=parRead(&par2, fname, status);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 303;}
  if(verbose>10)
    parWrite(&par2, stdout, PAR_FORMAT_TSV_UK, 1, status);
  if(verbose>1) printf("verify PAR contents\n");
  ret=0;
  if(parCompareParameterNames(&par1, &par2, -1, 1, status)) ret+=1;
  if(parCompareParameterUnits(&par1, &par2, -1, status)) ret+=2;
  if(parCompareTacNames(&par1, &par2, -1, 1, status)) ret+=4;
  if(parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-08, 1.0E-06, status))
    ret+=8;
  if(parCompareWSS(&par1, &par2, -1, 0.6, 1.0E-03, status)) ret+=16;
  if(ret!=0) {parFree(&par1); parFree(&par2); return(310+ret);}
  statusSet(status, __func__, __FILE__, __LINE__, 0);



  if(verbose>1) printf("\ntesting FIT format\n\n");
  parFree(&par2);
  par1.format=PAR_FORMAT_FIT;
  for(int i=0; i<par1.tacNr; i++) par1.r[i].model=modelCodeIndex("pol4");
  strcpy(fname, "pario1.fit");
  if(verbose>1) printf("open file %s for writing.\n", fname);
  fp=fopen(fname, "w");
  if(fp==NULL) {parFree(&par1); parFree(&par2); return 401;}
  if(verbose>1)
    printf("trying to write in %s format\n", parFormattxt(par1.format));
  ret=parWrite(&par1, fp, PAR_FORMAT_UNKNOWN, 1, status);
  fclose(fp);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 402;}

  if(verbose>1) printf("trying to read file %s\n", fname);
  ret=parRead(&par2, fname, status);
  if(ret!=TPCERROR_OK) {parFree(&par1); parFree(&par2); return 403;}
  if(verbose>10) parWrite(&par2, stdout, PAR_FORMAT_TSV_UK, 1, status);
  if(verbose>1) printf("verify PAR contents\n");
  ret=0;
  // parameter names and units are not stored in FIT file
  //if(parCompareParameterNames(&par1, &par2, -1, status)) ret+=1;
  //if(parCompareParameterUnits(&par1, &par2, -1, status)) ret+=2;
  if(parCompareTacNames(&par1, &par2, -1, 1, status)) ret+=4;
  // parameter SD and CL are not stored in FIT file
  if(parCompareParameters(&par1, &par2, -1, -1, 1, 0, 0, 1.0E-08, 1.0E-06, status))
    ret+=8;
  if(parCompareWSS(&par1, &par2, -1, 0.6, 1.0E-03, status)) ret+=16;
  for(int i=0; i<par1.tacNr; i++) if(par1.r[i].model!=par2.r[i].model) {
    ret+=32; break;}

  if(ret!=0) {parFree(&par1); parFree(&par2); return(410+ret);}
  statusSet(status, __func__, __FILE__, __LINE__, 0);


  parFree(&par1); parFree(&par2);
  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parListLimits(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("trying to list NULL data.\n"); fflush(stdout);}
  parListLimits(NULL, stdout);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}

  PAR par; parInit(&par);

  if(verbose>1) {printf("trying to write empty data.\n"); fflush(stdout);}
  parListLimits(&par, stdout);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}

  if(verbose>1) printf("fill with test data.\n");
  create_par(&par);
  parListLimits(&par, stdout);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parWriteLimits(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("trying to write NULL data.\n"); fflush(stdout);}
  int ret=parWriteLimits(NULL, "", verbose-1);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}
  if(ret==TPCERROR_OK) {return 1;}

  char *fname="parwritelimits.txt";
  PAR par; parInit(&par);

  if(verbose>1) {printf("trying to write empty data.\n"); fflush(stdout);}
  ret=parWriteLimits(&par, fname, verbose-1);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}
  if(ret!=TPCERROR_NO_DATA) {return 2;}

  if(verbose>1) printf("fill with test data.\n");
  create_par(&par);
  ret=parWriteLimits(&par, fname, verbose-1);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  parFree(&par);

  if(verbose>1) printf("read as IFT.\n");
  IFT ift; iftInit(&ift);
  FILE *fp=fopen(fname, "r");
  ret=iftRead(&ift, fp, 1, 0, NULL);
  fclose(fp);
  if(ret!=TPCERROR_OK) {iftFree(&ift); return 12;}
  int ki=iftFindKey(&ift, "K1/k2_lower", 0);
  if(ki<0 || strcmp(ift.item[ki].value, "0.01")) {iftFree(&ift); return 13;}
  ki=iftFindKey(&ift, "K1/k2_upper", 0);
  if(ki<0 || strcmp(ift.item[ki].value, "10")) {iftFree(&ift); return 14;}
  ki=iftFindKey(&ift, "K1/k2_tol", 0);
  if(ki<0 || strcmp(ift.item[ki].value, "0.001")) {iftFree(&ift); return 15;}
  ki=iftFindKey(&ift, "k3_lower", 0);
  if(ki<0 || strcmp(ift.item[ki].value, "0")) {iftFree(&ift); return 16;}
  ki=iftFindKey(&ift, "k3_upper", 0);
  if(ki<0 || strcmp(ift.item[ki].value, "5")) {iftFree(&ift); return 17;}
  ki=iftFindKey(&ift, "k4_tol", 0);
  if(ki<0 || strcmp(ift.item[ki].value, "0.0001")) {iftFree(&ift); return 18;}
  iftFree(&ift);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parReadLimits(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) {printf("trying to read into NULL data.\n"); fflush(stdout);}
  int ret=parReadLimits(NULL, "", verbose-1);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}
  if(ret==TPCERROR_OK) {return 1;}

  char *fname="parwritelimits.txt";
  PAR par; parInit(&par);

  if(verbose>1) {printf("trying to read into empty data.\n"); fflush(stdout);}
  ret=parReadLimits(&par, fname, verbose-1);
  if(verbose>2) {printf("phew, did not segfault.\n"); fflush(stdout);}
  if(ret==TPCERROR_OK) {return 2;}

  if(verbose>1) {printf("make test data.\n"); fflush(stdout);}
  create_par(&par);
  ret=parWriteLimits(&par, fname, verbose-1);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  for(int pi=0; pi<par.parNr; pi++) par.n[pi].lim1=par.n[pi].lim2=par.n[pi].tol=nan("");

  if(verbose>1) {printf("trying to read test data.\n"); fflush(stdout);}
  ret=parReadLimits(&par, fname, verbose-1);
  if(ret!=TPCERROR_OK) {parFree(&par); return 12;}
  if(!doubleMatch(par.n[1].lim1, 0.01, 1.0E-06)) {parFree(&par); return 13;}
  if(!doubleMatch(par.n[1].lim2, 10., 1.0E-06)) {parFree(&par); return 14;}
  if(!doubleMatch(par.n[1].tol, 0.001, 1.0E-06)) {parFree(&par); return 15;}
  if(!doubleMatch(par.n[2].lim1, 0.0, 1.0E-06)) {parFree(&par); return 16;}
  if(!doubleMatch(par.n[2].lim2, 5., 1.0E-06)) {parFree(&par); return 17;}
  if(!doubleMatch(par.n[3].tol, 0.0001, 1.0E-06)) {parFree(&par); return 18;}
  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
