/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcstatist.h"
#include "test_tpcrand.h"
/*****************************************************************************/

/*****************************************************************************/
int test_drandSeed(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("Making a few seeds\n");
  int i, n=10;
  unsigned int s[n];
  for(i=0; i<n; i++) {
    s[i]=drandSeed(0);
    if(verbose>2) printf("  %u\n", s[i]);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_drand(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Make a set of random numbers, check that all are [0,1] and that mean
     is about 0.5 */
  double r, s=0.0;
  for(int i=0; i<600; i++) {
    r=drand(); if(r<0.0 || r>1.0) {return(2);}
    s+=r;
  }
  s/=(double)600;
  if(verbose>2) printf("mean of 600 drand() results is %.6f\n", s);
  if(!doubleMatch(0.5, s, 0.05)) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_drandRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Make a set of random numbers with even distribution, check that all are 
     between specified limits and that mean is in the middle */
  /* Check also that sd is close to the correct value, sd=(up-low)/sqrt(12),
     now that we have uniform distribution.
     CV would be cv=(up-low)/(sqrt(3)*(low+up)) that we don't need to test here.
  */
  int ret=0;
  unsigned int i, n=1000;
  double r[n], low, up, mean, sd, truemean, truesd;

  low=200.0; up=400.0;
  truemean=0.5*(low+up); truesd=(up-low)/sqrt(12.0);
  if(verbose>1) printf("[%g,%g] (%g+-%g):\n", low, up, truemean, truesd);
  ret=drandRange(n, r, low, up, 0);
  if(ret!=0) return(2);
  for(i=0; i<n; i++) if(r[i]<low || r[i]>up) return(3);
  statMeanSD(r, n, &mean, &sd, NULL);
  if(verbose>1) printf("drandRange() mean=%g sd=%g\n", mean, sd);
  if(!doubleMatch(truemean, mean, 0.07*truemean)) return(4);
  if(!doubleMatch(truesd, sd, 0.10*truesd)) return(5);
  

  low=-0.9; up=0.1;
  truemean=0.5*(low+up); truesd=(up-low)/sqrt(12.0);
  if(verbose>1) printf("[%g,%g] (%g+-%g):\n", low, up, truemean, truesd);
  ret=drandRange(n, r, low, up, 0);
  if(ret!=0) return(12);
  for(i=0; i<n; i++) if(r[i]<low || r[i]>up) return(13);
  statMeanSD(r, n, &mean, &sd, NULL);
  if(verbose>1) printf("drandRange() mean=%g sd=%g\n", mean, sd);
  if(!doubleMatch(truemean, mean, fabs(0.07*truemean))) return(14);
  if(!doubleMatch(truesd, sd, 0.10*truesd)) return(15);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_drandGaussian(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Make a set of random numbers */
  int n=1000;
  double r[n], mean, meansd;
  if(verbose>1) printf("  true mean=%g and sd=%g\n", 0.0, 1.0);
  for(int i=0; i<n; i++) r[i]=drandGaussian();
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(r, n, &mean, &meansd, NULL);
  if(verbose>1) printf("  simulated mean=%g and sd=%g\n", mean, meansd);
  if(!doubleMatch(0.0, mean, 0.15)) return 2;
  if(!doubleMatch(1.0, meansd, 0.10)) return 3;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_drandExponential(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  /* Make a set of random numbers */
  int n=1000;
  double r[n], mean=1.0, meansd;
  if(verbose>1) printf("  true mean=%g\n", mean);
  for(int i=0; i<n; i++) r[i]=drandExponential(mean);
  /* Calculate the mean and SD of the created random numbers */
  statMeanSD(r, n, &mean, &meansd, NULL);
  if(verbose>1) printf("  simulated mean=%g and sd=%g\n", mean, meansd);
  if(!doubleMatch(1.0, mean, 0.10)) return 2;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
