/** @file sort.c
 *  @brief Functions for sorting simple arrays.
 */
/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/
#include "tpcstatist.h"
/*****************************************************************************/

/*****************************************************************************/
/// @cond
/* Local functions */
static int statIntCompAsc(const void *i, const void *j)
{
  return( *(int *)i - *(int *)j);
}
static int statIntCompDesc(const void *i, const void *j)
{
  return( *(int *)j - *(int *)i);
}
static int statUnsignedCompAsc(const void *i, const void *j)
{
  const unsigned int *ui = (const unsigned int *)i;
  const unsigned int *uj = (const unsigned int *)j;
  if(*ui<*uj) return(-1);
  else if(*ui>*uj) return(+1);
  else return(0);
}
static int statUnsignedCompDesc(const void *i, const void *j)
{
  const unsigned int *ui = (const unsigned int *)i;
  const unsigned int *uj = (const unsigned int *)j;
  if(*ui<*uj) return(+1);
  else if(*ui>*uj) return(-1);
  else return(0);
}
static int statDoubleCompAsc(const void *i, const void *j)
{
  const double *di = (const double *)i;
  const double *dj = (const double *)j;
  return(*di > *dj) - (*di < *dj);
}
static int statDoubleCompDesc(const void *i, const void *j)
{
  const double *di = (const double *)i;
  const double *dj = (const double *)j;
  return(*di < *dj) - (*di > *dj);
}
/// @endcond
/*****************************************************************************/

/*****************************************************************************/
/** Sort the given integer list into ascending or descending order.
 *  @author Vesa Oikonen
 */
void statSortInt(
  /** Pointer to data array of size n */
  int *data,
  /** Length of data array */
  unsigned int n,
  /** Ascending (0) or descending (<>0) order */
  int order
) {
  if(n<2 || data==NULL) return;
  if(order==0) qsort(data, n, sizeof(int), statIntCompAsc);
  else qsort(data, n, sizeof(int), statIntCompDesc);
}
/*****************************************************************************/

/*****************************************************************************/
/** Sort the given unsigned integer list into ascending or descending order.
 *  @author Vesa Oikonen
 */
void statSortUnsigned(
  /** Pointer to data array of size n */
  unsigned int *data,
  /** Length of data array */
  unsigned int n,
  /** Ascending (0) or descending (<>0) order */
  int order
) {
  if(n<2 || data==NULL) return;
  if(order==0) qsort(data, n, sizeof(unsigned int), statUnsignedCompAsc);
  else qsort(data, n, sizeof(unsigned int), statUnsignedCompDesc);
}
/*****************************************************************************/

/*****************************************************************************/
/** Sort the given double list into ascending or descending order.
 *  @author Vesa Oikonen
 */
void statSortDouble(
  /** Pointer to data array of size n */
  double *data,
  /** Length of data array */
  unsigned int n,
  /** Ascending (0) or descending (<>0) order */
  int order
) {
  if(n<2 || data==NULL) return;
  if(order==0) qsort(data, n, sizeof(double), statDoubleCompAsc);
  else qsort(data, n, sizeof(double), statDoubleCompDesc);
}
/*****************************************************************************/

/*****************************************************************************/
