/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcstatist.h"
/*****************************************************************************/

/*****************************************************************************/
int test_statMedian(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  {
    if(verbose>1) {printf("\n Testing with invalid data \n"); fflush(stdout);}
    if(!isnan(statMedian(NULL, 0))) return(1);
    if(!isnan(statMedian(NULL, 1))) return(2);
    if(!isnan(statMedian(NULL, 2))) return(3);
    double a[]={1.0, 2.0};
    if(!isnan(statMedian(a, 0))) return(5);
    if(!isnan(statMedian(a, -1))) return(6);
  }

  {
    if(verbose>1) {printf("\n Testing with n=1 and n=2 \n"); fflush(stdout);}
    double a[]={3.0, 2.0};
    if(statMedian(a, 1)!=3.0) return(11);
    if(!doubleMatch(2.5, statMedian(a, 2), 1.0E-12)) return(21);
    a[0]=a[1]=0.0;
    if(!doubleMatch(0.0, statMedian(a, 2), 1.0E-12)) return(22);
    a[0]=a[1]=-10.0;
    if(!doubleMatch(-10.0, statMedian(a, 2), 1.0E-12)) return(23);
    a[0]=-10.0; a[1]=+10.0;
    if(!doubleMatch(0.0, statMedian(a, 2), 1.0E-12)) return(24);
  }

  {
    if(verbose>1) {printf("\n Testing with n=3 \n"); fflush(stdout);}
    double a[]={3.0, 2.0, 1.0};
    if(statMedian(a, 3)!=2.0) return(31);
    a[0]=a[1]=1.0; a[2]=2.0;
    if(statMedian(a, 3)!=1.0) return(32);
    a[0]=a[1]=0.0; a[2]=2.0;
    if(statMedian(a, 3)!=0.0) return(33);
    a[0]=a[1]=a[2]=-1.0;
    if(statMedian(a, 3)!=-1.0) return(34);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_statKthSmallest(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  {
    if(verbose>1) {printf("\n Testing with invalid data \n"); fflush(stdout);}
    if(!isnan(statKthSmallest(NULL, 0, 0))) return(1);
    if(!isnan(statKthSmallest(NULL, 1, 1))) return(2);
    if(!isnan(statKthSmallest(NULL, 2, 1))) return(3);
    double a[]={1.0, 2.0};
    if(!isnan(statKthSmallest(a, 0, 0))) return(5);
    if(!isnan(statKthSmallest(a, 1, 1))) return(6);
    if(!isnan(statKthSmallest(a, 1, -1))) return(7);
    if(!isnan(statKthSmallest(a, 2, 2))) return(8);
  }

  {
    if(verbose>1) {printf("\n Testing with n=1 \n"); fflush(stdout);}
    double a[]={3.0, 2.0, 1.0};
    if(statKthSmallest(a, 1, 0)!=3.0) return(11);
  }
  {
    if(verbose>1) {printf("\n Testing with n=2 \n"); fflush(stdout);}
    double a[]={3.0, 2.0, 1.0};
    double v;
    v=statKthSmallest(a, 2, 0); if(v!=2.0) {printf("  v=%g\n", v); return(21);}
    v=statKthSmallest(a, 2, 1); if(v!=3.0) {printf("  v=%g\n", v); return(22);}
  }
  {
    if(verbose>1) {printf("\n Testing with n=3 \n"); fflush(stdout);}
    double a[]={3.0, 2.0, 1.0};
    double v;
    v=statKthSmallest(a, 3, 0); if(v!=1.0) {printf("  v=%g\n", v); return(31);}
    v=statKthSmallest(a, 3, 1); if(v!=2.0) {printf("  v=%g\n", v); return(32);}
    v=statKthSmallest(a, 3, 2); if(v!=3.0) {printf("  v=%g\n", v); return(33);}
    a[0]=2.0; a[1]=3.0; a[2]=1.0;
    v=statKthSmallest(a, 3, 1); if(v!=2.0) {printf("  v=%g\n", v); return(34);}
  }
  {
    if(verbose>1) {printf("\n All zeroes \n"); fflush(stdout);}
    double a[]={0.0, 0.0, 0.0, 0.0};
    double v;
    v=statKthSmallest(a, 4, 0); if(v!=0.0) {printf("  v=%g\n", v); return(41);}
    v=statKthSmallest(a, 4, 1); if(v!=0.0) {printf("  v=%g\n", v); return(42);}
    v=statKthSmallest(a, 4, 2); if(v!=0.0) {printf("  v=%g\n", v); return(43);}
    v=statKthSmallest(a, 4, 3); if(v!=0.0) {printf("  v=%g\n", v); return(43);}
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
