/** @file tpcstatist.h
 *  @brief Header file for libtpcstatist.
 *  @details Header file for libtpcstatist.
 *  @author Vesa Oikonen
 */
#ifndef _TPCSTATIST_H_
#define _TPCSTATIST_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
/* mean */
extern int statMeanSD(double *data, unsigned int n, double *mean, double *sd, unsigned int *vn);
/*****************************************************************************/

/*****************************************************************************/
/* median */
extern double statMedian(double *a, const int n);
extern double statKthSmallest(double *a, const int n, const int k);
/*****************************************************************************/

/*****************************************************************************/
/* sort */
extern void statSortInt(int *data, unsigned int n, int order);
extern void statSortUnsigned(unsigned int *data, unsigned int n, int order);
extern void statSortDouble(double *data, unsigned int n, int order);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCSTATIST */
