/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/
#include <unistd.h>
/*****************************************************************************/

/*****************************************************************************/
int test_tacWriteSIF(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  FILE *fp=NULL;
  char fname1[]="test1.sif";
  char fname2[]="test2.sif";
  TAC sif; tacInit(&sif);

  if(verbose>1) printf("testing with empty data\n");
  ret=tacWriteSIF(&sif, fp, 0, status);
  if(ret==TPCERROR_OK) {return 1;}
  
  if(verbose>1) printf("removing any previous test files\n");
  if((access(fname1, 0)!=-1) && (remove(fname1)!=0)) {return 3;}
  if((access(fname2, 0)!=-1) && (remove(fname2)!=0)) {return 4;}
  if(verbose>1) printf("creating test data\n");
  ret=create_sif(&sif); if(ret!=TPCERROR_OK) {return 5;}

  if(verbose>1) printf("writing test data with prompts and randoms\n");
  fp=fopen(fname1, "w");
  if(fp==NULL) {tacFree(&sif); return 11;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteSIF(&sif, fp, 0, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&sif); return 12;}
  if(verbose>1) printf("checking that file now exists\n");
  if(access(fname1, 0) == -1) {tacFree(&sif); return 13;}

  if(verbose>1) printf("writing test data without prompts and randoms\n");
  sif.tacNr=0;
  fp=fopen(fname2, "w");
  if(fp==NULL) {tacFree(&sif); return 21;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteSIF(&sif, fp, 0, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&sif); return 22;}
  if(verbose>1) printf("checking that file now exists\n");
  if(access(fname2, 0) == -1) {tacFree(&sif); return 23;}

  tacFree(&sif);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadSIF(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  
  int ret;
  FILE *fp=NULL;
  char fname1[]="test1.sif";
  char fname2[]="test2.sif";
  TAC sif1; tacInit(&sif1);
  TAC sif2; tacInit(&sif2);

  if(verbose>1) printf("testing with empty data\n");
  ret=tacReadSIF(&sif1, NULL, NULL, status);
  if(ret==TPCERROR_OK) {return 1;}
  
  if(verbose>1) printf("removing any previous test files\n");
  if((access(fname1, 0)!=-1) && (remove(fname1)!=0)) {return 3;}
  if((access(fname2, 0)!=-1) && (remove(fname2)!=0)) {return 4;}
  if(verbose>1) printf("creating test data\n");
  ret=create_sif(&sif1); if(ret!=TPCERROR_OK) {return 5;}

  if(verbose>1) printf("writing test data with prompts and randoms\n");
  fp=fopen(fname1, "w");
  if(fp==NULL) {tacFree(&sif1); return 11;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteSIF(&sif1, fp, 0, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&sif1); return 12;}
  if(verbose>1) printf("checking that file now exists\n");
  if(access(fname1, 0) == -1) {tacFree(&sif1); return 13;}

  CSV csv; csvInit(&csv);

  if(verbose>1) printf("reading test data with prompts and randoms\n");
  fp=fopen(fname1, "r"); if(fp==NULL) {tacFree(&sif1); return 101;}
  ret=csvRead(&csv, fp, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&sif1); csvFree(&csv); return 102;}
  ret=tacReadSIF(&sif2, &csv, NULL, status); csvFree(&csv);
  if(ret!=TPCERROR_OK) {tacFree(&sif1); tacFree(&sif2); return 103;}
  if(verbose>2) {
    printf("tacNr := %d\n", sif2.tacNr);
    printf("frameNr := %d\n", sif2.sampleNr);
  }
  if(verbose>1) printf("checking test data\n");
  ret=tacCompareUnit(&sif1, &sif2, status);
  if(ret!=0) {tacFree(&sif1); tacFree(&sif2); return 111;}
  ret=tacCompareConc(&sif1, &sif2, 0, 0.1, -1.0, status);
  if(ret==0) ret=tacCompareConc(&sif1, &sif2, 1, 0.1, -1.0, status);
  if(ret!=0) {tacFree(&sif1); tacFree(&sif2); return 112;}
  ret=tacCompareTimes(&sif1, &sif2, 0.5, -1.0, status);
  if(ret!=0) {tacFree(&sif1); tacFree(&sif2); return 113;}
  tacFree(&sif2);

  if(verbose>1) printf("writing test data without prompts and randoms\n");
  sif1.tacNr=0;
  fp=fopen(fname2, "w"); if(fp==NULL) {tacFree(&sif1); return 21;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteSIF(&sif1, fp, 0, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&sif1); return 22;}
  if(verbose>1) printf("checking that file now exists\n");
  if(access(fname2, 0) == -1) {tacFree(&sif1); return 23;}

  if(verbose>1) printf("reading test data without prompts and randoms\n");
  fp=fopen(fname2, "r"); if(fp==NULL) {tacFree(&sif1); return 201;}
  ret=csvRead(&csv, fp, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&sif1); csvFree(&csv); return 202;}
  ret=tacReadSIF(&sif2, &csv, NULL, status); csvFree(&csv);
  if(ret!=TPCERROR_OK) {tacFree(&sif1); tacFree(&sif2); return 203;}
  if(verbose>2) {
    printf("tacNr := %d\n", sif2.tacNr);
    printf("frameNr := %d\n", sif2.sampleNr);
  }
  if(verbose>1) printf("checking test data\n");
  ret=tacCompareUnit(&sif1, &sif2, status);
  if(ret!=0) {tacFree(&sif1); tacFree(&sif2); return 211;}
  ret=tacCompareTimes(&sif1, &sif2, 0.5, -1.0, status);
  if(ret!=0) {tacFree(&sif1); tacFree(&sif2); return 213;}

  tacFree(&sif1); tacFree(&sif2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
/** Create test SIF data in TAC struct */
int create_sif(
  TAC *tac
) {
  int ret, fi;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 5, 3); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=2; tac->sampleNr=5;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_COUNTS;
  tac->tunit=UNIT_SEC;
  tac->isframe=1;
  /* Set region names */
  strcpy(tac->c[0].name, "Prompts");
  strcpy(tac->c[1].name, "Randoms");
  strcpy(tac->c[2].name, "Trues");
  /* Set data contents */
  for(fi=0; fi<tac->sampleNr; fi++) {
    tac->x1[fi]=(double)(10*fi); tac->x2[fi]=(double)(10*fi+10);
    tac->c[0].y[fi]=20000.0*(double)(fi+1);
    tac->c[1].y[fi]=5000.0*(double)(fi+2);
    tac->c[2].y[fi]=tac->c[0].y[fi]-tac->c[1].y[fi];
  }
  /* Set header fields */
  ret=iftPut(&tac->h, "studynr", "test0001", (char)1, NULL);
  ret=iftPut(&tac->h, "scan_start_time", "2013-11-18 14:02:54", (char)1, NULL);
  ret=iftPut(&tac->h, "isotope", "C-11", (char)1, NULL);
  
  return TPCERROR_OK;
}
/******************************************************************************/

/******************************************************************************/
