/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacWriteCSV(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  FILE *fp;
  TAC tac; tacInit(&tac);
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 1;
  
  if(verbose>1) printf("writing test data in CSV UK format\n");
  char fname1[]="data1.csv";
  fp=fopen(fname1, "w");
  if(fp==NULL) {tacFree(&tac); return 2;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteCSV(&tac, fp, 0, TAC_FORMAT_CSV_UK, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 3;}

  if(verbose>1) printf("writing test data in CSV INT format\n");
  char fname2[]="data2.csv";
  fp=fopen(fname2, "w");
  if(fp==NULL) {tacFree(&tac); return 12;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteCSV(&tac, fp, 0, TAC_FORMAT_CSV_INT, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 13;}
  
  if(verbose>1) printf("writing test data in TSV UK format\n");
  char fname3[]="data1.tsv";
  fp=fopen(fname3, "w");
  if(fp==NULL) {tacFree(&tac); return 22;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteCSV(&tac, fp, 0, TAC_FORMAT_TSV_UK, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 23;}

  if(verbose>1) printf("writing test data in TSV INT format\n");
  char fname4[]="data2.tsv";
  fp=fopen(fname4, "w");
  if(fp==NULL) {tacFree(&tac); return 32;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteCSV(&tac, fp, 0, TAC_FORMAT_TSV_INT, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 33;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadCSV(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(verbose>0) printf("tests included in testing of tacRead()\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadInveonCSV(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(verbose>0) printf("tests included in testing of tacRead()\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadCarimasTxt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(verbose>0) printf("tests included in testing of tacRead()\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
