/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetIsotope(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  TAC tac; tacInit(&tac);
  int isotope;

  if(verbose>1) printf("\n creating test data\n");
  if(create_tac(&tac)!=TPCERROR_OK) {tacFree(&tac); return 1;}

  if(verbose>1) printf("\n set and get valid isotope\n");
  tacSetIsotope(&tac, ISOTOPE_FE_52);
  isotope=tacGetIsotope(&tac);
  if(isotope!=ISOTOPE_FE_52) {tacFree(&tac); return 11;}

  if(verbose>1) printf("\n set and get invalid isotope\n");
  tacSetIsotope(&tac, ISOTOPE_UNKNOWN);
  isotope=tacGetIsotope(&tac);
  if(isotope!=ISOTOPE_UNKNOWN) {tacFree(&tac); return 12;}

  if(verbose>1) printf("\n set and get another valid isotope\n");
  tacSetIsotope(&tac, ISOTOPE_C_11);
  isotope=tacGetIsotope(&tac);
  if(isotope!=ISOTOPE_C_11) {tacFree(&tac); return 13;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetIsotope(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("tested in test_tacSetIsotope()\n");
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacDecayCorrection(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  double f;
  TAC tac; tacInit(&tac);
  TAC tac2; tacInit(&tac2);
  if(create_tac(&tac) || tacDuplicate(&tac, &tac2)) return(1);

  if(verbose>1) printf("\n should fail with missing isotope\n");
  ret=tacDecayCorrection(&tac, -7, 0, status);
  if(ret!=TPCERROR_UNKNOWN_ISOTOPE) {
    printf("status := %s\n", errorMsg(ret));
    tacFree(&tac); tacFree(&tac2); return(11);
  }
  ret=tacDecayCorrection(&tac, ISOTOPE_UNKNOWN, 0, NULL);
  if(ret!=TPCERROR_UNKNOWN_ISOTOPE) {tacFree(&tac); tacFree(&tac2); return(12);}

  if(verbose>1) printf("\n add and remove decay correction\n");
  ret=tacDecayCorrection(&tac, ISOTOPE_C_11, 1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(21);}
  if(tacGetHeaderDecayCorrection(&tac.h)!=DECAY_CORRECTED) {
    tacFree(&tac); tacFree(&tac2); return(22);}
  ret=tacDecayCorrection(&tac, ISOTOPE_C_11, 0, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(23);}
  if(tacCompareConc(&tac, &tac2, -1, 1.0E-08, 1.0E-06, status)) {
    tacFree(&tac); tacFree(&tac2); return(24);}
  if(tacGetHeaderDecayCorrection(&tac.h)!=DECAY_NOTCORRECTED) {
    tacFree(&tac); tacFree(&tac2); return(25);}

  if(verbose>1) printf("\n the same with frame mid times\n");
  tac.isframe=0;
  ret=tacDecayCorrection(&tac, ISOTOPE_O_15, 1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(31);}
  if(tacGetHeaderDecayCorrection(&tac.h)!=DECAY_CORRECTED) {
    tacFree(&tac); tacFree(&tac2); return(32);}
  ret=tacDecayCorrection(&tac, ISOTOPE_O_15, 0, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(33);}
  if(tacCompareConc(&tac, &tac2, -1, 1.0E-08, 1.0E-06, status)) {
    tacFree(&tac); tacFree(&tac2); return(34);}
  if(tacGetHeaderDecayCorrection(&tac.h)!=DECAY_NOTCORRECTED) {
    tacFree(&tac); tacFree(&tac2); return(35);}
  tac.isframe=1;

  if(verbose>1) printf("\n check that numbers are correct\n");
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 1, NULL);
  ret=tacDecayCorrection(&tac, ISOTOPE_N_13, 1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(101);}
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 1, NULL);
  for(int i=0; i<tac.sampleNr; i++) {
    f=decayCorrectionFactorFromIsotope(ISOTOPE_N_13, tac.x1[i], tac.x2[i]-tac.x1[i]);
    for(int j=0; j<tac.tacNr; j++) {
      if(!doubleMatch(tac.c[j].y[i], f*tac2.c[j].y[i], 1.0E-08)) {
        if(verbose>1) 
          printf("[%d][%d] %g vs %g\n", i, j, tac.c[j].y[i], f*tac2.c[j].y[i]);
        tacFree(&tac); tacFree(&tac2); return(102);}
    }
  }
  ret=tacDecayCorrection(&tac, ISOTOPE_N_13, 0, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(103);}

  if(verbose>1) printf("\n the same with frame mid times\n");
  tac.isframe=0;
  ret=tacDecayCorrection(&tac, ISOTOPE_O_15, 1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(111);}
  for(int i=0; i<tac.sampleNr; i++) {
    f=decayCorrectionFactorFromIsotope(ISOTOPE_O_15, tac.x[i], 0.0);
    for(int j=0; j<tac.tacNr; j++) {
      if(!doubleMatch(tac.c[j].y[i], f*tac2.c[j].y[i], 1.0E-08)) {
        if(verbose>1) 
          printf("[%d][%d] %g vs %g\n", i, j, tac.c[j].y[i], f*tac2.c[j].y[i]);
        tacFree(&tac); tacFree(&tac2); return(112);}
    }
  }

  if(verbose>1) printf("\n correction can be removed when times in sec\n");
  tacXUnitConvert(&tac, UNIT_SEC, NULL);
  ret=tacDecayCorrection(&tac, ISOTOPE_O_15, 0, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return(121);}
  if(tacCompareConc(&tac, &tac2, -1, 1.0E-08, 1.0E-06, status)) {
    tacFree(&tac); tacFree(&tac2); return(122);}


  tacFree(&tac); tacFree(&tac2);  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
