/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacYRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; 
  tacInit(&tac);
  double ymin, ymax;
  int smin, smax, imin, imax;

  if(verbose>1) printf("\n trying with empty data\n");
  ret=tacYRange(&tac, -1, NULL, NULL, NULL, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  ret=tacYRange(&tac, 0, NULL, NULL, NULL, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("\n creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 10;}

  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_SIMPLE, 0, NULL);
  ret=tacYRange(&tac, -1, &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, -2.0, 1.0E-04) || !doubleMatch(ymax, 16.0, 1.0E-04)) {
    tacFree(&tac); return 12;}
  if(smin!=0 || smax!=4 || imin!=0 || imax!=2) {tacFree(&tac); return 13;}

  ret=tacYRange(&tac, 2, &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, 4.0, 1.0E-04) || !doubleMatch(ymax, 16.0, 1.0E-04)) {
    tacFree(&tac); return 22;}
  if(smin!=0 || smax!=4 || imin!=2 || imax!=2) {tacFree(&tac); return 23;}

  tac.x[0]=tac.x2[0]=nan(""); tac.c[2].y[4]=nan("");
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_SIMPLE, 0, NULL);
  ret=tacYRange(&tac, -1, &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 31;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, -1.0, 1.0E-04) || !doubleMatch(ymax, 13.0, 1.0E-04)) {
    tacFree(&tac); return 32;}
  if(smin!=1 || smax!=3 || imin!=0 || imax!=2) {tacFree(&tac); return 33;}

  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacYRangeInXRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; 
  tacInit(&tac);
  double ymin, ymax;
  int smin, smax, imin, imax;

  if(verbose>1) printf("\n trying with empty data\n");
  ret=tacYRangeInXRange(&tac, -1, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  ret=tacYRangeInXRange(&tac, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("\n creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 10;}

  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_SIMPLE, 0, NULL);
  ret=tacYRangeInXRange(&tac, -1, -1.0E+200, +1.0E+200, 
                        &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, -2.0, 1.0E-04) || !doubleMatch(ymax, 16.0, 1.0E-04)) {
    tacFree(&tac); return 12;}
  if(smin!=0 || smax!=4 || imin!=0 || imax!=2) {tacFree(&tac); return 13;}

  ret=tacYRangeInXRange(&tac, 2, -1.0E+200, +1.0E+200, 
                        &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, 4.0, 1.0E-04) || !doubleMatch(ymax, 16.0, 1.0E-04)) {
    tacFree(&tac); return 22;}
  if(smin!=0 || smax!=4 || imin!=2 || imax!=2) {tacFree(&tac); return 23;}

  tac.x[0]=tac.x2[0]=nan(""); tac.c[2].y[4]=nan("");
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_SIMPLE, 0, NULL);
  ret=tacYRangeInXRange(&tac, -1, -1.0E+200, +1.0E+200, 
                        &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 31;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, -1.0, 1.0E-04) || !doubleMatch(ymax, 13.0, 1.0E-04)) {
    tacFree(&tac); return 32;}
  if(smin!=1 || smax!=3 || imin!=0 || imax!=2) {tacFree(&tac); return 33;}

  if(verbose>1) printf("\n creating test data\n");
  tacFree(&tac);
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 100;}
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  ret=tacYRangeInXRange(&tac, -1, 1.0, 3.0, 
                        &ymin, &ymax, &smin, &smax, &imin, &imax);
  if(ret!=0) if(ret!=TPCERROR_OK) {tacFree(&tac); return 101;}
  if(verbose>2) 
    printf("  %g %g %d %d %d %d\n", ymin, ymax, smin, smax, imin, imax);
  if(!doubleMatch(ymin, -1.0, 1.0E-04) || !doubleMatch(ymax, 10.0, 1.0E-04)) {
    tacFree(&tac); return 102;}
  if(smin!=1 || smax!=2 || imin!=0 || imax!=2) {tacFree(&tac); return 103;}



  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
