/******************************************************************************
 * This file is not compiled into the library, but it contains main()
 * which is compiled to an executable, used to test the library functions. 
 *****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/
#include "tpctacmod.h"
#include "test_tpctacmod.h"
/*****************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Usage: @P [options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " -t, --test",
  "     Run all tests for library functions.",
  0};
/*****************************************************************************/

/*****************************************************************************/
/** Run unit tests to the library functions
    @author Vesa Oikonen
    @return 0 if all tests pass, otherwise >0.
 */
int main(
  /** Nr of arguments */
  int argc,
  /** Pointer to arrays of argument string */
  char *argv[ ]
) {
  int i, help=0, version=0, verbose=1, error=0, test=0;
  int ret;
  char *cptr;

  if(argc==1) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  for(i=1; i<argc; i++) {
    if(tpcProcessStdOptions(argv[i], &help, &version, &verbose)==0) continue;
    cptr=argv[i]; if(*cptr=='-') cptr++; if(*cptr=='-') cptr++;
    if(strncasecmp(cptr, "TEST", 1)==0) {
      test=1; continue;
    } else {
      error++; break;
    }
  }
  if(error>0) {
    fprintf(stderr, "Error: specify --help for usage.\n");
    return(1);
  }
  /* Print help or version? */
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  if(test==0) return(0);

  if(verbose>0) printf("running tests for library functions...\n");
  TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  statusSet(&status, __func__, __FILE__, __LINE__, 0);
  i=10;
  /* litac */
  i++; if((ret=test_tacInterpolate(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacInterpolateInto(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacInterpolateToEqualLengthFrames(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacFramesToSteps(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacDelay(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacAUC(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacVb(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
#if(0)
  /* litacrange */
  i++; if((ret=test_tacInterpolateCheckStart(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacInterpolateCheckEnd(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
#endif
  /* tacmodelinput */
  i++; if((ret=test_tacFittime(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacReadModelingData(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacReadReference(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_tacReadModelingInput(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>2) {printf(" ok\n"); fflush(stdout);}
  /* tacfitplot */
  i++; if((ret=test_tacPlotFitSVG(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret); fflush(stderr);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>2) {printf(" ok\n"); fflush(stdout);}
  i++; if((ret=test_tacPlotLineSVG(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret); fflush(stderr);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>2) {printf(" ok\n"); fflush(stdout);}
  /* partac */
  i++; if((ret=test_tacAllocateWithPAR(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret); fflush(stderr);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>2) {printf(" ok\n"); fflush(stdout);}
  i++; if((ret=test_parAllocateWithTAC(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret); fflush(stderr);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>2) {printf(" ok\n"); fflush(stdout);}
  i++; if((ret=test_tacToPAR(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret); fflush(stderr);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  if(verbose>2) {printf(" ok\n"); fflush(stdout);}

  if(verbose>0) printf("\nAll tests passed.\n\n");
  statusFree(&status);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
