/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctacmod.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacInterpolate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  if(verbose>1) printf("\n testing with NULL data \n");
  ret=tacInterpolate(NULL, NULL, NULL, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(1);

  TAC inp, xinp, tis; tacInit(&inp); tacInit(&xinp); tacInit(&tis);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=tacInterpolate(&inp, &xinp, &tis, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n making test data \n");
  if(create_inp1(&inp) || create_tis1(&xinp)) {
    tacFree(&inp); tacFree(&xinp); return(10);}

  if(verbose>1) printf("\n interpolating to middle frame times \n");
  xinp.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolate(&inp, &xinp, &tis, NULL, NULL, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); return(11);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=inp.tacNr) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); return(12);}
  if(!doubleMatch(tis.c[0].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[0].y[1], 0.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); return(13);
  }


  if(verbose>1) printf("\n interpolating to frames \n");
  tacFree(&tis);
  xinp.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolate(&inp, &xinp, &tis, NULL, NULL, status);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&xinp); tacFree(&tis); return(21);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=inp.tacNr) {tacFree(&inp); tacFree(&tis); return(22);}
  if(!doubleMatch(tis.c[0].y[0], 6.25, 1.0E-12) || 
     !doubleMatch(tis.c[0].y[1], 0.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); return(23);
  }


  if(verbose>1) printf("\n integrating to middle frame times \n");
  TAC tis2, tis3; tacInit(&tis2); tacInit(&tis3);
  tacFree(&tis);
  xinp.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolate(&inp, &xinp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(31);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=inp.tacNr || tis2.tacNr!=inp.tacNr || tis3.tacNr!=inp.tacNr) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(32);
  }
  if(!doubleMatch(tis.c[0].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[0].y[1], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[0], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[1], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[0], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[1], 700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(33);
  }

  if(verbose>1) printf("\n interpolating to frames \n");
  tacFree(&tis); tacFree(&tis2); tacFree(&tis3);
  xinp.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolate(&inp, &xinp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(41);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=inp.tacNr || tis2.tacNr!=inp.tacNr || tis3.tacNr!=inp.tacNr) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(42);
  }
  if(!doubleMatch(tis.c[0].y[0], 6.25, 1.0E-12) || 
     !doubleMatch(tis.c[0].y[1], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[0], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[1], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[0], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[1], 700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(43);
  }


  if(verbose>1) printf("\n\n Same frame times \n");
  tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3);
  
  if(tacDuplicate(&inp, &xinp)) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(100);
  }
  xinp.isframe=inp.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolate(&inp, &xinp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(101);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=inp.tacNr || tis2.tacNr!=inp.tacNr || tis3.tacNr!=inp.tacNr) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(102);
  }
  if(!doubleMatch(tis.c[0].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[0].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis.c[0].y[2], 0.0, 1.0E-12) ||
     !doubleMatch(tis.c[0].y[3], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[0], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[2], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[0].y[3], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[0], 0.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[2], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[0].y[3], 9700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(103);
  }
  statusSet(status, __func__, __FILE__, __LINE__, 0);



  if(verbose>1) printf("\n\n Same frame times but with frame start and end\n");
  tacFree(&tis); tacFree(&tis2); tacFree(&tis3);
  xinp.isframe=1; inp.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\nxinput:\n");
    tacWrite(&xinp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolate(&inp, &xinp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(111);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=inp.tacNr || tis2.tacNr!=inp.tacNr || tis3.tacNr!=inp.tacNr) {
    tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(112);
  }
  {
    if(verbose>3) printf("\n checking results...\n");
    double corr[3][4];
    corr[0][0]=0.0; corr[1][0]=0.0; corr[2][0]=0.0; 
    corr[0][1]=50.0; corr[1][1]=50.0; corr[2][1]=0.5*corr[1][1]*1.0; 
    corr[0][2]=0.0; corr[1][2]=100.0; corr[2][2]=100.0 + 0.5*(100.0+corr[1][2])*1.0; 
    corr[0][3]=0.0; corr[1][3]=100.0; corr[2][3]=100.0 + 200.0 + 100.0*94.0;
    for(int i=0; i<4; i++) {
      if(verbose>3)  
        printf("  i=%d: -> %g %g %g (%g %g %g)\n", i,
               tis.c[0].y[i], tis2.c[0].y[i], tis3.c[0].y[i],
               corr[0][i], corr[1][i], corr[2][i]); 
      if(!doubleMatch(tis.c[0].y[i],  corr[0][i], 1.0E-06) ||
         !doubleMatch(tis2.c[0].y[i], corr[1][i], 1.0E-06) ||
         !doubleMatch(tis3.c[0].y[i], corr[2][i], 1.0E-06)) 
      {
        tacFree(&inp); tacFree(&xinp); 
        tacFree(&tis); tacFree(&tis2); tacFree(&tis3);
        return 115;
      }
    }
  }


  tacFree(&inp); tacFree(&xinp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacInterpolateInto(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int n, ret;

  if(verbose>1) printf("\n testing with NULL data \n");
  ret=tacInterpolateInto(NULL, NULL, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(1);

  TAC inp, tis; tacInit(&inp); tacInit(&tis);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=tacInterpolateInto(&inp, &tis, NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n making test data \n");
  if(create_inp1(&inp) || create_tis1(&tis)) {
    tacFree(&inp); tacFree(&tis); return(10);}

  if(verbose>1) printf("\n interpolating to middle frame times \n");
  tis.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\ntissue:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  n=tis.tacNr;
  ret=tacInterpolateInto(&inp, &tis, NULL, NULL, status);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&tis); return(11);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=n+inp.tacNr) {tacFree(&inp); tacFree(&tis); return(12);}
  if(!doubleMatch(tis.c[1].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[1].y[1], 0.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&tis); return(13);
  }

  if(verbose>1) printf("\n interpolating to frames \n");
  tis.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\ntissue:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  n=tis.tacNr;
  ret=tacInterpolateInto(&inp, &tis, NULL, NULL, status);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&tis); return(21);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=n+inp.tacNr) {tacFree(&inp); tacFree(&tis); return(22);}
  if(!doubleMatch(tis.c[2].y[0], 6.25, 1.0E-12) || 
     !doubleMatch(tis.c[2].y[1], 0.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&tis); return(23);
  }


  if(verbose>1) printf("\n integrating to middle frame times \n");
  TAC tis2, tis3; tacInit(&tis2); tacInit(&tis3);
  tis.tacNr=1;
  if(tacDuplicate(&tis, &tis2) || tacDuplicate(&tis, &tis3)) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(30);
  }
  tis.isframe=tis2.isframe=tis3.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\ntissue:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  n=tis.tacNr;
  ret=tacInterpolateInto(&inp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(31);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=n+inp.tacNr || tis2.tacNr!=n+inp.tacNr || tis3.tacNr!=n+inp.tacNr) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(32);
  }
  if(!doubleMatch(tis.c[1].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[1].y[1], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[0], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[1], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[0], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[1], 700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(33);
  }

  if(verbose>1) printf("\n interpolating to frames \n");
  tis.isframe=tis2.isframe=tis3.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\ntissue:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  n=tis.tacNr;
  ret=tacInterpolateInto(&inp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(41);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=n+inp.tacNr || tis2.tacNr!=n+inp.tacNr || tis3.tacNr!=n+inp.tacNr) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(42);
  }
  if(!doubleMatch(tis.c[2].y[0], 6.25, 1.0E-12) || 
     !doubleMatch(tis.c[2].y[1], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[2].y[0], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[2].y[1], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[2].y[0], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[2].y[1], 700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(43);
  }
  tacFree(&tis); tacFree(&tis2); tacFree(&tis3);


  if(verbose>1) printf("\n\n Same frame times \n");
  if(tacDuplicate(&inp, &tis) || tacDuplicate(&inp, &tis2) || tacDuplicate(&inp, &tis3)) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(100);
  }
  tis.isframe=tis2.isframe=tis3.isframe=0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\ntissue:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  n=tis.tacNr;
  ret=tacInterpolateInto(&inp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(101);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=n+inp.tacNr || tis2.tacNr!=n+inp.tacNr || tis3.tacNr!=n+inp.tacNr) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(102);
  }
  if(!doubleMatch(tis.c[1].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[1].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis.c[1].y[2], 0.0, 1.0E-12) ||
     !doubleMatch(tis.c[1].y[3], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[0], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[2], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[3], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[0], 0.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[2], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[3], 9700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(103);
  }


  if(verbose>1) printf("\n\n Same frame times but with frame start and end\n");
  tis.isframe=tis2.isframe=tis3.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\ntissue:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  n=tis.tacNr;
  ret=tacInterpolateInto(&inp, &tis, &tis2, &tis3, status);
  if(ret!=TPCERROR_OK) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(111);
  }
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tis, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
    printf("\n");
    tacWrite(&tis3, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tis.tacNr!=n+inp.tacNr || tis2.tacNr!=n+inp.tacNr || tis3.tacNr!=n+inp.tacNr) {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(112);
  }
  if(!doubleMatch(tis.c[1].y[0], 0.0, 1.0E-12) || 
     !doubleMatch(tis.c[1].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis.c[1].y[2], 0.0, 1.0E-12) ||
     !doubleMatch(tis.c[1].y[3], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[0], 0.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[2], 100.0, 1.0E-12) ||
     !doubleMatch(tis2.c[1].y[3], 100.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[0], 0.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[1], 50.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[2], 200.0, 1.0E-12) ||
     !doubleMatch(tis3.c[1].y[3], 9700.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&tis); tacFree(&tis2); tacFree(&tis3); 
    return(113);
  }


  tacFree(&inp); tacFree(&tis);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacInterpolateToEqualLengthFrames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with NULL data \n");
  ret=tacInterpolateToEqualLengthFrames(NULL, 0.0, 0.0, NULL, NULL);
  if(ret==TPCERROR_OK) return(1);

  TAC inp, sim; tacInit(&inp); tacInit(&sim);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=tacInterpolateToEqualLengthFrames(&inp, 0.0, 0.0, &sim, NULL);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n making test data \n");
  if(create_inp1(&inp)) {tacFree(&inp); tacFree(&sim); return(10);}

  if(verbose>1) printf("\n interpolating with default settings\n");
  inp.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolateToEqualLengthFrames(&inp, 0.0, 0.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(11);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&sim, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 2.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 192.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 194.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(12);
  }
  if(!doubleMatch(sim.c[0].y[0], 6.25, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(13);
  }

  if(verbose>1) printf("\n with frame mid times should end at 100\n");
  inp.isframe=0;
  ret=tacInterpolateToEqualLengthFrames(&inp, 0.0, 0.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(15);}
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 2.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 98.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 100.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(16);
  }
  if(!doubleMatch(sim.c[0].y[0], 6.25, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(17);
  }

  if(verbose>1) printf("\n force interval to 1\n");
  inp.isframe=1;
  ret=tacInterpolateToEqualLengthFrames(&inp, 1.0, 1.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(21);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&sim, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 1.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 193.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 194.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(22);
  }
  if(!doubleMatch(sim.c[0].y[0], 0.0, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(23);
  }
  if(!doubleMatch(sim.c[0].y[1], 12.5, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(24);
  }

  if(verbose>1) printf("\n upper limit of interval to 1\n");
  ret=tacInterpolateToEqualLengthFrames(&inp, 0.0, 1.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(31);}
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 1.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 193.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 194.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(32);
  }
  if(!doubleMatch(sim.c[0].y[0], 0.0, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(33);
  }
  if(!doubleMatch(sim.c[0].y[1], 12.5, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(34);
  }

  if(verbose>1) printf("\n lower limit of interval to 3\n");
  ret=tacInterpolateToEqualLengthFrames(&inp, 3.0, 0.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(41);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&sim, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 3.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 192.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 195.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(42);
  }
  if(!doubleMatch(sim.c[0].y[0], 50.0/3.0, 1.0E-06)) {
    tacFree(&inp); tacFree(&sim); return(43);
  }

  if(verbose>1) printf("\n too high lower limit of interval\n");
  ret=tacInterpolateToEqualLengthFrames(&inp, 1000.0, 0.0, &sim, NULL);
  if(ret==TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(51);}

  if(verbose>1) printf("\n too low upper limit of interval\n");
  ret=tacInterpolateToEqualLengthFrames(&inp, 0.0, 1.0E-10, &sim, NULL);
  if(ret==TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(52);}


  if(verbose>1) printf("\n data does not start at 0\n");
  inp.isframe=1;
  for(int i=0; i<inp.sampleNr; i++) {inp.x[i]+=5.0; inp.x1[i]+=5.0; inp.x2[i]+=5.0;}
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolateToEqualLengthFrames(&inp, 0.0, 0.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(101);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&sim, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 2.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 198.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 200.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(102);
  }
  if(!doubleMatch(sim.c[0].y[0], 0.0, 1.0E-12)) {
    tacFree(&inp); tacFree(&sim); return(103);
  }

  if(verbose>1) printf("\n more than one TAC\n");
  tacFree(&inp); if(create_inp1(&inp)) {tacFree(&inp); tacFree(&sim); return(200);}
  if(tacAllocateMore(&inp, 1)!=0) {tacFree(&inp); tacFree(&sim); return(200);}
  for(int i=0; i<inp.sampleNr; i++) inp.c[1].y[i]=2.0*inp.c[0].y[i];
  inp.tacNr=2;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&inp, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacInterpolateToEqualLengthFrames(&inp, 3.0, 0.0, &sim, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&sim); return(211);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&sim, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(!doubleMatch(sim.x1[0], 0.0, 1.0E-12) || 
     !doubleMatch(sim.x2[0], 3.0, 1.0E-12) ||
     !doubleMatch(sim.x1[sim.sampleNr-1], 192.0, 1.0E-12) ||
     !doubleMatch(sim.x2[sim.sampleNr-1], 195.0, 1.0E-12))
  {
    tacFree(&inp); tacFree(&sim); return(212);
  }
  if(!doubleMatch(sim.c[0].y[0], 50.0/3.0, 1.0E-06) ||
     !doubleMatch(sim.c[1].y[0], 2.0*50.0/3.0, 1.0E-06)) {
    tacFree(&inp); tacFree(&sim); return(213);
  }

  tacFree(&inp); tacFree(&sim);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacFramesToSteps(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with NULL data \n");
  ret=tacFramesToSteps(NULL, NULL, NULL);
  if(ret==TPCERROR_OK) return(1);

  TAC tac1, tac2; tacInit(&tac1); tacInit(&tac2);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n making test data \n");
  if(create_inp1(&tac1)) {tacFree(&tac1); tacFree(&tac2); return(10);}

  if(verbose>1) printf("\n original data has no frames\n");
  tac1.isframe=0;
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(11);}
  ret=tacCompareTimes(&tac1, &tac2, 1.0E-20, 1.0E-20, NULL);
  if(ret==0) tacCompareConc(&tac1, &tac2, -1, 1.0E-20, 1.0E-20, NULL);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(12);}

  if(verbose>1) printf("\n original data has frames\n");
  tac1.isframe=1;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&tac1, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(21);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tac2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tac2.sampleNr!=8) {tacFree(&tac1); tacFree(&tac2); return(22);}
  ret= !doubleMatch(tac2.x[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[1], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[2], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[3], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[4], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[5], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[6], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[7], 194.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[1], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[2], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[3], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[4], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[5], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[6], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[7], 0.0, 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(23);}

  if(verbose>1) printf("\n original data has small frame overlap\n");
  tac1.isframe=1;
  tac1.x2[0]=2.5; tac1.x1[1]=1.5;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&tac1, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(31);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tac2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tac2.sampleNr!=8) {tacFree(&tac1); tacFree(&tac2); return(32);}
  ret= !doubleMatch(tac2.x[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[1], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[2], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[3], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[4], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[5], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[6], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[7], 194.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[1], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[2], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[3], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[4], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[5], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[6], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[7], 0.0, 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(33);}

  if(verbose>1) printf("\n original data has large frame overlap\n");
  tac1.isframe=1;
  tac1.x1[0]=0.0; tac1.x2[0]=2.0; 
  tac1.x1[1]=2.0; tac1.x2[1]=2.1; 
  tac1.x1[2]=1.0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&tac1, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret==TPCERROR_OK && verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tac2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(41);}


  if(verbose>1) printf("\n original data has gaps\n");
  tac1.isframe=1;
  tac1.x1[0]=1.0;   tac1.x2[0]=2.0;
  tac1.x1[1]=2.0;   tac1.x2[1]=4.0;
  tac1.x1[2]=4.0;   tac1.x2[2]=6.0;
  tac1.x1[3]=190.0; tac1.x2[3]=194.0;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&tac1, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(51);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tac2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tac2.sampleNr!=9) {tacFree(&tac1); tacFree(&tac2); return(52);}
  ret= !doubleMatch(tac2.x[0], 1.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[1], 1.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[2], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[3], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[4], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[5], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[6], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[7], 190.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[8], 194.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[1], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[2], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[3], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[4], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[5], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[6], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[7], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[8], 0.0, 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(53);}


  if(verbose>1) printf("\n more than one TAC\n");
  tacFree(&tac1); if(create_inp1(&tac1)) {tacFree(&tac1); tacFree(&tac2); return(100);}
  if(tacAllocateMore(&tac1, 1)!=0) {tacFree(&tac1); tacFree(&tac2); return(100);}
  for(int i=0; i<tac1.sampleNr; i++) tac1.c[1].y[i]=2.0*tac1.c[0].y[i];
  tac1.tacNr=2;
  if(verbose>2) {
    printf("\ninput:\n");
    tacWrite(&tac1, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  ret=tacFramesToSteps(&tac1, &tac2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(101);}
  if(verbose>2) {
    printf("\noutput:\n");
    tacWrite(&tac2, stdout, TAC_FORMAT_CSV_UK, 0, NULL);
  }
  if(tac2.sampleNr!=8) {tacFree(&tac1); tacFree(&tac2); return(102);}
  ret= !doubleMatch(tac2.x[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[1], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[2], 2.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[3], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[4], 4.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[5], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[6], 6.0, 1.0E-12);
  ret+=!doubleMatch(tac2.x[7], 194.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[1], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[2], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[3], 50.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[4], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[5], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[6], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[0].y[7], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[1], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[2], 100.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[3], 100.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[4], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[5], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[6], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac2.c[1].y[7], 0.0, 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(103);}


  tacFree(&tac1); tacFree(&tac2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacDelay(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with NULL data \n");
  ret=tacDelay(NULL, 0.0, 0, NULL);
  if(ret==TPCERROR_OK) return(1);

  TAC tac1, tac2; tacInit(&tac1); tacInit(&tac2);

  if(verbose>1) printf("\n testing with empty data \n");
  ret=tacDelay(&tac1, 0.0, 0, NULL);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n making test data with frame mid times\n");
  if(create_tac(&tac1)) {tacFree(&tac1); tacFree(&tac2); return(10);}
  tac1.isframe=0;
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  tacDuplicate(&tac1, &tac2);

  if(verbose>1) printf("\n testing with stupid delay times \n");
  ret=tacDelay(&tac1, -100., -1, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(101);}
  ret=tacDelay(&tac1, +100., -1, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(102);}

  if(verbose>1) printf("\n testing with zero delay time; should not change anything \n");
  ret=tacDelay(&tac1, 0.0, -1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(111);}
  if(tacCompareConc(&tac1, &tac2, -1, 1.0E-10, 1.0E-10, NULL) ||
     tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(112);
  }

  if(verbose>1) printf("\n testing with delay time 1 \n");
  ret=tacDelay(&tac1, 1.0, -1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(121);}
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  /* times must not change */
  if(tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(122);
  }
  /* checking values */
  ret= !doubleMatch(tac1.c[0].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac1.c[1].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac1.c[2].y[0], 0.0, 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(123);}
  ret= !doubleMatch(tac1.c[0].y[1], tac2.c[0].y[0], 1.0E-12);
  ret+=!doubleMatch(tac1.c[1].y[1], tac2.c[1].y[0], 1.0E-12);
  ret+=!doubleMatch(tac1.c[2].y[1], tac2.c[2].y[0], 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(124);}

  if(verbose>1) printf("\n testing with delay time -1 \n");
  ret=tacDelay(&tac1, -1.0, -1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(125);}
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  tac1.sampleNr--; tac2.sampleNr--;
  if(tacCompareConc(&tac1, &tac2, -1, 1.0E-10, 1.0E-10, NULL) ||
     tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(126);
  }
  tac1.sampleNr++; tac2.sampleNr++;
  ret= !doubleMatch(tac1.c[0].y[tac1.sampleNr-1], tac2.c[0].y[tac2.sampleNr-2], 1.0E-12);
  ret+=!doubleMatch(tac1.c[1].y[tac1.sampleNr-1], tac2.c[1].y[tac2.sampleNr-2], 1.0E-12);
  ret+=!doubleMatch(tac1.c[2].y[tac1.sampleNr-1], tac2.c[2].y[tac2.sampleNr-2], 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(127);}

  if(verbose>1) printf("\n moving only one of TACs \n");
  tacFree(&tac1); tacDuplicate(&tac2, &tac1);
  ret=tacDelay(&tac1, 1.0, 1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(131);}
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  /* times must not change */
  if(tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(132);
  }
  /* Concentrations change only in the one TAC */
  ret=tacCompareConc(&tac1, &tac2, 0, 1.0E-10, 1.0E-10, NULL);
  ret+=tacCompareConc(&tac1, &tac2, 2, 1.0E-10, 1.0E-10, NULL);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(133);}
  if(tacCompareConc(&tac1, &tac2, 1, 1.0E-10, 1.0E-10, NULL)==0) {
    tacFree(&tac1); tacFree(&tac2); return(134);
  }


  tacFree(&tac1); tacFree(&tac2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);


  if(verbose>1) printf("\n making test data with frame start and end times\n");
  if(create_tac(&tac1)) {tacFree(&tac1); tacFree(&tac2); return(200);}
  tac1.isframe=1;
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  tacDuplicate(&tac1, &tac2);

  if(verbose>1) printf("\n testing with stupid delay times \n");
  ret=tacDelay(&tac1, -100., -1, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(201);}
  ret=tacDelay(&tac1, +100., -1, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return(202);}

  if(verbose>1) printf("\n testing with zero delay time; should not change anything \n");
  ret=tacDelay(&tac1, 0.0, -1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(111);}
  if(tacCompareConc(&tac1, &tac2, -1, 1.0E-10, 1.0E-10, NULL) ||
     tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(212);
  }

  if(verbose>1) printf("\n testing with delay time 1 \n");
  ret=tacDelay(&tac1, 1.0, -1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(221);}
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  /* times must not change */
  if(tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(222);
  }
  /* checking values */
  ret= !doubleMatch(tac1.c[0].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac1.c[1].y[0], 0.0, 1.0E-12);
  ret+=!doubleMatch(tac1.c[2].y[0], 0.0, 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(223);}
  ret= !doubleMatch(tac1.c[0].y[1], tac2.c[0].y[0], 1.0E-12);
  ret+=!doubleMatch(tac1.c[1].y[1], tac2.c[1].y[0], 1.0E-12);
  ret+=!doubleMatch(tac1.c[2].y[1], tac2.c[2].y[0], 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(224);}

  if(verbose>1) printf("\n testing with delay time -1 \n");
  ret=tacDelay(&tac1, -1.0, -1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(225);}
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  tac1.sampleNr--; tac2.sampleNr--;
  if(tacCompareConc(&tac1, &tac2, -1, 1.0E-10, 1.0E-10, NULL) ||
     tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(226);
  }
  tac1.sampleNr++; tac2.sampleNr++;
  ret= !doubleMatch(tac1.c[0].y[tac1.sampleNr-1], tac2.c[0].y[tac2.sampleNr-2], 1.0E-12);
  ret+=!doubleMatch(tac1.c[1].y[tac1.sampleNr-1], tac2.c[1].y[tac2.sampleNr-2], 1.0E-12);
  ret+=!doubleMatch(tac1.c[2].y[tac1.sampleNr-1], tac2.c[2].y[tac2.sampleNr-2], 1.0E-12);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(227);}

  if(verbose>1) printf("\n moving only one of TACs \n");
  tacFree(&tac1); tacDuplicate(&tac2, &tac1);
  ret=tacDelay(&tac1, 1.0, 1, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); return(231);}
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  /* times must not change */
  if(tacCompareTimes(&tac1, &tac2, 1.0E-10, 1.0E-10, NULL)) {
    tacFree(&tac1); tacFree(&tac2); return(232);
  }
  /* Concentrations change only in the one TAC */
  ret=tacCompareConc(&tac1, &tac2, 0, 1.0E-10, 1.0E-10, NULL);
  ret+=tacCompareConc(&tac1, &tac2, 2, 1.0E-10, 1.0E-10, NULL);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return(233);}
  if(tacCompareConc(&tac1, &tac2, 1, 1.0E-10, 1.0E-10, NULL)==0) {
    tacFree(&tac1); tacFree(&tac2); return(234);
  }

  if(verbose>1) printf("\n moving a step function changes values but AUC remains the same \n");
  tacFree(&tac2);
  for(int j=0; j<tac1.tacNr; j++) for(int i=0; i<tac1.sampleNr; i++) tac1.c[j].y[i]=0.0;
  tac1.c[0].y[1]=tac1.c[1].y[2]=tac1.c[2].y[3]=100.0;
  tac1.isframe=1;
  tacDuplicate(&tac1, &tac2);
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  ret=tacDelay(&tac1, 0.9, -1, NULL);
  if(verbose>3) tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  double auc1, auc2;
  auc1=tacAUC(&tac2, 0, 0.0, tac2.x2[tac2.sampleNr-1], NULL);
  auc2=tacAUC(&tac1, 0, 0.0, tac2.x2[tac2.sampleNr-1], NULL);
  if(verbose>3) printf("  AUC %g vs %g\n", auc1, auc2);
  if(!doubleMatch(auc1, auc2, 1.0E-10)) {tacFree(&tac1); tacFree(&tac2); return(301);}
  auc1=tacAUC(&tac2, 1, 0.0, tac2.x2[tac2.sampleNr-1], NULL);
  auc2=tacAUC(&tac1, 1, 0.0, tac2.x2[tac2.sampleNr-1], NULL);
  if(verbose>3) printf("  AUC %g vs %g\n", auc1, auc2);
  if(!doubleMatch(auc1, auc2, 1.0E-10)) {tacFree(&tac1); tacFree(&tac2); return(302);}
  auc1=tacAUC(&tac2, 2, 0.0, tac2.x2[tac2.sampleNr-1], NULL);
  auc2=tacAUC(&tac1, 2, 0.0, tac2.x2[tac2.sampleNr-1], NULL);
  if(verbose>3) printf("  AUC %g vs %g\n", auc1, auc2);
  if(!doubleMatch(auc1, auc2, 1.0E-10)) {tacFree(&tac1); tacFree(&tac2); return(303);}

  tacFree(&tac1); tacFree(&tac2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacAUC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double auc, t1, t2;

  if(verbose>1) printf("\n testing with NULL data \n");
  auc=tacAUC(NULL, 0, 0.0, 1.0, NULL);
  if(!isnan(auc)) return(1);

  TAC tac; tacInit(&tac);

  if(verbose>1) printf("\n testing with empty data \n");
  auc=tacAUC(&tac, 0, 0.0, 1.0, NULL);
  if(!isnan(auc)) return(1);

  if(verbose>1) printf("\n making test data \n");
  if(create_inp1(&tac)) {tacFree(&tac); return(10);}

  if(verbose>1) printf("\n AUC from start to end, with frame durations \n");
  tac.isframe=1; t1=tac.x1[0]; t2=tac.x2[tac.sampleNr-1];
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  auc=tacAUC(&tac, 0, t1, t2, NULL);
  if(verbose>3) printf("  AUC %g-%g := %g\n", t1, t2, auc);
  if(!doubleMatch(auc, 100.0, 1.0E-10)) {tacFree(&tac); return(101);}

  if(verbose>1) printf("\n AUC from start to end, with frame mid times \n");
  tac.isframe=0; t1=tac.x[0]; t2=tac.x[tac.sampleNr-1];
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  auc=tacAUC(&tac, 0, t1, t2, NULL);
  if(verbose>3) printf("  AUC %g-%g := %g\n", t1, t2, auc);
  if(!doubleMatch(auc, 100.0, 1.0E-10)) {tacFree(&tac); return(111);}

  if(verbose>1) printf("\n AUC from inside frame \n");
  tac.isframe=1; t1=2.5; t2=3.5;
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  auc=tacAUC(&tac, 0, t1, t2, NULL);
  if(verbose>3) printf("  AUC %g-%g := %g\n", t1, t2, auc);
  if(!doubleMatch(auc, 50.0, 1.0E-10)) {tacFree(&tac); return(121);}

  if(verbose>1) printf("\n AUC from partial data, with frame mid times \n");
  tac.isframe=0; t1=3.0; t2=5.0;
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  auc=tacAUC(&tac, 0, t1, t2, NULL);
  if(verbose>3) printf("  AUC %g-%g := %g\n", t1, t2, auc);
  if(!doubleMatch(auc, 50.0, 1.0E-10)) {tacFree(&tac); return(131);}
  tac.isframe=0; t1=4.0; t2=5.0;
  if(verbose>3) tacWrite(&tac, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  auc=tacAUC(&tac, 0, t1, t2, NULL);
  if(verbose>3) printf("  AUC %g-%g := %g\n", t1, t2, auc);
  if(!doubleMatch(auc, 12.5, 1.0E-10)) {tacFree(&tac); return(132);}

  tacFree(&tac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacVb(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\n testing with NULL data \n");
  if(tacVb(
    /** Pointer to TAC data to process. */
    NULL,
    /** Index of TAC to be processed; enter <0 to process all. */
    -1,
    /** Pointer to BTAC data to subtract or add. */
    NULL,
    /** Vb fraction [0,1]. */
    0.10,
    /** Switch to either subtract vascular volume (0) or to simulate it (1). */
    0,
    /** Switch to model vascular volume as either
      0 : Cpet = (1-Vb)*Ct + Vb*Cb, or
      1 : Cpet = Ct + Vb*Cb */
    1,
    /** Pointer to status data; enter NULL if not needed. */
    NULL)==TPCERROR_OK) {return(1);}

  TAC tac1; tacInit(&tac1);
  TAC tac2; tacInit(&tac2);
  TAC tacb; tacInit(&tacb);

  if(verbose>1) printf("\n testing with empty data \n");
  if(tacVb(&tac1, -1, &tacb, 0.10, 0, 0, NULL)==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n making test data \n");
  if(tacAllocate(&tac1, 2, 2)!=TPCERROR_OK) {return(10);}
  tac1.tacNr=2; tac1.sampleNr=2;
  if(tacAllocate(&tacb, 2, 1)!=TPCERROR_OK) {tacFree(&tac1); return(11);}
  tacb.tacNr=1; tacb.sampleNr=2;
  tac1.cunit=tacb.cunit=UNIT_KBQ_PER_ML;
  tac1.tunit=tacb.tunit=UNIT_MIN;
  tac1.isframe=tacb.isframe=1;
  for(int i=0; i<tac1.tacNr; i++) sprintf(tac1.c[i].name, "roi%d", 1+i);
  for(int i=0; i<tac1.sampleNr; i++) {
    tac1.x1[i]=tacb.x1[i]=(double)i;
    tac1.x2[i]=tacb.x2[i]=(double)(i+1);
    tac1.x[i]=tacb.x[i]=0.5*(tac1.x1[i]+tac1.x2[i]);
    for(int j=0; j<tac1.tacNr; j++)
      tac1.c[j].y[i]=100.*(double)((j+1)*(i+j));
    tacb.c[0].y[i]=10.*(double)(i+1);
  }
  if(tacDuplicate(&tac1, &tac2)!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tacb); return(12);}

  double Vb=0.10;
  if(verbose>1) printf("\n Simulate Vb as Cpet=Ct+Vb*Cb with Vb=%g\n", Vb);
  if(verbose>3) {
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacWrite(&tacb, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, -1, &tacb, Vb, 1, 1, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(101);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  for(int i=0; i<tac1.sampleNr; i++) {
    for(int j=0; j<tac1.tacNr; j++) {
      if(!doubleMatch(tac1.c[j].y[i], tac2.c[j].y[i]+Vb*tacb.c[0].y[i], 1.0E-06)) {
        tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(102);}
    }
  }

  if(verbose>1) printf("\n Correct Vb as Cpet=Ct+Vb*Cb with Vb=%g\n", Vb);
  if(tacVb(&tac1, -1, &tacb, Vb, 0, 1, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(111);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  for(int i=0; i<tac1.sampleNr; i++) {
    for(int j=0; j<tac1.tacNr; j++) {
      if(!doubleMatch(tac1.c[j].y[i], tac2.c[j].y[i], 1.0E-06)) {
        tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(112);}
    }
  }

  if(verbose>1) printf("\n Same but only for one TAC\n");
  if(tacVb(&tac1, 0, &tacb, Vb, 1, 1, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(201);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, 1, &tacb, Vb, 1, 1, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(202);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, 1, &tacb, Vb, 0, 1, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(203);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, 0, &tacb, Vb, 0, 1, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(204);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  for(int i=0; i<tac1.sampleNr; i++) {
    for(int j=0; j<tac1.tacNr; j++) {
      if(!doubleMatch(tac1.c[j].y[i], tac2.c[j].y[i], 1.0E-06)) {
        tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(205);}
    }
  }


  Vb=0.20;
  if(verbose>1) printf("\n Simulate Vb as Cpet=(1-Vb)*Ct+Vb*Cb with Vb=%g\n", Vb);
  if(verbose>3) {
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
    tacWrite(&tacb, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, -1, &tacb, Vb, 1, 0, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(301);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  for(int i=0; i<tac1.sampleNr; i++) {
    for(int j=0; j<tac1.tacNr; j++) {
      if(!doubleMatch(tac1.c[j].y[i], (1.0-Vb)*tac2.c[j].y[i]+Vb*tacb.c[0].y[i], 1.0E-06)) {
        tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(302);}
    }
  }

  if(verbose>1) printf("\n Correct Vb as Cpet=(1-Vb)*Ct+Vb*Cb with Vb=%g\n", Vb);
  if(tacVb(&tac1, -1, &tacb, Vb, 0, 0, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(311);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  for(int i=0; i<tac1.sampleNr; i++) {
    for(int j=0; j<tac1.tacNr; j++) {
      if(!doubleMatch(tac1.c[j].y[i], tac2.c[j].y[i], 1.0E-06)) {
        tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(312);}
    }
  }


  if(verbose>1) printf("\n Same but only for one TAC\n");
  if(tacVb(&tac1, 1, &tacb, Vb, 1, 0, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(401);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, 0, &tacb, Vb, 1, 0, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(402);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, 1, &tacb, Vb, 0, 0, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(403);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  if(tacVb(&tac1, 0, &tacb, Vb, 0, 0, NULL)!=TPCERROR_OK) {
    tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(404);}
  if(verbose>3) {
    printf(" -> \n");
    tacWrite(&tac1, stdout, TAC_FORMAT_TSV_UK, 0, NULL);
  }
  for(int i=0; i<tac1.sampleNr; i++) {
    for(int j=0; j<tac1.tacNr; j++) {
      if(!doubleMatch(tac1.c[j].y[i], tac2.c[j].y[i], 1.0E-06)) {
        tacFree(&tac1); tacFree(&tac2); tacFree(&tacb); return(405);}
    }
  }

  tacFree(&tac1); tacFree(&tac2); tacFree(&tacb);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
/** Create test TAC data */
int create_tac(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 5, 3); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=3; tac->sampleNr=5;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "roi%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  for(fi=0; fi<tac->sampleNr; fi++) {
    tac->x1[fi]=(double)fi; tac->x2[fi]=(double)(fi+1);
    tac->x[fi]=0.5*(tac->x1[fi]+tac->x2[fi]);
    for(ri=0; ri<tac->tacNr; ri++) {
      tac->c[ri].y[fi]=(double)((ri+1)*(fi+ri)-2);
      //printf("%d %d %g\n", fi, ri, tac->c[ri].y[fi]);
    }
  }
  /* Set header fields */
  ret=iftPut(&tac->h, "isotope", "C-11", (char)1, NULL);
  
  return TPCERROR_OK;
}
/*****************************************************************************/

/*****************************************************************************/
/** Create test input TAC data */
int create_inp1(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 4, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=4;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "inp%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=0.0; tac->x2[fi]=2.0;   tac->x[fi]=1.0;   tac->c[ri].y[fi]=0.0;
  fi=1; tac->x1[fi]=2.0; tac->x2[fi]=4.0;   tac->x[fi]=3.0;   tac->c[ri].y[fi]=50.0;
  fi=2; tac->x1[fi]=4.0; tac->x2[fi]=6.0;   tac->x[fi]=5.0;   tac->c[ri].y[fi]=0.0;
  fi=3; tac->x1[fi]=6.0; tac->x2[fi]=194.0; tac->x[fi]=100.0; tac->c[ri].y[fi]=0.0;
  return TPCERROR_OK;
}
/** Create test tissue TAC data */
int create_tis1(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 2, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=2;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "tis%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=4.0; tac->x2[fi]=6.0;   tac->x[fi]=5.0;   tac->c[ri].y[fi]=1.0;
  fi=1; tac->x1[fi]=6.0; tac->x2[fi]=14.0;  tac->x[fi]=10.0;  tac->c[ri].y[fi]=1.0;
  return TPCERROR_OK;
}
/** Create test input metab TAC data */
int create_inp2(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 4, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=4;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "met%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=0.0; tac->x2[fi]=2.0;   tac->x[fi]=1.0;   tac->c[ri].y[fi]=0.0;
  fi=1; tac->x1[fi]=2.0; tac->x2[fi]=4.0;   tac->x[fi]=3.0;   tac->c[ri].y[fi]=1.0;
  fi=2; tac->x1[fi]=4.0; tac->x2[fi]=6.0;   tac->x[fi]=5.0;   tac->c[ri].y[fi]=10.0;
  fi=3; tac->x1[fi]=6.0; tac->x2[fi]=194.0; tac->x[fi]=100.0; tac->c[ri].y[fi]=10.0;
  return TPCERROR_OK;
}
/** Create test input blood TAC data */
int create_inp3(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 4, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=4;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "blo%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  ri=0;
  fi=0; tac->x1[fi]=0.0; tac->x2[fi]=2.0;   tac->x[fi]=1.0;   tac->c[ri].y[fi]=0.0;
  fi=1; tac->x1[fi]=2.0; tac->x2[fi]=4.0;   tac->x[fi]=3.0;   tac->c[ri].y[fi]=30.0;
  fi=2; tac->x1[fi]=4.0; tac->x2[fi]=6.0;   tac->x[fi]=5.0;   tac->c[ri].y[fi]=6.0;
  fi=3; tac->x1[fi]=6.0; tac->x2[fi]=194.0; tac->x[fi]=100.0; tac->c[ri].y[fi]=6.0;
  return TPCERROR_OK;
}
/*****************************************************************************/

/*****************************************************************************/
