#!/bin/bash
#: Title      : test_lhsol
#: Date       : 2021-12-10
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../lhsol$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f plasma.dat ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f simul1.par ]; then
  rm -f tissue1.tac tissue1b.tac
  printf "# model := SER3TCM\n" > simul1.par
  printf "Parameters,K1,k2,k3,k4,k5,k6\n" >> simul1.par
  printf "tac1_k1_k1,0.05,0,0,0,0,0\n" >> simul1.par
  printf "tac2_k1_k2,0.10,0.15,0,0,0,0\n" >> simul1.par
  printf "tac3_k1_k3,0.10,0.15,0.10,0,0,0\n" >> simul1.par
  printf "tac4_k1_k4,0.20,0.15,0.10,0.02,0,0\n" >> simul1.par
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f tissue1.tac ] || [ ! -f tissue1b.tac ]; then
  rm -f framed.tac
  sim_3tcm simul1.par plasma.dat none tissue1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1.svg -l plasma.dat tissue1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

# Just add fraction of plasma because that is the assumption in application
  taccalc plasma.dat x 0.03 vp.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc tissue1.tac + vp.dat tissue1b.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1b.svg -l plasma.dat tissue1b.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f framed.tac ]; then
  simframe tissue1.tac frames.dat framed.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1f.svg -l plasma.dat framed.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi





printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: NNLS with default settings, reasonable noiseless data. \n"
printf " Test case 2: Save fitted TTACs. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output100.par output100.tac

$PROGRAM -nnls -fit=output100.tac -lp=lp100.par plasma.dat tissue1.tac 9999 output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Fitted TTACs" output100.svg -l output100.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -par=1-4 -abs=0.0001 simul1.par output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Same with simulated blood volume. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output101.par output101.tac

$PROGRAM -nnls -Vp=fitted -fit=output101.tac -lp=lp101.par plasma.dat tissue1b.tac 9999 output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Fitted TTACs" output101.svg -l output101.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -par=1-4 -abs=0.0001 simul1.par output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case 1: BVLS with default settings, reasonable noiseless data. \n"
printf " Test case 2: Save fitted TTACs. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output110.par output110.tac

$PROGRAM -bvls -fit=output110.tac -lp=lp110.par plasma.dat tissue1.tac 9999 output110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Fitted TTACs" output110.svg -l output110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -par=1-4 -abs=0.0001 simul1.par output110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: Same with simulated blood volume. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output111.par output111.tac

$PROGRAM -bvls -Vp=fitted -fit=output111.tac -lp=lp111.par plasma.dat tissue1b.tac 9999 output111.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Fitted TTACs" output111.svg -l output111.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -par=1-4 -abs=0.0001 simul1.par output111.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n 1.2.0 \n"
printf " Test case 1: Use simulated frames. \n"
printf " Test case 2: NNLS. \n"
printf " Test case 3: Use frame durations for weighting. \n"
printf " Test case 4: Save SVG. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output120.par output120.svg

$PROGRAM -nnls -wf -svg=output120.svg -lp=lp120.par plasma.dat framed.tac 9999 output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output120.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -par=1-4 -abs=0.0002 -rel=1.6 simul1.par output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Use simulated frames. \n"
printf " Test case 2: BVLS. \n"
printf " Test case 3: Use frame durations for weighting. \n"
printf " Test case 4: Save SVG. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output121.par output121.svg

$PROGRAM -bvls -wf -svg=output121.svg -lp=lp121.par plasma.dat framed.tac 9999 output121.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output121.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -par=1-4 -abs=0.0002 -rel=1.6 simul1.par output121.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

