#!/bin/bash
#: Title      : test_parmatch
#: Date       : 2014-11-28
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parmatch$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f mrglu.res ] || [ ! -f mrglu_ht.res ] || [ ! -f mrgluesd.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f mrglu_hta.res ] || [ ! -f mrglu_lt.res ] || [ ! -f mrglu_lta.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f mrglue1.res ] || [ ! -f mrglue2.res ] || [ ! -f mrglue3.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f mrgluecl1.res ] || [ ! -f mrgluecl2.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f mrglueh.res ] || [ ! -f mrgluep.res ] || [ ! -f mrgluer.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 0.1.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption mrglu.res mrglu.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 0.2.0 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglu.res extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 0.3.0 \n"
printf " Test case: Optional settings are correct by default. \n"
printf " Expected result: Test print shows correct option setting. \n\n"

rm -f stdout.txt
$PROGRAM  --debug mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt parfile1 "mrglu.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parfile2 "mrglu.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt pvals "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt sdvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt clvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt wssvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt tacnames "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parnames "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parunits "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt test_abs
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt test_rel
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"


printf "\n 0.3.1 \n"
printf " Test case: Switch all options off. \n"
printf " Expected result 1: Test print shows correct option setting. \n"
printf " Expected result 2: Fail because no tests applied. \n\n"

rm -f stdout.txt
$PROGRAM  --debug -p=n -sd=n -cl=n -tacnames=n -parnames=n -parunits=n -wss=n mrglu.res mrglu.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt pvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt sdvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt clvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt wssvals "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt tacnames "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parnames "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parunits "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"


printf "\n 0.3.2 \n"
printf " Test case: Switch all options on. \n"
printf " Expected result: Test print shows correct option setting. \n\n"

rm -f stdout.txt
$PROGRAM  --debug -p=y -sd=y -cl=y -tacnames=y -parnames=y -parunits=y -wss=y mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt pvals "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt sdvals "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt clvals "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt wssvals "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt tacnames "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parnames "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parunits "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"


printf "\n 0.4.0 \n"
printf " Test case: Option -par= \n"
printf " Expected result: Test print shows correct option setting. \n\n"

rm -f stdout.txt
$PROGRAM  --debug -par=1-3 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt plist "1, 2, 3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"


printf "\n 0.4.1 \n"
printf " Test case: Option -tac= \n"
printf " Expected result: Test print shows correct option setting. \n\n"

rm -f stdout.txt
$PROGRAM  --debug -tac=2-4 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt tlist "2, 3, 4"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"


printf "\n 0.5.0 \n"
printf " Test case: Options -abs= and -rel= \n"
printf " Expected result: Test print shows correct option setting. \n\n"

rm -f stdout.txt
$PROGRAM  --debug -abs=0.1 -rel=1 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt test_abs "0.1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt test_rel "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"



printf "\n 0.9.0 \n"
printf " Test case: Input files not given. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM  mrglu.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.9.1 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.res mrglu.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.res)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res nonexistingfile.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.res)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.0 \n"
printf " Test case: Testing file against itself. \n"
printf " Expected result: Match must be found, with any option. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -p=y -sd=y -cl=y -tacnames=y -parnames=y -parunits=y -wss=y mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1,4 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -tac=1-4 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -abs=0.01 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -rel=0.5 mrglu.res mrglu.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Different nr of parameters. \n"
printf " Expected result: Match is found with option -par=1. \n\n"

rm -f stdout.txt
$PROGRAM -par=1 mrglu.res mrglue3.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Different nr of parameters. \n"
printf " Expected result: No match is found without option -par=1. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglue3.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter names in mrglu.res and mrglue3.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: No match in parameter names. \n"
printf " Expected result: Match or No match, depending on whether tested or not. \n\n"

rm -f stdout.txt
$PROGRAM -parnames=n mrglu.res mrgluep.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -parnames=y mrglu.res mrgluep.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter names in mrglu.res and mrgluep.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: No match in region names. \n"
printf " Expected result: Match or No match, depending on whether tested or not. \n\n"

rm -f stdout.txt
$PROGRAM -tacnames=n mrglu.res mrgluer.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -tacnames=y mrglu.res mrgluer.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "TAC names in mrglu.res and mrgluer.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.4.0 \n"
printf " Test case: No match in column 1. \n"
printf " Expected result: No match, unless that col is not tested. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglue1.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglue1.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1 mrglu.res mrglue1.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglue1.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=2 mrglu.res mrglue1.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1-2 mrglu.res mrglue1.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglue1.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.5.1 \n"
printf " Test case: No match in column 2. \n"
printf " Expected result: No match, unless that col is not tested. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglue2.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglue2.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=2 mrglu.res mrglue2.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglue2.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1 mrglu.res mrglue2.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1,2 mrglu.res mrglue2.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglue2.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.5.2 \n"
printf " Test case: No match in SD in column 2. \n"
printf " Expected result: No match, unless that col or SD is not tested. \n\n"

rm -f stdout.txt
$PROGRAM -sd=y mrglu.res mrgluesd.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter SD values in mrglu.res and mrgluesd.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -sd=n mrglu.res mrgluesd.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1 -sd=y mrglu.res mrgluesd.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.5.3 \n"
printf " Test case: No match in CL1 in column 2. \n"
printf " Expected result: No match, unless that col or CL1 is not tested. \n\n"

rm -f stdout.txt
$PROGRAM -cl=y mrglu.res mrgluecl1.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter CL values in mrglu.res and mrgluecl1.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -cl=no mrglu.res mrgluecl1.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1,3 -CL=yes mrglu.res mrgluecl1.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.5.4 \n"
printf " Test case: No match in CL2 in column 3. \n"
printf " Expected result: No match, unless that col or CL2 is not tested. \n\n"

rm -f stdout.txt
$PROGRAM -Cl=Yes mrglu.res mrgluecl2.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter CL values in mrglu.res and mrgluecl2.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -CL=No mrglu.res mrgluecl2.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -par=1-2 -cl=y mrglu.res mrgluecl2.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Testing with limits \n"
printf "===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: relative difference larger than 0.011. \n"
printf " Expected result: No match, when limit not given. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglu_ht.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglu_ht.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: relative difference larger than 0.011. \n"
printf " Expected result: Still no match with option -rel=1 \n\n"

rm -f stdout.txt
$PROGRAM -rel=1 mrglu.res mrglu_ht.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglu_ht.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: relative difference larger than 0.011. \n"
printf " Expected result: Match with option -rel=3 \n\n"

rm -f stdout.txt
$PROGRAM -rel=3 mrglu.res mrglu_ht.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"

printf "\n 2.1.0 \n"
printf " Test case: relative difference smaller than 0.02. \n"
printf " Expected result: No match, when limit not given. \n\n"

rm -f stdout.txt
$PROGRAM mrglu.res mrglu_lt.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglu_lt.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: relative difference smaller than 0.02. \n"
printf " Expected result: Match with option -rel=2 \n\n"

rm -f stdout.txt
$PROGRAM -rel=2 mrglu.res mrglu_lt.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"

printf "\n 3.0.0 \n"
printf " Test case: absolute difference higher than limit given with -abs. \n"
printf " Expected result: No match. \n\n"

rm -f stdout.txt
$PROGRAM -abs=1.5 mrglu.res mrglu_lt.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter values in mrglu.res and mrglu_lt.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case: absolute difference lower than limit given with -abs. \n"
printf " Expected result: Match. \n\n"

rm -f stdout.txt
$PROGRAM -abs=2,0 mrglu.res mrglu_lt.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case 1: absolute difference in SD higher than limit given with -abs. \n"
printf " Test case 2: errors are also tested. \n"
printf " Expected result: No match. \n\n"

rm -f stdout.txt
$PROGRAM -sd=y -abs=0 mrglu.res mrgluesd.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "parameter SD values in mrglu.res and mrgluesd.res do not match."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.1.1 \n"
printf " Test case 1: absolute difference in SD higher than limit given with -abs. \n"
printf " Test case 2: errors are not tested. \n"
printf " Expected result: Match. \n\n"

rm -f stdout.txt
$PROGRAM -sd=n -abs=0 mrglu.res mrgluesd.res &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt result "match was found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

