#!/bin/bash
#: Title      : test_parmean
#: Date       : 2019-09-15
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parmean$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

#printf "\n verifying that required data exists \n"


if [ ! -f test1.csv ] || [ ! -f test1.res ] || [ ! -f test1.fit ] || [ ! -f test1.ift ]; then
  printf "parameters,K1,K1/k2,k3\n" > test1.csv
  printf "put_dx,0.5,0.9,0.025\n"   >> test1.csv
  printf "cau_dx,0.2,1.1,0\n"       >> test1.csv
  printf "put_sin,0.5,1.1,0.015\n"  >> test1.csv
  printf "cau_sin,0.3,0.9,0.01\n"   >> test1.csv
  printf "cereb,1.0,1.0,0.0\n"      >> test1.csv

  parformat -f=RES test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Means etc from test data. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: correct values calculated. \n\n"

rm -f output.csv

$PROGRAM test1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

#cat output.csv 

paradd -tac=3 -par=k3 sd.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=IFT sd.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 sd.ift k3 0.010607
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


res=$(parget output.csv K1 Mean)
if [ $res != '0.5' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv K1 Median)
if [ $res != '0.5' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv K1 Min)
if [ $res != '0.2' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv K1 Max)
if [ $res != '1' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv K1 N)
if [ $res != '5' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

res=$(parget output.csv k3 Mean)
if [ $res != '0.01' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv k3 Median)
if [ $res != '0.01' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv k3 Min)
if [ $res != '0' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv k3 Max)
if [ $res != '0.025' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
res=$(parget output.csv k3 N)
if [ $res != '5' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Means etc from test data. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: correct values calculated. \n\n"

rm -f output.res

$PROGRAM test1.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 output.csv output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Means etc from test data. \n"
printf " Test case 2: FIT format. \n"
printf " Expected result: correct values calculated. \n\n"

rm -f output.fit

$PROGRAM test1.fit output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -abs=0.001 output.csv output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: Means etc from test data. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: correct values calculated. \n\n"

rm -f output.ift

$PROGRAM test1.ift output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 output.csv output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Means etc from specified parameter. \n"
printf " Expected result: correct values saved. \n\n"

rm -f output.csv

$PROGRAM -par=K1/k2 test1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

#cat output.csv

paradd -tac=3 sd.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=IFT sd.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 sd.ift K1/k2 0.1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Means etc from specified TACs. \n"
printf " Expected result: correct values saved. \n\n"

rm -f output.csv

$PROGRAM -tac=put -par=k3 test1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

#cat output.csv

paradd -tac=3 sd.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=IFT sd.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 sd.ift k3 0.007071
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case 1: Means etc from test data. \n"
printf " Test case 2: Output file name not given. \n"
printf " Expected result: correct values printed in stdout. \n\n"

rm -f output1.csv output2.csv

$PROGRAM test1.csv output1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test1.csv > output2.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

parmatch output1.csv output2.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

