#!/bin/bash
#: Title      : test_fit2auc
#: Date       : 2021-02-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit2auc$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f s6910vp.kbq ]; then
  printf "Failed: missing test data file.\n"
  exit 1
fi

if [ ! -f s6910vp.fit ] || [ ! -f correct_s6910vp_auc0-inf.par ] || [ ! -f correct_s6910vp_auc10-inf.par ]; then
  printf "\n fit bi-exponential function to late part of venous FDG PTAC \n"
  taccut s6910vp.kbq 10 120 s6910vp_cut.kbq
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  fit_dexp -2 -w1 s6910vp_cut.kbq s6910vp.fit
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  fit2dat -a=100 s6910vp.fit s6910vp_fit.kbq
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -x1=0 -y1=0 -legend=no s6910vp.svg -s s6910vp.kbq -l s6910vp_fit.kbq
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n Save correct AUCs \n"
  printf "Parameters\tAUC[min*kBq/mL]\n" > correct_s6910vp_auc0-inf.par
  printf "tac1\t234.3086741\n" >> correct_s6910vp_auc0-inf.par

  printf "Parameters\tAUC[min*kBq/mL]\n" > correct_s6910vp_auc10-inf.par
  printf "tac1\t130.34775\n" >> correct_s6910vp_auc10-inf.par
fi


if [ ! -f test1.fit ] || [ ! -f correct_test1_auc0-inf.par ] || [ ! -f correct_test1_auc1000-inf.par ]; then
  printf "\n Make test data with exactly known results \n"
  printf "FIT1        fit_dexp 0.7.7 (c) 2021 by Turku PET Centre\n" > test1.fit
  printf "Date:	2021-02-04 20:10:04\n" >> test1.fit
  printf "Data file:	test1.bld\n" >> test1.fit
  printf "Data unit:	Bq/mL\n" >> test1.fit
  printf "Time unit:	sec\n" >> test1.fit
  printf "Nr of VOIs:	1\n" >> test1.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> test1.fit
  printf "tac1 . .	120	9600	10	0	2	0301	1000	-0.001\n" >> test1.fit

  printf "Parameters\tAUC[sec*Bq/mL]\n" > correct_test1_auc0-inf.par
  printf "tac1\t1.0E+06\n" >> correct_test1_auc0-inf.par

  printf "Parameters\tAUC[sec*Bq/mL]\n" > correct_test1_auc1000-inf.par
  printf "tac1\t367879.441171\n" >> correct_test1_auc1000-inf.par
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Actual plasma TAC, fitted with bi-exponential. \n"
printf " Expected result: close to correct AUC is obtained. \n\n"

printf "\n Start time: 0 \n"
rm -f s6910vp_auc0-inf.par
$PROGRAM s6910vp.fit 0 s6910vp_auc0-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -parnames=y -parunits=y -abs=0.01 correct_s6910vp_auc0-inf.par s6910vp_auc0-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n Start time: 10 \n"
rm -f s6910vp_auc10-inf.par
$PROGRAM s6910vp.fit 10 s6910vp_auc10-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -parnames=y -parunits=y -abs=0.01 correct_s6910vp_auc10-inf.par s6910vp_auc10-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.0 \n"
printf " Test case: parameters of mono-exponential. \n"
printf " Expected result: correct AUC is obtained from zero time. \n\n"

$PROGRAM test1.fit 0 test1_auc0-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -parnames=y -parunits=y -abs=1.0E-04 correct_test1_auc0-inf.par test1_auc0-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: parameters of mono-exponential. \n"
printf " Expected result: correct AUC is obtained from later time. \n\n"

$PROGRAM test1.fit 1000 test1_auc1000-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -parnames=y -parunits=y -abs=1 correct_test1_auc1000-inf.par test1_auc1000-inf.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: parameters in CSV PAR format. \n"
printf " Expected result: correct AUC is obtained. \n\n"

parformat -f=PAR test1.fit test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test1.csv 0 output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -parnames=y -parunits=y -abs=1 correct_test1_auc0-inf.par output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: same as before but file name extension is par. \n"
printf " Expected result: correct AUC is obtained. \n\n"

cp -f test1.csv test1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test1.par 0 output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -parnames=y -parunits=y -abs=1 correct_test1_auc0-inf.par output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

