#!/bin/bash
#: Title      : test_sifcat
#: Date       : 2016-11-24
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../sifcat$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f ub0371dy1.img.sif ] || [ ! -f ub0371dy2.img.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ub0371dy3.img.sif ] || [ ! -f correct_output.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Combine three SIFs. \n"
printf " Expected result: Correct SIF saved. \n"

rm -f output.sif

$PROGRAM output.sif ub0371dy1.img.sif ub0371dy2.img.sif ub0371dy3.img.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output.sif output.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Combine three SIFs, given in wrong order. \n"
printf " Expected result: Correct SIF saved. \n"

rm -f output.sif

$PROGRAM output.sif ub0371dy1.img.sif ub0371dy3.img.sif ub0371dy2.img.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output.sif output.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Combine three SIFs with studynr and isotope. \n"
printf " Expected result: Correct SIF saved. \n"

cp -f ub0371dy1.img.sif file1.sif
cp -f ub0371dy2.img.sif file2.sif
cp -f ub0371dy3.img.sif file3.sif
sifisot file?.sif C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f output.sif output.ift

$PROGRAM output.sif file?.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output.sif output.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taclist -ift output.sif > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift studynr file1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
