#!/bin/bash
#: Title      : test_tacweigh
#: Date       : 2019-09-11
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../tacweigh$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"

if [ ! -f weigh.sif ]; then
  printf "1/1/2000 11:12:13 3 4 1\n" >  weigh.sif
  printf "0 30    2000000 1900000\n" >> weigh.sif
  printf "30 60   2000000 1000000\n" >> weigh.sif
  printf "60 120 12000000 2000000\n" >> weigh.sif
fi

if [ ! -f weigh1.dft ] || [ ! -f weigh1.tac ]; then
  printf "DFT1                 voi1        voi2        head\n" > weigh1.dft
  printf "test001              .           .           .          \n" >> weigh1.dft
  printf "kBq/mL               .           .           .          \n" >> weigh1.dft
  printf "Times (sec)           1.000e+001  1.000e+002  1.000e+003\n" >> weigh1.dft
  printf "    0.0000   30.0000  3.000e+000  2.000e+000  1.000e+000\n" >> weigh1.dft
  printf "   30.0000   60.0000  5.000e+002  8.000e+001  3.000e+001\n" >> weigh1.dft
  printf "   60.0000  120.0000  2.000e+002  4.000e+001  5.000e+002\n" >> weigh1.dft
  tacformat -f=pmod weigh1.dft weigh1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Add weights from SIF. \n"
printf " Test case 2: List weights in TAC file. \n"
printf " Expected result 1: Correct weights are added. \n"
printf " Expected result 2: Fail if no weights. \n\n"

cp -f weigh1.dft temp1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "are there weights?\n"
$PROGRAM -list temp1.dft > stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt contains_weights no
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "add weights\n"
$PROGRAM -moderate=0 -i=C-11 temp1.dft weigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "are there weights?\n"
$PROGRAM -L temp1.dft > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt contains_weights yes
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "weights are hopefully correct\n"
taclist -ift -weights -na -nv temp1.dft head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.639326702
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.259486618
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.10118668
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Remove weights from file made above. \n"
printf " Expected result: Weights are removed. \n\n"

$PROGRAM -rm temp1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp1.dft > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weights no
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Add weights based on SIF and remove weights from file in PMOD format. \n"
printf " Expected result: Correct weights are added and removed. \n\n"

cp -f weigh1.tac temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -moderate=0 -i=C-11 temp1.tac weigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp1.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weights yes
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.639326702
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.259486618
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.10118668
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -rm temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp1.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weights no
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.3 \n"
printf " Test case: Add weights based on SIF and remove weights from file which has only frame middle times. \n"
printf " Expected result: Correct weights are added and removed. \n\n"

tacformat -f=simple -mid -hdr=y temp1.tac temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -moderate=0 -i=C-11 temp.dat weigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp.dat > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weights yes
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.639326702
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.259486618
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.10118668
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -rm temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp.dat > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weights no
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Add weights from SIF again but with moderation. \n"
printf " Expected result: Moderated weights are saved. \n\n"

$PROGRAM -moderate=10 -i=C-11 temp1.dft weigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp1.dft head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 2.0.0 \n"
printf " Test case 1: Add weights based on weighted average of TACs. \n"
printf " Test case 2: Default weights require isotope. \n"
printf " Expected result 1: Weight estimates are added. \n"
printf " Expected result 2: Error when isotope not specified. \n\n"

cp -f weigh1.dft temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f output.sif

$PROGRAM -moderate=0 temp2.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "valid isotope not specified."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -i=C-11 -moderate=0 temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp2.dft head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.902852243
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.083035076
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.014112681
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Save made-up SIF. \n"
printf " Test case 2: Making SIF requires isotope. \n"
printf " Expected result 1: SIF is created. \n"
printf " Expected result 2: Error when isotope not specified. \n\n"

cp -f weigh1.dft temp2.dft
printf "# isotope := C-11\n" >> temp2.dft
rm -f output.sif

# now isotope is in data file thus no problem that its not given as option
$PROGRAM -moderate=0 -sif=output.sif temp2.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift -weights -na -nv temp2.dft head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.902852243
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.083035076
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.014112681
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

sifisot output.sif > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt isotope C-11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

cp -f weigh1.dft temp2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

# now isotope is NOT in data file
$PROGRAM -moderate=0 -sif=output.sif temp2.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "valid isotope not specified."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case 1: Add weights based on one TAC. \n"
printf " Test case 2: Make SIF based on the selected TAC. \n"
printf " Expected result 1: Correct weights are added to TAC file. \n"
printf " Expected result 2: Correct SIF is made. \n\n"

cp -f weigh1.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f output.sif output.ift

$PROGRAM -moderate=0 -i=C-11 -sif=output.sif temp3.tac head
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp3.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.892030848
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.096401028
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.011568123
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " Test created SIF by using it to add weights. \n\n"

cp -f weigh1.tac temp3.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f output.ift


$PROGRAM -moderate=0 temp3.tac output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp3.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 2.892030848
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.096401028
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 0.011568123
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.0.0 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: Option -wf. \n"
printf " Expected result: Correct weights are added. \n\n"

# Remove decay correction for the TACs
tacdecay -i=C-11 -decay=off weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f output.ift

$PROGRAM -wf -moderate=0 temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift -weights -na -nv temp.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 0.75
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.75
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 1.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

# Decay correction for the TACs, affecting weights too
tacdecay -i=C-11 -decay=on temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift -weights -na -nv temp.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 0.769219356
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.756261545
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 1.474519099
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: SIF can be saved when isotope is given. \n"
printf " Expected result: Correct weights are added. \n\n"

cp -f weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f output.sif output.ift

$PROGRAM -wf -moderate=0 -sif=output.sif -i=C-11 temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

sifisot output.sif > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt isotope C-11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taclist -ift -weights -na -nv temp.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 0.75
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.75
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 1.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.1.0 \n"
printf " Test case 1: Add weights based on TAC frame durations. \n"
printf " Test case 2: Option -wfd. \n"
printf " Expected result 1: Isotope required. \n"
printf " Expected result 2: Correct weights are added. \n\n"

cp -f weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f output.ift

$PROGRAM -wfd -moderate=0 temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "valid isotope not specified."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -wfd -i=C-11 -moderate=0 -sif=output.sif temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift -weights -na -nv temp.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 0.769219356
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.756261545
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 1.474519099
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " Isotope can be given with SIF. \n\n"

cp -f weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f output.ift

$PROGRAM -wfd -moderate=0 temp.tac output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift -weights -na -nv temp.tac head > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[1] 0.769219356
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[2] 0.756261545
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift weight[3] 1.474519099
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 4.0.0 \n"
printf " Test case: Missing time units. \n"
printf " Expected result: Error. \n\n"

cp -f weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xset=unknown --silent temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wf temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unknown time unit."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -i=c-11 temp.tac weigh.sif
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.1 \n"
printf " Test case: Missing concentration units. \n"
printf " Expected result: Error if units needed for SIF or weights. \n\n"

cp -f weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -yset=unknown --silent temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -wf temp.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -wfd -i=C-11 temp.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -wfd -i=C-11 -sif=output.sif temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unknown calibration unit."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

# With SIF based weights calibration units are not needed
cp -f weigh1.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -yset=unknown --silent temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -i=c-11 temp.tac weigh.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

