#!/bin/bash
#: Title      : test_fit_xexp
#: Date       : 2019-10-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_xexp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f arterial3.kbq ] || [ ! -f venous3.kbq ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi

printf "\n creating data for testing \n"

if [ ! -f boxcar.dat ]; then
  rm -f boxcar_conv.dat
  printf "0\t0\n"    > boxcar.dat
  printf "1\t0\n"   >> boxcar.dat
  printf "2\t0\n"   >> boxcar.dat
  printf "10\t0\n"  >> boxcar.dat
  printf "10\t10\n" >> boxcar.dat
  printf "12\t10\n" >> boxcar.dat
  printf "15\t10\n" >> boxcar.dat
  printf "20\t10\n" >> boxcar.dat
  printf "30\t10\n" >> boxcar.dat
  printf "40\t10\n" >> boxcar.dat
  printf "50\t10\n" >> boxcar.dat
  printf "60\t10\n" >> boxcar.dat
  printf "70\t10\n" >> boxcar.dat
  printf "70\t0\n"  >> boxcar.dat
  printf "72\t0\n"  >> boxcar.dat
  printf "75\t0\n"  >> boxcar.dat
  printf "80\t0\n"  >> boxcar.dat
  printf "90\t0\n"  >> boxcar.dat
  printf "100\t0\n" >> boxcar.dat
  printf "110\t0\n" >> boxcar.dat
  printf "120\t0\n" >> boxcar.dat
  printf "130\t0\n" >> boxcar.dat
  printf "150\t0\n" >> boxcar.dat
fi
if [ ! -f boxcar_conv.dat ]; then
#  convexpf -auc=1 -i=0.1 boxcar.dat 0.1 0.3 0.04 0.06 0 0 boxcar_conv.dat
#  convexpf -auc=1 -i=0.05 boxcar.dat 0.1 0.5 0.04 0.05 0 0 boxcar_conv.dat
  convexpf -i=0.2 boxcar.dat 0.05 0.15 0.004 0.006 0 0 boxcar_conv.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Boxcar convoluted with biexponential. \n"
printf " Test case 2: AUC is constrained to correct value. \n"
printf " Expected result: response function parameters are close to correct. \n\n"

rm -f boxcar.svg output.par
$PROGRAM -amin=0.5 -amax=1.5 -a=1 -i=30 -svg=boxcar.svg boxcar.dat boxcar_conv.dat output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f boxcar.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.002 output.ift a1 0.050
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.02 output.ift b1 0.15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0002 output.ift a2 0.0040
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00002 output.ift b2 0.00600
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Same as before. \n"
printf " Test case 2: AUC is fitted. \n"
printf " Expected result: response function parameters are close to correct. \n\n"

rm -f boxcar2.svg output2.par
$PROGRAM -amin=0.5 -amax=1.5 -i=30 -svg=boxcar2.svg boxcar.dat boxcar_conv.dat output2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f boxcar2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.005 output2.ift a1 0.050
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.02 output2.ift b1 0.15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0004 output2.ift a2 0.0040
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0010 output2.ift b2 0.0060
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case: Test with real arterial and venous curves. \n"
printf " Note: fit can be bad, because delay is not considered, and \n"
printf "       interval is long to make fitting faster. \n"
printf " Expected result: No error. \n\n"

rm -f av.svg av.par
$PROGRAM -amin=0.5 -amax=1.0 -i=30 -svg=av.svg arterial3.kbq venous3.kbq av.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f av.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f av.par ]; then printf "Failed!\n" ; exit 1 ; fi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

