#!/bin/bash
#: Title      : test_fit_xsur
#: Date       : 2019-02-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_xsur$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"
#if [ ! -f arterial3.kbq ] || [ ! -f venous3.kbq ]; then
#  printf "Failed: required test data do not exist.\n"
#  exit 1
#fi

printf "\n creating data for testing \n"

if [ ! -f boxcar.dat ]; then
  rm -f boxcar_conv.dat
  printf "0\t0\n"    > boxcar.dat
  printf "1\t0\n"   >> boxcar.dat
  printf "2\t0\n"   >> boxcar.dat
  printf "10\t0\n"  >> boxcar.dat
  printf "10\t10\n" >> boxcar.dat
  printf "20\t10\n" >> boxcar.dat
  printf "30\t10\n" >> boxcar.dat
  printf "40\t10\n" >> boxcar.dat
  printf "50\t10\n" >> boxcar.dat
  printf "60\t10\n" >> boxcar.dat
  printf "70\t10\n" >> boxcar.dat
  printf "70\t0\n"  >> boxcar.dat
  printf "80\t0\n"  >> boxcar.dat
  printf "90\t0\n"  >> boxcar.dat
  printf "100\t0\n" >> boxcar.dat
  printf "110\t0\n" >> boxcar.dat
  printf "120\t0\n" >> boxcar.dat
  printf "130\t0\n" >> boxcar.dat
  printf "150\t0\n" >> boxcar.dat
fi
if [ ! -f boxcar_conv.dat ]; then
  convsurg -auc=1 -i=0.1 boxcar.dat 1 0.15 boxcar_conv.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Boxcar convoluted with surge. \n"
printf " Expected result: response function parameters are close to correct. \n\n"

rm -f boxcar.svg output.par
$PROGRAM -amax=1.1 -i=20 -svg=boxcar.svg boxcar.dat boxcar_conv.dat output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f boxcar.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift a 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift a 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift b 0.15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

