#!/bin/bash
#: Title      : test_tacpeak
#: Date       : 2019-09-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../tacpeak$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f test.dft ] || [ ! -f test2.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_test1a.res ] || [ ! -f correct_test2b.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f radiowater.fit ] || [ ! -f radiowater.bld ] || [ ! -f radiowater.svg ]; then
  rm -f radiowater.tac
  printf "\n creating radiowater.fit\n"
  printf "FIT1\tfit_winp 0.2.0  (c) 2010 by Turku PET Centre\n" > radiowater.fit
  printf "Date:\t2010-09-19 19:19:34\n" >> radiowater.fit
  printf "Data file:\tradiowater.bld\n" >> radiowater.fit
  printf "Data unit:\tkBq/mL\n" >> radiowater.fit
  printf "Time unit:\tsec\n" >> radiowater.fit
  printf "Nr of VOIs:\t9\n" >> radiowater.fit
  printf "Region\tStart\tEnd\tdataNr\tWSS\tparNr\tType\tParameters\n"         >> radiowater.fit
  printf "Blood1\t0.0\t360\t360\t0\t6\t0331\t0.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood2\t0.0\t360\t360\t0\t6\t0331\t1.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood3\t0.0\t360\t360\t0\t6\t0331\t2.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood4\t0.0\t360\t360\t0\t6\t0331\t3.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood5\t0.0\t360\t360\t0\t6\t0331\t4.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood6\t0.0\t360\t360\t0\t6\t0331\t5.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood7\t0.0\t360\t360\t0\t6\t0331\t6.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood8\t0.0\t360\t360\t0\t6\t0331\t7.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood9\t0.0\t360\t360\t0\t6\t0331\t8.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit

  printf "\n calculating radiowater.bld\n"
  fit2dat -c=0,61,0.1 radiowater.fit radiowater.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -mt="" radiowater.svg -l radiowater.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f radiowater.sif ] || [ ! -f radiowater.tac ] || [ ! -f radiowaterf.svg ]; then
  printf "\n creating radiowater.sif\n"
  printf "26/5/2018 13:54:01 12 2 1  \n" > radiowater.sif
  printf "0 5\n"   >> radiowater.sif
  printf "5 10\n"  >> radiowater.sif
  printf "10 15\n" >> radiowater.sif
  printf "15 20\n" >> radiowater.sif
  printf "20 25\n" >> radiowater.sif
  printf "25 30\n" >> radiowater.sif
  printf "30 35\n" >> radiowater.sif
  printf "35 40\n" >> radiowater.sif
  printf "40 45\n" >> radiowater.sif
  printf "45 50\n" >> radiowater.sif
  printf "50 55\n" >> radiowater.sif
  printf "55 60\n" >> radiowater.sif

  simframe radiowater.bld radiowater.sif radiowater.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -mt="" radiowaterf.svg -l radiowater.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f peak.tac ] || [ ! -f peak.dat ] || [ ! -f correct_peak1.par ] || [ ! -f correct_peak2.par ]; then
  printf "\n creating peak.tac \n"
  printf "start[minutes]	end[kBq/cc]	Aorta\n" > peak.tac
  printf "0.0	1.0	100.0\n" >> peak.tac
  printf "1.0	2.0	80.0\n" >> peak.tac
  printf "2.0	3.0	60.0\n" >> peak.tac
  printf "3.0	4.0	40.0\n" >> peak.tac
  printf "4.0	5.0	20.0\n" >> peak.tac
  printf "5.0	10.0	10.0\n" >> peak.tac
  printf "10.0	60.0	10.0\n" >> peak.tac

  printf "Parameters	Peak	PeakT\n" > correct_peak1.par
  printf "Aorta	85.8333	0.5\n" >> correct_peak1.par

  printf "\n making peak.dat \n"
  tacformat -mid -f=SIMPLE peak.tac peak.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "Parameters	Peak	PeakT\n" > correct_peak2.par
  printf "Aorta	83.7681	0.5\n" >> correct_peak2.par

fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Reasonable data, no options. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output.res

$PROGRAM -d10 test.dft output.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 correct_test1a.res output.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.0.1 \n"
printf " Test case: Blended data, no options. \n"
printf " Expected result: Same correct output file. \n\n"

tacblend blended.dft test.dft test.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.res

$PROGRAM blended.dft output.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 correct_test1a.res output.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.0.2 \n"
printf " Test case: Blended data, no options. \n"
printf " Expected result: Same correct output file. \n\n"

taccalc test.dft - 1.0 temp1.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
taccalc test.dft + 1.0 temp2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacblend blended.dft temp1.dft temp2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.res

$PROGRAM blended.dft output.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 correct_test1a.res output.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.0 \n"
printf " Test case: Reasonable data, option decr. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output2.res

$PROGRAM -decr=50 test2.dft output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 -rel=0.1 correct_test2b.res output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.1.1 \n"
printf " Test case: Blended data, option decr. \n"
printf " Expected result: Correct output file. \n\n"

tacblend blended.dft test2.dft test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output2.res

$PROGRAM -decr=50 blended.dft output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 -rel=0.1 correct_test2b.res output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.1.2 \n"
printf " Test case: Blended data, option decr. \n"
printf " Expected result: Correct output file. \n\n"

taccalc test2.dft - 1.0 temp1.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
taccalc test2.dft + 1.0 temp2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacblend blended.dft temp1.dft temp2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output2.res

$PROGRAM -decr=50 blended.dft output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 -rel=0.1 correct_test2b.res output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n\n 2.0.0 \n"
printf " Test case 1: Simulated TACs with framing effect. \n"
printf " Test case 2: No options. \n"
printf " Expected result 1: Correct TAC peaks are found, \n"
printf " Expected result 2: but frames affect the TACs. \n\n"

$PROGRAM radiowater.bld output1.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM radiowater.tac output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1 -abs=50 output1.res output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=2 -abs=2.5 output1.res output2.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 2.0.1 \n"
printf " Test case 1: Simulated TACs with framing effect. \n"
printf " Test case 2: Option -wt. \n"
printf " Expected result 1: Option does not affect peak values. \n"
printf " Expected result 2: Peak times are slightly less biased. \n\n"

$PROGRAM -wt radiowater.tac output3.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=1 -abs=0 output2.res output3.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=2 -abs=1.70 output1.res output3.res
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"

printf "\n\n 3.0.0 \n"
printf " Test case 1: Option -swa. \n"
printf " Test case 2: TAC with frame lengths. \n"
printf " Expected result: Correct TAC peaks are found and subtracted peak value reported. \n\n"

$PROGRAM -swa peak.tac output.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 correct_peak1.par output.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 3.0.1 \n"
printf " Test case 1: Option -swa. \n"
printf " Test case 2: TAC without frame lengths. \n"
printf " Expected result: Correct TAC peaks are found and subtracted peak value reported. \n\n"

$PROGRAM -swa peak.dat output.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 correct_peak2.par output.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
