#!/bin/bash
#: Title      : test_interpol
#: Date       : 2019-08-19
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../interpol$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f correct_output1.dft ] || [ ! -f correct_output11.dft ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f correct_output1i.dft ] || [ ! -f correct_output2.dft ] || [ ! -f correct_output2i.dft ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f correct_output3.dft ] || [ ! -f correct_output3i.dft ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f correct_output4.dft ] || [ ! -f correct_output4i.dft ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f input1.dat ] || [ ! -f input2.dat ] || [ ! -f input3.dat ] || [ ! -f input4.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f t01.dat ] || [ ! -f t01fra01.dat ] || [ ! -f t01fra02.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f t01out01.dat ] || [ ! -f t01out02.dat ] || [ ! -f t01out03.dat ] || [ ! -f t01out04.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f t02.dat ] || [ ! -f t02out01.dat ] || [ ! -f t02out02.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f t03.dat ] || [ ! -f t03out01.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f t04.dat ] || [ ! -f t04out01.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi



printf "\n creating data for testing \n"

if [ ! -f step.tac ]; then
  printf "time[seconds]\tstep[Bq/cc]\n"  > step.tac
  printf "0.0\t0.0\n"  >> step.tac
  printf "10.0\t0.0\n"  >> step.tac
  printf "10.0\t100000.0\n"  >> step.tac
  printf "40.0\t100000.0\n"  >> step.tac
  printf "40.0\t0.0\n"  >> step.tac
  printf "600.0\t0.0\n"  >> step.tac
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n\n"

rm -f output.dat
$PROGRAM -d -x=-11,-9.5,-1,-0,0,0.0001,0.0002,20,21,22,30,35,1e8 t01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t01out01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n 1.1.0 \n\n"

rm -f output.dat
$PROGRAM -d -i -x=-11,-9.5,-1,-0,0,0.0001,0.0002,20,21,22,30,35,1e8 t01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t01out02.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 1.2.0 \n\n"

rm -f output.dat
$PROGRAM -d -ii -x=-11,-9.5,-1,-0,0,0.0001,0.0002,20,21,22,30,35,1e8 t01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t01out03.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 2.0.0 \n\n"

rm -f output.dat
$PROGRAM -d -f=t01fra02.dat t01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t01out04.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 3.0.0 \n\n"

rm -f output.dat
$PROGRAM -d -c=0,3,0.5 t02.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t02out01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 3.1.0 \n\n"

rm -f output.dat
$PROGRAM -d -i -c=0,3,0.5 t02.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t02out02.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.1.1  PMOD BLD format with units \n\n"

rm -f output.tac output1.tac output2.tac
$PROGRAM -c=0,180,1 step.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -x=n -y=n -w=n -tacnames=y -xunit=y -yunit=y output.tac step.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -i -x=160 step.tac output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
$PROGRAM -i -x=160 output.tac output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -rel=0.1 -x=y -y=y -w=y -tacnames=y -xunit=y -yunit=y output1.tac output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n 4.0.0 \n\n"

rm -f output.dat
$PROGRAM -d -f=t01fra01.dat t03.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t03out01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 5.0.0 option -a \n\n"

rm -f output.dat
$PROGRAM -d -y -x=7.5 -a=5 t04.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 t04out01.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 5.1.0 extrapolation in start \n\n"

rm -f output.dft
$PROGRAM -d -y -f=correct_output1.dft input1.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output1.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 5.1.1 same but integral \n\n"

rm -f output.dft
$PROGRAM -d -i -f=correct_output1.dft input1.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output1i.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 5.2.0 extrapolation in start \n\n"

rm -f output.dft
$PROGRAM -d -f=correct_output2.dft input2.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output2.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 5.2.1 same but integral \n\n"

rm -f output.dft
$PROGRAM -d -i -f=correct_output2.dft input2.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output2i.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 5.3.0 extrapolation in start \n\n"

rm -f output.dft
$PROGRAM -d -f=correct_output3.dft input3.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output3.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 5.3.1 same but integral \n\n"

rm -f output.dft
$PROGRAM -d -i -f=correct_output3.dft input3.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output3i.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 5.4.0 peak inside frame \n\n"

rm -f output.dft
$PROGRAM -d -f=correct_output4.dft input4.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output4.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 5.4.1 same but integral \n\n"

rm -f output.dft
$PROGRAM -d -i -f=correct_output4.dft input4.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output4i.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"




printf "\n 6.0.0 option -0 \n\n"

rm -f output.dft
$PROGRAM -d -0=10 -f=correct_output11.dft t02.dat output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output11.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 6.0.1 -0=F \n\n"

rm -f output2.dft
$PROGRAM -d -0=F -f=correct_output11.dft t02.dat output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.002 -rel=0.05 correct_output11.dft output2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
