#!/bin/bash
#: Title      : test_tac4frpl
#: Date       : 2018-03-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tac4frpl$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f data1.tac ]; then
  printf "start[seconds]	end[bq/cc]	Nakki	Makara	Aladobi\n" > data1.tac
  printf "0.0	60.0	4.0	3.0	2.0\n" >> data1.tac
  printf "60.0	180.0	3.0	2.0	1.0\n" >> data1.tac
  printf "180.0	420.0	9.0	1.0	7.0\n" >> data1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct1.tac ]; then
  printf "time[seconds]	Nakki[Bq/cc]	Makara	Aladobi\n" > correct1.tac
  printf "0.0	0.0e+00	0.0e+00	0.0e+00\n" >> correct1.tac
  printf "0.0	4.0e+00	3.0e+00	2.0e+00\n" >> correct1.tac
  printf "60.0	4.0e+00	3.0e+00	2.0e+00\n" >> correct1.tac
  printf "60.0	0.0e+00	0.0e+00	0.0e+00\n" >> correct1.tac
  printf "60.0	0.0e+00	0.0e+00	0.0e+00\n" >> correct1.tac
  printf "60.0	3.0e+00	2.0e+00	1.0e+00\n" >> correct1.tac
  printf "180.0	3.0e+00	2.0e+00	1.0e+00\n" >> correct1.tac
  printf "180.0	0.0e+00	0.0e+00	0.0e+00\n" >> correct1.tac
  printf "180.0	0.0e+00	0.0e+00	0.0e+00\n" >> correct1.tac
  printf "180.0	9.0e+00	1.0e+00	7.0e+00\n" >> correct1.tac
  printf "420.0	9.0e+00	1.0e+00	7.0e+00\n" >> correct1.tac
  printf "420.0	0.0e+00	0.0e+00	0.0e+00\n" >> correct1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


if [ ! -f data2.tac ]; then
  printf "start[seconds]	end[bq/cc]	Makara\n" > data2.tac
  printf "6.0	66.0	3.0\n" >> data2.tac
  printf "60.0	180.0	2.0\n" >> data2.tac
  printf "360.0	420.0	1.0\n" >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct2.tac ]; then
  printf "time[seconds]	Makara[Bq/cc]\n" > correct2.tac
  printf "6.0	0.0e+00\n" >> correct2.tac
  printf "6.0	3.0e+00\n" >> correct2.tac
  printf "66.0	3.0e+00\n" >> correct2.tac
  printf "66.0	0.0e+00\n" >> correct2.tac
  printf "60.0	0.0e+00\n" >> correct2.tac
  printf "60.0	2.0e+00\n" >> correct2.tac
  printf "180.0	2.0e+00\n" >> correct2.tac
  printf "180.0	0.0e+00\n" >> correct2.tac
  printf "360.0	0.0e+00\n" >> correct2.tac
  printf "360.0	1.0e+00\n" >> correct2.tac
  printf "420.0	1.0e+00\n" >> correct2.tac
  printf "420.0	0.0e+00\n" >> correct2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: File with several TACs. \n"
printf " Expected result: Result file contents are correct. \n"

rm -f output1.tac

$PROGRAM data1.tac output1.tac 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output1.svg -l output1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.001 correct1.tac output1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: File with overlapping frame and frame gap. \n"
printf " Expected result: Result file contents are correct. \n"

rm -f output2.tac

$PROGRAM data2.tac output2.tac 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output2.svg -l output2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.001 correct2.tac output2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Trying to process the output file. \n"
printf " Expected result: Error about missing frame start and end times. \n"

rm -f stdout.txt

$PROGRAM output2.tac output3.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "file does not contain frame start and end times."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
