#!/bin/bash
#: Title      : test_taccross
#: Date       : 2014-10-14
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../taccross$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f data_up.dat ]; then
  rm -f temp.dat
  printf "0 0\n100 100\n" > temp.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  interpol -c=20,80,5 temp.dat data_up.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data_down.dat ]; then
  rm -f temp.dat
  printf "0 100\n100 0\n" > temp.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  interpol -c=20,80,5 temp.dat data_down.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data_steady.dat ]; then
  rm -f temp.dat
  printf "0 40\n100 40\n" > temp.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  interpol -c=6,90,4 temp.dat data_steady.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data_steady2.dat ]; then
  rm -f temp.dat
  printf "0 10\n100 10\n" > temp.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  interpol -c=6,100,8 temp.dat data_steady2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data_noisy1.dat ] || [ ! -f data_noisy2.dat ]; then

  rm -f temp.dat
  printf " 0 0\n 10 10\n 20 0\n 30 10\n 100 10\n" > temp.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  interpol -c=0,100,1 temp.dat data_noisy1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

  rm -f temp.dat
  printf " 0 10\n 10 0\n 20 10\n 30 10\n 100 5\n" > temp.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  interpol -c=0,100,1 temp.dat data_noisy2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Crossing lines. \n"
printf " Expected result: Crossing at 50. \n"

rm -f stdout.txt

$PROGRAM -ift data_up.dat data_down.dat 3 &> stdout.txt 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "x" "50"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Lines that do not cross. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt

$PROGRAM data_steady.dat data_steady2.dat 3 &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot determine cross-over time."
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Another set of crossing lines. \n"
printf " Expected result: Crossing at 60. \n"

rm -f stdout.txt

$PROGRAM -ift data_steady.dat data_down.dat 2 &> stdout.txt 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "x" "60"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Lines cross but too high consecuency nr. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt

$PROGRAM data_steady.dat data_down.dat 6 &> stdout.txt 
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot determine cross-over time."
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"



printf "\n 1.2.0 \n"
printf " Test case: Noisy data with long enough consec nr. \n"
printf " Expected result: Crossing at 30. \n"

rm -f stdout.txt

$PROGRAM -ift data_noisy1.dat data_noisy2.dat 30 &> stdout.txt 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "x" "30"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
