#!/bin/bash
#: Title      : test_tacnames
#: Date       : 2019-11-08
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacnames$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f normal1.tac ]; then
  printf "time[minutes]\tMyo[kBq/mL]\tLVCav\n0.5\t50\t100\n" > normal1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f normal2.tac ]; then
  printf "time[minutes]\tmyo[kBq/mL]\tlvcav\n0.5\t40\t110\n" > normal2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f missing1.tac ]; then
  printf "time[minutes]\tmyo[kBq/mL]\t\n1.0\t60\t90\n" > missing1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f missing2.tac ]; then
  printf "time[minutes]\t\t\n1.0\t30\t50\n" > missing2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f longname.tac ]; then
  printf "time[minutes]\tBladder[kBq/mL]\tVena cava\tLV_cavity\n0.5\t40\t110\t220\n" > longname.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case 1: Files do not have any missing names. \n"
printf " Expected result: Correct output. \n\n"

rm -f stdout.txt

$PROGRAM normal?.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat stdout.txt
iftren stdout.txt "" "key1"
iftren stdout.txt "" "key2"
iftren stdout.txt "" "key3"
iftren stdout.txt "" "key4"
iftren stdout.txt "" "key5"
iftren stdout.txt "" "key6"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key1" "Myo"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key2" "normal1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key3" "normal2.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key4" "LVCav"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key5" "normal1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key6" "normal2.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.0.1 \n"
printf " Test case 1: Files do not have any missing names. \n"
printf " Test case 2: Option -errorifmissing. \n"
printf " Expected result: No error. \n\n"

$PROGRAM -errorifmissing normal?.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.0 \n"
printf " Test case 1: Files have missing names. \n"
printf " Test case 2: Option -errorifmissing. \n"
printf " Expected result: Error, but correct output listed. \n\n"

rm -f stdout.txt

$PROGRAM -errorifmissing missing?.tac > stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat stdout.txt

iftren stdout.txt "" "key1"
iftren stdout.txt "" "key2"
iftren stdout.txt "" "key3"
iftren stdout.txt "" "key4"
iftren stdout.txt "" "key5"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key1" "Myo"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key2" "missing1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key3" "Missing TAC name"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key4" "missing1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key5" "missing2.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.1 \n"
printf " Test case 1: Some files have missing names. \n"
printf " Test case 2: Option -errorifmissing. \n"
printf " Expected result: Error, but correct output listed. \n\n"

rm -f stdout.txt

$PROGRAM -errorifmissing normal?.tac missing?.tac > stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat stdout.txt

iftren stdout.txt "" "key1"
iftren stdout.txt "" "key2"
iftren stdout.txt "" "key3"
iftren stdout.txt "" "key4"
iftren stdout.txt "" "key5"
iftren stdout.txt "" "key6"
iftren stdout.txt "" "key7"
iftren stdout.txt "" "key8"
iftren stdout.txt "" "key9"
iftren stdout.txt "" "key10"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key1" "Myo"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key2" "normal1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key3" "normal2.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key4" "missing1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key5" "LVCav"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key6" "normal1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key7" "normal2.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key8" "Missing TAC name"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key9" "missing1.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key10" "missing2.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.2.0 \n"
printf " Test case: Checking if one file has missing names. \n"
printf " Expected result: Error or no error depending on whether missing names or not. \n\n"

$PROGRAM -errorifmissing normal2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -errorifmissing missing1.tac
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -errorifmissing missing2.tac
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.3.0 \n"
printf " Test case: File contains long names but not too long. \n"
printf " Expected result: Correctly listed. \n\n"

rm -f stdout.txt

$PROGRAM longname.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftren stdout.txt "" "key1"
iftren stdout.txt "" "key2"
iftren stdout.txt "" "key3"
iftren stdout.txt "" "key4"
iftren stdout.txt "" "key5"
iftren stdout.txt "" "key6"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key1" "Bladder"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key2" "longname.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key3" "Vena cava"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key4" "longname.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "key5" "LV_cavity"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval stdout.txt "key6" "longname.tac"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
