#!/bin/bash
#: Title      : test_tacren
#: Date       : 2019-08-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../tacren$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f data.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f test1.tac ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f test2.tac ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f test3.tac ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 Rename plane of all TACs in DFT file\n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM -add=3 temp.dft 0 @_@_Newpl
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1__Newpl"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "voi2__Newpl"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head__Newpl"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 Rename plane of all TACs in PMOD file\n\n"

rm -f temp.tac temp.ift
cp -f test1.tac temp.tac
$PROGRAM -add=3 temp.tac 0 @_@_Newpl
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one__Newpl"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "two__Newpl"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three__Newpl"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 2.0.0 Rename a certain TAC, selected by its number, in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM temp.dft 2 ROI2 sin Pl061
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "ROI2_sin_Pl061"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 Rename a certain TAC, selected by its number, in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test2.tac temp.tac
$PROGRAM temp.tac 2 ROI2 sin Pl061
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one_dx"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "ROI2_sin_Pl061"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three_dx"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n 2.1.0 Rename a certain TAC, selected by its name, in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM temp.dft voi2 ROI2 sin Pl061
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "ROI2_sin_Pl061"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 Rename a certain TAC, selected by its name, in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test2.tac temp.tac
$PROGRAM temp.tac two_dx ROI2 sin Pl061
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one_dx"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "ROI2_sin_Pl061"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three_dx"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 3.0.0 Rename 2nd and 3rd field but leave the 1st, in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM temp.dft voi2 @_sin_Pl061
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "voi2_sin_Pl061"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 Rename 2nd and 3rd field but leave the 1st, in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test3.tac temp.tac
$PROGRAM temp.tac two_dx_low @_sin_Pl061
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "two_sin_Pl061"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"

printf "\n 3.1.0 Leave 1st field and remove other fields in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM temp.dft 0 @_dx_all
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.dft voi2 @
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1_dx_all"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "voi2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head_dx_all"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.1 Leave 1st field and remove other fields in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test3.tac temp.tac
$PROGRAM temp.tac 2 @
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "two"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n 3.2.0 Rename 1st field and remove other fields in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM temp.dft 0 @_dx_all
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.dft voi2 Kakka
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1_dx_all"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "Kakka"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head_dx_all"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.1 Rename 1st field and remove other fields in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test3.tac temp.tac
$PROGRAM temp.tac 2 Kakka
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "Kakka"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 4.0.0 Set sequential 3rd name field in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM -add=3 temp.dft 0 @_@_#
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "voi1__1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "voi2__2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "head__3"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.1 Set sequential 3rd name field in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test3.tac temp.tac
$PROGRAM temp.tac 0 @_@_#
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "one_dx_1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "two_dx_2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "three_dx_3"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 4.1.0 Add TAC nr as the first field in DFT file \n\n"

rm -f temp.dft temp.ift
cp -f data.dft temp.dft
$PROGRAM -add=1 temp.dft 0 tac#_@_@_@
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift temp.dft > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "tac1_voi1"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "tac2_voi2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "tac3_head"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.1 Add TAC nr as the first field in PMOD file \n\n"

rm -f temp.tac temp.ift
cp -f test3.tac temp.tac
$PROGRAM -add=1 temp.tac 0 tac#_@_@_@
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift temp.tac > temp.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval temp.ift tacname[1] "tac1_one_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[2] "tac2_two_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
iftisval temp.ift tacname[3] "tac3_three_dx_low"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
