#!/bin/bash
#: Title      : test_tacsety
#: Date       : 2014-12-11
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacsety$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Create TAC file. \n"
printf " Expected result: TAC file as created with correct contents. \n"

rm -f test1.tac test1.ift
$PROGRAM test1.tac 3 4 9.8 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift test1.tac > test1.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.ift fileformat PMOD
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.ift tacNr 3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test1.ift sampleNr 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test1.ift value[1][1] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test1.ift value[3][4] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test1.ift value[2][2] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case: Set certain y value to 0. \n"
printf " Expected result: TAC file as saved with correct contents. \n"

cp -f test1.tac test2.tac
rm -f test2.ift
$PROGRAM test2.tac 2 3 0 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift test2.tac > test2.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.ift fileformat PMOD
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.ift tacNr 3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test2.ift sampleNr 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test2.ift value[1][1] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test2.ift value[3][4] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test2.ift value[2][3] 0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Set certain y value to NaN. \n"
printf " Expected result: TAC file as saved with correct contents. \n"

cp -f test2.tac test3.tac
rm -f test3.ift
$PROGRAM test3.tac 2 3 nan 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift test3.tac > test3.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test3.ift value[1][1] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test3.ift value[3][4] 9.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval test3.ift value[2][3] "nan"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Set all y values to 3.21 \n"
printf " Expected result: TAC file as saved with correct contents. \n"

cp -f test3.tac test4.tac
rm -f test4.ift
$PROGRAM test4.tac 0 0 3,21 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift test4.tac > test4.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test4.ift value[1][1] 3.21
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test4.ift value[3][4] 3.21
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 test4.ift value[2][3] 3.21
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
