#!/bin/bash
#: Title      : test_tacsort
#: Date       : 2016-09-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacsort$EXT;

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile.tac
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.1\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM
printf "passed.\n\n"

printf "\n-------------------------------------------------------------------\n"
printf "\n1.0.0\n"
printf "DFT file is sorted by region names\n"

cp -f tacsort1.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -d test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
tacmatch -xunit=y -yunit=y test.dft tacsort1_sorted.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n-------------------------------------------------------------------\n"
printf "\n2.0.0\n"
printf "DFT file is sorted by TAC AUCs\n"

cp -f tacsort1.dft test2.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -sort=auc test2.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
tacmatch -xunit=y -yunit=y test2.dft tacsort2_sorted.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n-------------------------------------------------------------------\n"
printf "\n3.0.0\n"
printf "Sample times are sorted from typical catenated TAC\n"

cp -f tacsort2.rat test2.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
$PROGRAM -d -sort=time test2.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"
tacmatch -xunit=y -yunit=y test2.rat tacsort2_sorted.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
