#!/bin/bash
#: Title      : test_fitmbf
#: Date       : 2017-11-24
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fitmbf$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f blood.bld ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi






printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Fit TAC simulated with realistic range of parameters. \n"
printf " Test case 2: LV cavity BTAC is assumed errorless. \n"
printf " Expected result: Results are close to correct. \n\n"

rm -f temp.tac output.res output.ift
sim_mbf blood.bld 1.2 0.6 0.25 1.0 temp.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -beta=1.0 temp.tac lvcav none output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.res output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "ptMBF" 1.2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "PTF" 0.6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "Va" 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "rMBF" 0.72
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Fit TAC simulated with realistic range of parameters. \n"
printf " Test case 2: Using whole muscle and LV cavity TAC with beta 0.8. \n"
printf " Test case 3: Estimated arterial BTAC is saved and correct. \n"
printf " Expected result: Results are close to correct. \n\n"

rm -f temp.tac output.res output.ift output_ca.tac
sim_mbf blood.bld 1.2 0.6 0.25 0.8 temp.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d -beta=0.8 -input=output_ca.tac temp.tac lvcav muscle output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output.res output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift "beta" 0.8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "ptMBF" 1.2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "PTF" 0.6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "Va" 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift "rMBF" 0.72
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.1 -rel=0.1 blood.bld output_ca.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.0.2 \n"
printf " Test case 1: Fit TAC simulated with realistic range of parameters. \n"
printf " Test case 2: Using whole muscle, smaller muscle, and LV cavity TAC with beta 0.8. \n"
printf " Test case 3: Save fitted TACs. \n"
printf " Expected result: Results are close to correct. \n\n"

rm -f temp2.tac output2.res output2.ift output_fit.tac
sim_mbf blood.bld 0.8 0.5 0.25 0.8 temp2.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacadd temp.tac temp2.tac 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacren temp.tac 3 small__
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d -beta=0.8 -fit=output_fit.tac temp.tac lvcav muscle output2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -ovr -tac=muscle temp1.res output2.res 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp1.res output1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output1.ift "beta" 0.8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output1.ift "ptMBF" 1.2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output1.ift "PTF" 0.6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output1.ift "Va" 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output1.ift "rMBF" 0.72
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

paradd -ovr -tac=small temp2.res output2.res 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift temp2.res output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output2.ift "ptMBF" 0.8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output2.ift "PTF" 0.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output2.ift "Va" 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output2.ift "rMBF" 0.4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.5 -rel=0.5 temp.tac output_fit.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Fit TAC simulated with realistic PET frames. \n"
printf " Test case 2: Plot fitted TACs. \n"
printf " Expected result: Results are relatively close to correct. \n\n"

rm -f output3.res output3.svg

simframe temp.tac frames.dat pet.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -beta=0.8 -svg=output3.svg pet.tac lvcav muscle output3.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -wss=n -abs=0.02 -rel=0.05 output2.res output3.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Estimate SD and CL. \n"
printf " Expected result: SD and CL are saved in result file. \n\n"

rm -f output3b.res output3b.svg

$PROGRAM -sd=y -cl=y -beta=0.8 -svg=output3b.svg pet.tac lvcav muscle output3b.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -sd=n -cl=n -wss=n -abs=0.01 -rel=0.01 output3.res output3b.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -sd=y -wss=n -abs=0.01 -rel=0.01 output3.res output3b.res
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -cl=y -wss=n -abs=0.01 -rel=0.01 output3.res output3b.res
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Reduce fit time with option -end. \n"
printf " Expected result: Correct fit end time is used. \n\n"

rm -f output3c.res output3c.svg output3c.ift output_ca3.tac

$PROGRAM -d2 -end=360 -beta=0.8 -input=output_ca3.tac -svg=output3c.svg pet.tac lvcav muscle output3c.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -wss=n -abs=0.04 -rel=0.10 output3.res output3c.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output3c.res output3c.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output3c.ift "fit_end" 6.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output3c.ift "fit_start" 0.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Create limits file, that does not pre-exist. \n"
printf " Expected result: Correct limits file is created. \n\n"

rm -f test.lim

$PROGRAM -lim=test.lim
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 test.lim "ptMBF_lower" 0.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 test.lim "ptMBF_upper" 10.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 test.lim "PTF_lower" 0.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 test.lim "PTF_upper" 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 test.lim "Va_lower" 0.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 test.lim "Va_upper" 0.99
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case: Try to create limits file, that does pre-exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -lim=test.lim &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "parameter constraint file test.lim exists."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.2 \n"
printf " Test case: Va is fixed using limit file. \n"
printf " Expected result: Results contain requested Va. \n\n"

rm -f test.lim output.res output.ift

printf "Va_lower := 0.05\n" >  test.lim
printf "Va_upper := 0.05\n" >> test.lim

$PROGRAM -d3 -lim=test.lim -beta=0.8 pet.tac lvcav muscle output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output.res output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift "Va" 0.05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   Basic usability tests passed! \n"
printf "   Now testing error handling. \n"
printf "===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -nonexistingoption pet.tac lvcav muscle output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-nonexistingoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM  lvcav muscle output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM pet.tac  muscle output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM pet.tac lvcav  output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM pet.tac lvcav muscle  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.0 \n"
printf " Test case: Nonexisting data file. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.dat lvcav muscle output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 \n"
printf " Test case: Nonexisting LV cavity region. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM pet.tac meh muscle output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "cannot find lvcav region."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.2 \n"
printf " Test case: Nonexisting whole muscle region. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM pet.tac lvcav meh output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "cannot find myoc region."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.2.0 \n"
printf " Test case: Invalid data file contents. \n"
printf " Expected result: Error. \n\n"

rm -f badfile.dat
printf "# badfile\n"  > badfile.dat
printf "ugh banzai\n" >> badfile.dat
printf "2 meh\n"      >> badfile.dat

rm -f stdout.txt
$PROGRAM badfile.dat lvcav muscle output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'badfile.dat'" "wrong format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Data units \n"
printf "===================================================================\n"

printf "\n 3.0.0 \n"
printf " Test case: Data file has times in minutes. \n"
printf " Expected result: automatic conversion, correct result. \n\n"

cp pet.tac pet_min.tac
rm -f output_min.res output_min.svg
tacunit -xconv=min pet_min.tac 

$PROGRAM -beta=0.8 -svg=output_min.svg pet_min.tac lvcav muscle output_min.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -sd=n -cl=n -wss=n -abs=0.01 -rel=0.01 output3.res output_min.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Weights \n"
printf "===================================================================\n"

printf "\n not tested. \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

