#!/bin/bash
#: Title      : test_e63emhdr
#: Date       : 2017-03-05
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e63emhdr$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


if [ ! -f ecat63.img ]; then
  rm -f test1.dat test2.dat ecat63.img

  printf "\n Creating test image \n"
  echo 1 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 > test1.dat
  echo 1 6 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 > test2.dat

  dft2img -scanner=931 -dim=64 -nodecay test1.dat plane1.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=931 -dim=64 -nodecay test2.dat plane2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd frame1.img plane1.img plane2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc frame1.img x 1.5 frame2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat frame1.img frame2.img ecat63.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f header.ift ]; then
  printf "\n Creating header file \n"
  echo patient_name := Einstein Albert   > header.ift
  echo radiopharmaceutical := O-15 WATER >>header.ift
  echo study_description := brain scan   >>header.ift
  echo facility_name := Turku PET Centre >>header.ift
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Edit image with header file. \n"
printf " Expected result: Header fields are changed. \n\n"


rm -f edited.img newheader.ift
cp -f ecat63.img edited.img
$PROGRAM edited.img header.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.img > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift patient_name "Einstein Albert"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift radiopharmaceutical "O-15 WATER"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift study_description "brain scan"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift facility_name "Turku PET Centre"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "=====================================================================\n"

printf "\n 1.1.0 \n"
printf " Test case: Edit image with command-line arguments. \n"
printf " Expected result: Header fields are changed. \n\n"


rm -f edited.img newheader.ift
cp -f ecat63.img edited.img
$PROGRAM edited.img radiopharmaceutical := O-15 WATER
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.img > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift radiopharmaceutical "O-15 WATER"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.0 \n"
printf " Test case: Try to set scan start time. \n"
printf " Expected result: Header fields are changed. \n\n"

rm -f edited.img newheader.ift
cp -f ecat63.img edited.img
$PROGRAM edited.img scan_start_time := 2014-09-04 11:15:13
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.img > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift scan_start_time "2014-09-04 11:15:13"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case: Try to unset scan start time. \n"
printf " Expected result: Header fields are changed. \n\n"

rm -f newheader.ift
$PROGRAM edited.img scan_start_time := 1970-01-01 00:00:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.img > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift scan_start_time "1970-01-01 00:00:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

